/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.store;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import tech.tablesaw.columns.Column;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.table.Relation;

public class TableMetadata {
    private static final Gson GSON = new Gson();
    private final String name;
    private final int rowCount;
    private final List<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();

    public TableMetadata(Relation table) {
        this.name = table.name();
        this.rowCount = table.rowCount();
        for (Column column : table.columns()) {
            this.columnMetadataList.add(new ColumnMetadata(column));
        }
    }

    public static TableMetadata fromJson(String jsonString) {
        return (TableMetadata)GSON.fromJson(jsonString, TableMetadata.class);
    }

    public String toJson() {
        return GSON.toJson((Object)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableMetadata that = (TableMetadata)o;
        return this.rowCount == that.rowCount && Objects.equals(this.name, that.name) && Objects.equals(this.columnMetadataList, that.columnMetadataList);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.rowCount, this.columnMetadataList);
    }

    public String getName() {
        return this.name;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public List<ColumnMetadata> getColumnMetadataList() {
        return this.columnMetadataList;
    }
}

