/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api.ml.features;

import smile.projection.PCA;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.util.DoubleArrays;

public class PrincipalComponents {
    private final PCA pca;

    private PrincipalComponents(double[][] data, boolean useCorrelationMatrix) {
        this.pca = new PCA(data, useCorrelationMatrix);
    }

    public static PrincipalComponents create(boolean useCorrelationMatrix, NumericColumn ... columns) {
        double[][] data = DoubleArrays.to2dArray(columns);
        return new PrincipalComponents(data, useCorrelationMatrix);
    }

    public double[] getCenter() {
        return this.pca.getCenter();
    }

    public double[] getCumulativeVarianceProportion() {
        return this.pca.getCumulativeVarianceProportion();
    }

    public double[] getVarianceProportion() {
        return this.pca.getVarianceProportion();
    }

    public double[] getVariance() {
        return this.pca.getVariance();
    }

    public double[] project(double[] x) {
        return this.pca.project(x);
    }

    public double[][] project(double[][] x) {
        return this.pca.project(x);
    }

    public double[][] getLoadings() {
        return this.pca.getLoadings().array();
    }

    public double[][] getProjection() {
        return this.pca.getProjection().array();
    }

    public PCA setProjection(int p) {
        return this.pca.setProjection(p);
    }

    public PCA setProjection(double p) {
        return this.pca.setProjection(p);
    }
}

