/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.booleans.BooleanSet;
import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Iterator;
import java.util.Map;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.BooleanColumnUtils;
import tech.tablesaw.columns.Column;
import tech.tablesaw.filtering.BooleanPredicate;
import tech.tablesaw.io.TypeUtils;
import tech.tablesaw.mapping.BooleanMapUtils;
import tech.tablesaw.store.ColumnMetadata;
import tech.tablesaw.util.BitmapBackedSelection;
import tech.tablesaw.util.Selection;

public class BooleanColumn
extends AbstractColumn
implements BooleanMapUtils {
    public static final byte MISSING_VALUE = -128;
    private static final int BYTE_SIZE = 1;
    private static int DEFAULT_ARRAY_SIZE = 128;
    private ByteComparator reverseByteComparator = new ByteComparator(){

        public int compare(Byte o1, Byte o2) {
            return Byte.compare(o2, o1);
        }

        public int compare(byte o1, byte o2) {
            return Byte.compare(o2, o1);
        }
    };
    private ByteArrayList data;
    IntComparator comparator = new IntComparator(){

        public int compare(Integer r1, Integer r2) {
            return this.compare((int)r1, (int)r2);
        }

        public int compare(int r1, int r2) {
            boolean f1 = BooleanColumn.this.get(r1);
            boolean f2 = BooleanColumn.this.get(r2);
            return Boolean.compare(f1, f2);
        }
    };

    public BooleanColumn(ColumnMetadata metadata) {
        super(metadata);
        this.data = new ByteArrayList(DEFAULT_ARRAY_SIZE);
    }

    public BooleanColumn(String name) {
        this(name, new ByteArrayList(DEFAULT_ARRAY_SIZE));
    }

    public BooleanColumn(String name, int initialSize) {
        this(name, new ByteArrayList(initialSize));
    }

    public BooleanColumn(String name, ByteArrayList values) {
        super(name);
        this.data = values;
    }

    public BooleanColumn(String name, Selection hits, int columnSize) {
        super(name);
        if (columnSize == 0) {
            return;
        }
        ByteArrayList data = new ByteArrayList(columnSize);
        for (int i = 0; i < columnSize; ++i) {
            data.add((byte)0);
        }
        IntIterator intIterator = hits.iterator();
        while (intIterator.hasNext()) {
            Integer hit = (Integer)intIterator.next();
            byte b = 1;
            int i = hit;
            data.set(i, b);
        }
        this.data = data;
    }

    public static boolean convert(String stringValue) {
        if (Strings.isNullOrEmpty((String)stringValue) || TypeUtils.MISSING_INDICATORS.contains((Object)stringValue)) {
            return (Boolean)ColumnType.BOOLEAN.getMissingValue();
        }
        if (TypeUtils.TRUE_STRINGS.contains(stringValue)) {
            return true;
        }
        if (TypeUtils.FALSE_STRINGS.contains(stringValue)) {
            return false;
        }
        throw new IllegalArgumentException("Attempting to convert non-boolean value " + stringValue + " to Boolean");
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Table summary() {
        Byte2IntOpenHashMap counts = new Byte2IntOpenHashMap(3);
        counts.put((byte)0, 0);
        counts.put((byte)1, 0);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            counts.put(next, counts.get(next) + 1);
        }
        Table table = Table.create(this.name());
        BooleanColumn booleanColumn = new BooleanColumn("Value");
        IntColumn countColumn = new IntColumn("Count");
        table.addColumn(booleanColumn);
        table.addColumn(countColumn);
        for (Map.Entry entry : counts.byte2IntEntrySet()) {
            booleanColumn.append((Byte)entry.getKey());
            countColumn.append((Integer)entry.getValue());
        }
        return table;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getByte(i) != -128) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        ByteOpenHashSet count = new ByteOpenHashSet(3);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            count.add(next);
        }
        return count.size();
    }

    @Override
    public BooleanColumn unique() {
        ByteOpenHashSet count = new ByteOpenHashSet(3);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            count.add(next);
        }
        ByteArrayList list = new ByteArrayList((ByteCollection)count);
        return new BooleanColumn(this.name() + " Unique values", list);
    }

    @Override
    public ColumnType type() {
        return ColumnType.BOOLEAN;
    }

    public void append(boolean b) {
        if (b) {
            this.data.add((byte)1);
        } else {
            this.data.add((byte)0);
        }
    }

    public void append(byte b) {
        this.data.add(b);
    }

    @Override
    public String getString(int row) {
        return String.valueOf(this.get(row));
    }

    @Override
    public BooleanColumn emptyCopy() {
        BooleanColumn column = new BooleanColumn(this.name());
        column.setComment(this.comment());
        return column;
    }

    @Override
    public BooleanColumn emptyCopy(int rowSize) {
        BooleanColumn column = new BooleanColumn(this.name(), rowSize);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public BooleanColumn copy() {
        BooleanColumn column = new BooleanColumn(this.name(), this.data);
        column.setComment(this.comment());
        return column;
    }

    @Override
    public void sortAscending() {
        ByteArrays.mergeSort((byte[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        ByteArrays.mergeSort((byte[])this.data.elements(), (ByteComparator)this.reverseByteComparator);
    }

    @Override
    public void appendCell(String object) {
        try {
            this.append(BooleanColumn.convert(object));
        }
        catch (NullPointerException e) {
            throw new RuntimeException(this.name() + ": " + String.valueOf(object) + ": " + e.getMessage());
        }
    }

    public Boolean get(int i) {
        byte b = this.data.getByte(i);
        if (b == 1) {
            return Boolean.TRUE;
        }
        if (b == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    public byte getByte(int i) {
        return this.data.getByte(i);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int countTrue() {
        int count = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte b = (Byte)byteListIterator.next();
            if (b != 1) continue;
            ++count;
        }
        return count;
    }

    public int countFalse() {
        int count = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte b = (Byte)byteListIterator.next();
            if (b != 0) continue;
            ++count;
        }
        return count;
    }

    public Selection isFalse() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isTrue() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 1) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public Selection isEqualTo(BooleanColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteIterator booleanIterator = other.byteIterator();
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == booleanIterator.nextByte()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public ByteArrayList data() {
        return this.data;
    }

    public void set(int i, boolean b) {
        this.data.set(i, b ? (byte)1 : 0);
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public void append(Column column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        BooleanColumn booleanColumn = (BooleanColumn)column;
        for (int i = 0; i < booleanColumn.size(); ++i) {
            this.append(booleanColumn.get(i));
        }
    }

    @Override
    public double[] toDoubleArray() {
        double[] output = new double[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getByte(i);
        }
        return output;
    }

    @Override
    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.title());
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 0) {
                builder.append(String.valueOf(false));
            } else if (next == 1) {
                builder.append(String.valueOf(true));
            } else {
                builder.append(String.valueOf("NA"));
            }
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public Selection isMissing() {
        return this.select(BooleanColumnUtils.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.select(BooleanColumnUtils.isNotMissing);
    }

    public Iterator<Boolean> iterator() {
        return new BooleanColumnIterator(this.byteIterator());
    }

    public ByteIterator byteIterator() {
        return this.data.iterator();
    }

    public String toString() {
        return "Boolean column: " + this.name();
    }

    public BooleanSet asSet() {
        BooleanOpenHashSet set = new BooleanOpenHashSet(3);
        BooleanColumn unique = this.unique();
        for (int i = 0; i < unique.size(); ++i) {
            set.add(unique.get(i));
        }
        return set;
    }

    public boolean contains(boolean aBoolean) {
        return this.data().contains((Object)aBoolean);
    }

    @Override
    public int byteSize() {
        return 1;
    }

    @Override
    public byte[] asBytes(int row) {
        byte[] result = new byte[]{(byte)(this.get(row) != false ? 1 : 0)};
        return result;
    }

    public Selection select(BooleanPredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            byte next = this.data.getByte(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    public int[] toIntArray() {
        int[] output = new int[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.data.getByte(i);
        }
        return output;
    }

    public IntColumn toIntColumn() {
        IntColumn intColumn = new IntColumn(this.name() + ": ints", this.size());
        ByteArrayList data = this.data();
        for (int i = 0; i < this.size(); ++i) {
            intColumn.append(data.getByte(i));
        }
        return intColumn;
    }

    private static class BooleanColumnIterator
    implements Iterator<Boolean> {
        final ByteIterator iterator;

        BooleanColumnIterator(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Boolean next() {
            byte b = this.iterator.nextByte();
            if (b == 0) {
                return false;
            }
            if (b == 1) {
                return true;
            }
            return null;
        }
    }
}

