/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.util.collections;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.BoundType;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import tech.tablesaw.util.collections.AbstractIntRangeSet;
import tech.tablesaw.util.collections.IntCut;
import tech.tablesaw.util.collections.IntRange;
import tech.tablesaw.util.collections.IntRangeSet;

public class IntTreeRangeSet
extends AbstractIntRangeSet {
    final NavigableMap<IntCut, IntRange> rangesByLowerBound;
    private transient Set<IntRange> asRanges;
    private transient IntRangeSet complement;

    private IntTreeRangeSet(NavigableMap<IntCut, IntRange> rangesByLowerCut) {
        this.rangesByLowerBound = rangesByLowerCut;
    }

    public static IntTreeRangeSet create() {
        return new IntTreeRangeSet(new TreeMap<IntCut, IntRange>());
    }

    public static IntTreeRangeSet create(IntRangeSet rangeSet) {
        IntTreeRangeSet result = IntTreeRangeSet.create();
        result.addAll(rangeSet);
        return result;
    }

    private static BoundType boundTypeForBoolean(boolean inclusive) {
        return inclusive ? BoundType.CLOSED : BoundType.OPEN;
    }

    private static IntRange valueOrNull(@Nullable Map.Entry<IntCut, IntRange> entry) {
        return entry == null ? null : entry.getValue();
    }

    @Override
    public Set<IntRange> asRanges() {
        AsRanges result = this.asRanges;
        return result == null ? (this.asRanges = new AsRanges()) : result;
    }

    @Override
    @Nullable
    public IntRange rangeContaining(int value) {
        Preconditions.checkNotNull((Object)value);
        Map.Entry<IntCut, IntRange> floorEntry = this.rangesByLowerBound.floorEntry(IntCut.belowValue(value));
        if (floorEntry != null && floorEntry.getValue().contains(value)) {
            return floorEntry.getValue();
        }
        return null;
    }

    @Override
    public boolean encloses(IntRange range) {
        Preconditions.checkNotNull((Object)range);
        Map.Entry<IntCut, IntRange> floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        return floorEntry != null && floorEntry.getValue().encloses(range);
    }

    @Nullable
    private IntRange rangeEnclosing(IntRange range) {
        Preconditions.checkNotNull((Object)range);
        Map.Entry<IntCut, IntRange> floorEntry = this.rangesByLowerBound.floorEntry(range.lowerBound);
        return floorEntry != null && floorEntry.getValue().encloses(range) ? floorEntry.getValue() : null;
    }

    @Override
    public IntRange span() {
        Map.Entry<IntCut, IntRange> firstEntry = this.rangesByLowerBound.firstEntry();
        Map.Entry<IntCut, IntRange> lastEntry = this.rangesByLowerBound.lastEntry();
        if (firstEntry == null) {
            throw new NoSuchElementException();
        }
        return IntRange.create(firstEntry.getValue().lowerBound, lastEntry.getValue().upperBound);
    }

    @Override
    public void add(IntRange rangeToAdd) {
        Map.Entry<IntCut, IntRange> entryBelowUB;
        Preconditions.checkNotNull((Object)rangeToAdd);
        if (rangeToAdd.isEmpty()) {
            return;
        }
        IntCut lbToAdd = rangeToAdd.lowerBound;
        IntCut ubToAdd = rangeToAdd.upperBound;
        Map.Entry<IntCut, IntRange> entryBelowLB = this.rangesByLowerBound.lowerEntry(lbToAdd);
        if (entryBelowLB != null) {
            IntRange rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(lbToAdd) >= 0) {
                if (rangeBelowLB.upperBound.compareTo(ubToAdd) >= 0) {
                    ubToAdd = rangeBelowLB.upperBound;
                }
                lbToAdd = rangeBelowLB.lowerBound;
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(ubToAdd)) != null) {
            IntRange rangeBelowUB = entryBelowUB.getValue();
            if (rangeBelowUB.upperBound.compareTo(ubToAdd) >= 0) {
                ubToAdd = rangeBelowUB.upperBound;
            }
        }
        this.rangesByLowerBound.subMap(lbToAdd, ubToAdd).clear();
        this.replaceRangeWithSameLowerBound(IntRange.create(lbToAdd, ubToAdd));
    }

    @Override
    public void remove(IntRange rangeToRemove) {
        Map.Entry<IntCut, IntRange> entryBelowUB;
        Preconditions.checkNotNull((Object)rangeToRemove);
        if (rangeToRemove.isEmpty()) {
            return;
        }
        Map.Entry<IntCut, IntRange> entryBelowLB = this.rangesByLowerBound.lowerEntry(rangeToRemove.lowerBound);
        if (entryBelowLB != null) {
            IntRange rangeBelowLB = entryBelowLB.getValue();
            if (rangeBelowLB.upperBound.compareTo(rangeToRemove.lowerBound) >= 0) {
                if (rangeToRemove.hasUpperBound() && rangeBelowLB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                    this.replaceRangeWithSameLowerBound(IntRange.create(rangeToRemove.upperBound, rangeBelowLB.upperBound));
                }
                this.replaceRangeWithSameLowerBound(IntRange.create(rangeBelowLB.lowerBound, rangeToRemove.lowerBound));
            }
        }
        if ((entryBelowUB = this.rangesByLowerBound.floorEntry(rangeToRemove.upperBound)) != null) {
            IntRange rangeBelowUB = entryBelowUB.getValue();
            if (rangeToRemove.hasUpperBound() && rangeBelowUB.upperBound.compareTo(rangeToRemove.upperBound) >= 0) {
                this.replaceRangeWithSameLowerBound(IntRange.create(rangeToRemove.upperBound, rangeBelowUB.upperBound));
            }
        }
        this.rangesByLowerBound.subMap(rangeToRemove.lowerBound, rangeToRemove.upperBound).clear();
    }

    private void replaceRangeWithSameLowerBound(IntRange range) {
        if (range.isEmpty()) {
            this.rangesByLowerBound.remove(range.lowerBound);
        } else {
            this.rangesByLowerBound.put(range.lowerBound, range);
        }
    }

    @Override
    public IntRangeSet complement() {
        IntRangeSet result = this.complement;
        return result == null ? (this.complement = new Complement()) : result;
    }

    @Override
    public IntRangeSet subRangeSet(IntRange view) {
        return view.equals(IntRange.all()) ? this : new SubRangeSetInt(view);
    }

    private final class SubRangeSetInt
    extends IntTreeRangeSet {
        private final IntRange restriction;

        SubRangeSetInt(IntRange restriction) {
            super(new SubRangeSetRangesByLowerBound(IntRange.all(), restriction, IntTreeRangeSet.this.rangesByLowerBound));
            this.restriction = restriction;
        }

        @Override
        public boolean encloses(IntRange range) {
            if (!this.restriction.isEmpty() && this.restriction.encloses(range)) {
                IntRange enclosing = IntTreeRangeSet.this.rangeEnclosing(range);
                return enclosing != null && !enclosing.intersection(this.restriction).isEmpty();
            }
            return false;
        }

        @Override
        @Nullable
        public IntRange rangeContaining(int value) {
            if (!this.restriction.contains(value)) {
                return null;
            }
            IntRange result = IntTreeRangeSet.this.rangeContaining(value);
            return result == null ? null : result.intersection(this.restriction);
        }

        @Override
        public void add(IntRange rangeToAdd) {
            Preconditions.checkArgument((boolean)this.restriction.encloses(rangeToAdd), (String)"Cannot add range %s to subRangeSet(%s)", (Object)rangeToAdd, (Object)this.restriction);
            super.add(rangeToAdd);
        }

        @Override
        public void remove(IntRange rangeToRemove) {
            if (rangeToRemove.isConnected(this.restriction)) {
                IntTreeRangeSet.this.remove(rangeToRemove.intersection(this.restriction));
            }
        }

        @Override
        public boolean contains(int value) {
            return this.restriction.contains(value) && IntTreeRangeSet.this.contains(value);
        }

        @Override
        public void clear() {
            IntTreeRangeSet.this.remove(this.restriction);
        }

        @Override
        public IntRangeSet subRangeSet(IntRange view) {
            if (view.encloses(this.restriction)) {
                return this;
            }
            if (view.isConnected(this.restriction)) {
                return new SubRangeSetInt(this.restriction.intersection(view));
            }
            return new IntTreeRangeSet(new TreeMap());
        }
    }

    private final class Complement
    extends IntTreeRangeSet {
        Complement() {
            super(new ComplementRangesByLowerBound(IntTreeRangeSet.this.rangesByLowerBound));
        }

        @Override
        public void add(IntRange rangeToAdd) {
            IntTreeRangeSet.this.remove(rangeToAdd);
        }

        @Override
        public void remove(IntRange rangeToRemove) {
            IntTreeRangeSet.this.add(rangeToRemove);
        }

        @Override
        public boolean contains(int value) {
            return !IntTreeRangeSet.this.contains(value);
        }

        @Override
        public IntRangeSet complement() {
            return IntTreeRangeSet.this;
        }
    }

    final class AsRanges
    extends ForwardingCollection<IntRange>
    implements Set<IntRange> {
        AsRanges() {
        }

        protected Collection<IntRange> delegate() {
            return IntTreeRangeSet.this.rangesByLowerBound.values();
        }
    }

    private static final class SubRangeSetRangesByLowerBound
    extends TreeMap<IntCut, IntRange> {
        private final IntRange lowerBoundWindow;
        private final IntRange restriction;
        private final NavigableMap<IntCut, IntRange> rangesByLowerBound;
        private final NavigableMap<IntCut, IntRange> rangesByUpperBound;

        private SubRangeSetRangesByLowerBound(IntRange lowerBoundWindow, IntRange restriction, NavigableMap<IntCut, IntRange> rangesByLowerBound) {
            this.lowerBoundWindow = (IntRange)Preconditions.checkNotNull((Object)lowerBoundWindow);
            this.restriction = (IntRange)Preconditions.checkNotNull((Object)restriction);
            this.rangesByLowerBound = (NavigableMap)Preconditions.checkNotNull(rangesByLowerBound);
            this.rangesByUpperBound = new RangesByUpperBound(rangesByLowerBound);
        }

        private NavigableMap<IntCut, IntRange> subMap(IntRange window) {
            if (!window.isConnected(this.lowerBoundWindow)) {
                return ImmutableSortedMap.of();
            }
            return new SubRangeSetRangesByLowerBound(this.lowerBoundWindow.intersection(window), this.restriction, this.rangesByLowerBound);
        }

        @Override
        public NavigableMap<IntCut, IntRange> subMap(IntCut fromKey, boolean fromInclusive, IntCut toKey, boolean toInclusive) {
            return this.subMap(IntRange.range(fromKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(fromInclusive), toKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(toInclusive)));
        }

        @Override
        public NavigableMap<IntCut, IntRange> headMap(IntCut toKey, boolean inclusive) {
            return this.subMap(IntRange.upTo(toKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(inclusive)));
        }

        @Override
        public NavigableMap<IntCut, IntRange> tailMap(IntCut fromKey, boolean inclusive) {
            return this.subMap(IntRange.downTo(fromKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(inclusive)));
        }

        @Override
        public Comparator<? super IntCut> comparator() {
            return Ordering.natural();
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return this.get(key) != null;
        }

        @Override
        @Nullable
        public IntRange get(@Nullable Object key) {
            if (key instanceof IntCut) {
                try {
                    IntCut cut = (IntCut)key;
                    if (!this.lowerBoundWindow.contains(cut.endpoint()) || cut.compareTo(this.restriction.lowerBound) < 0 || cut.compareTo(this.restriction.upperBound) >= 0) {
                        return null;
                    }
                    if (cut.equals(this.restriction.lowerBound)) {
                        Map.Entry<IntCut, IntRange> entry = this.rangesByLowerBound.floorEntry(cut);
                        IntRange candidate = IntTreeRangeSet.valueOrNull(entry);
                        if (candidate != null && candidate.upperBound.compareTo(this.restriction.lowerBound) > 0) {
                            return candidate.intersection(this.restriction);
                        }
                    } else {
                        IntRange result = (IntRange)this.rangesByLowerBound.get(cut);
                        if (result != null) {
                            return result.intersection(this.restriction);
                        }
                    }
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
            return null;
        }

        Iterator<Map.Entry<IntCut, IntRange>> entryIterator() {
            if (this.restriction.isEmpty()) {
                return Collections.emptyIterator();
            }
            if (this.lowerBoundWindow.upperBound.isLessThan(this.restriction.lowerEndpoint())) {
                return Collections.emptyIterator();
            }
            final Iterator completeRangeItr = this.lowerBoundWindow.lowerBound.isLessThan(this.restriction.lowerEndpoint()) ? this.rangesByUpperBound.tailMap(this.restriction.lowerBound, false).values().iterator() : this.rangesByLowerBound.tailMap(this.lowerBoundWindow.lowerBound(), this.lowerBoundWindow.lowerBoundType() == BoundType.CLOSED).values().iterator();
            final IntCut upperBoundOnLowerBounds = (IntCut)Ordering.natural().min((Object)this.lowerBoundWindow.upperBound, (Object)IntCut.belowValue(this.restriction.upperEndpoint()));
            return new AbstractIterator<Map.Entry<IntCut, IntRange>>(){

                protected Map.Entry<IntCut, IntRange> computeNext() {
                    if (!completeRangeItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    IntRange nextRange = (IntRange)completeRangeItr.next();
                    if (upperBoundOnLowerBounds.isLessThan(nextRange.lowerEndpoint())) {
                        return (Map.Entry)this.endOfData();
                    }
                    nextRange = nextRange.intersection(restriction);
                    return Maps.immutableEntry((Object)nextRange.lowerBound, (Object)nextRange);
                }
            };
        }

        Iterator<Map.Entry<IntCut, IntRange>> descendingEntryIterator() {
            IntCut upperBoundOnLowerBounds;
            if (this.restriction.isEmpty()) {
                return Collections.emptyIterator();
            }
            final Iterator completeRangeItr = this.rangesByLowerBound.headMap(upperBoundOnLowerBounds, (upperBoundOnLowerBounds = (IntCut)Ordering.natural().min((Object)this.lowerBoundWindow.upperBound, (Object)IntCut.belowValue(this.restriction.upperEndpoint()))).typeAsUpperBound() == BoundType.CLOSED).descendingMap().values().iterator();
            return new AbstractIterator<Map.Entry<IntCut, IntRange>>(){

                protected Map.Entry<IntCut, IntRange> computeNext() {
                    if (!completeRangeItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    IntRange nextRange = (IntRange)completeRangeItr.next();
                    if (((SubRangeSetRangesByLowerBound)this).restriction.lowerBound.compareTo(nextRange.upperBound) >= 0) {
                        return (Map.Entry)this.endOfData();
                    }
                    nextRange = nextRange.intersection(restriction);
                    if (lowerBoundWindow.contains(nextRange.lowerEndpoint())) {
                        return Maps.immutableEntry((Object)nextRange.lowerBound, (Object)nextRange);
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public int size() {
            return Iterators.size(this.entryIterator());
        }
    }

    private static final class ComplementRangesByLowerBound
    extends TreeMap<IntCut, IntRange> {
        private final NavigableMap<IntCut, IntRange> positiveRangesByLowerBound;
        private final NavigableMap<IntCut, IntRange> positiveRangesByUpperBound;
        private final IntRange complementLowerBoundWindow;

        ComplementRangesByLowerBound(NavigableMap<IntCut, IntRange> positiveRangesByLowerBound) {
            this(positiveRangesByLowerBound, IntRange.all());
        }

        private ComplementRangesByLowerBound(NavigableMap<IntCut, IntRange> positiveRangesByLowerBound, IntRange window) {
            this.positiveRangesByLowerBound = positiveRangesByLowerBound;
            this.positiveRangesByUpperBound = new RangesByUpperBound(positiveRangesByLowerBound);
            this.complementLowerBoundWindow = window;
        }

        private NavigableMap<IntCut, IntRange> subMap(IntRange subWindow) {
            if (!this.complementLowerBoundWindow.isConnected(subWindow)) {
                return ImmutableSortedMap.of();
            }
            subWindow = subWindow.intersection(this.complementLowerBoundWindow);
            return new ComplementRangesByLowerBound(this.positiveRangesByLowerBound, subWindow);
        }

        @Override
        public NavigableMap<IntCut, IntRange> subMap(IntCut fromKey, boolean fromInclusive, IntCut toKey, boolean toInclusive) {
            return this.subMap(IntRange.range(fromKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(fromInclusive), toKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(toInclusive)));
        }

        @Override
        public NavigableMap<IntCut, IntRange> headMap(IntCut toKey, boolean inclusive) {
            return this.subMap(IntRange.upTo(toKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(inclusive)));
        }

        @Override
        public NavigableMap<IntCut, IntRange> tailMap(IntCut fromKey, boolean inclusive) {
            return this.subMap(IntRange.downTo(fromKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(inclusive)));
        }

        @Override
        public Comparator<? super IntCut> comparator() {
            return Ordering.natural();
        }

        Iterator<Map.Entry<IntCut, IntRange>> entryIterator() {
            IntCut firstComplementRangeLowerBound;
            Collection positiveRanges = this.complementLowerBoundWindow.hasLowerBound() ? this.positiveRangesByUpperBound.tailMap(this.complementLowerBoundWindow.lowerBound(), this.complementLowerBoundWindow.lowerBoundType() == BoundType.CLOSED).values() : this.positiveRangesByUpperBound.values();
            final PeekingIterator positiveItr = Iterators.peekingIterator(positiveRanges.iterator());
            if (this.complementLowerBoundWindow.contains(IntCut.belowAll().endpoint()) && (!positiveItr.hasNext() || ((IntRange)positiveItr.peek()).lowerBound != IntCut.belowAll())) {
                firstComplementRangeLowerBound = IntCut.belowAll();
            } else if (positiveItr.hasNext()) {
                firstComplementRangeLowerBound = ((IntRange)positiveItr.next()).upperBound;
            } else {
                return Collections.emptyIterator();
            }
            return new AbstractIterator<Map.Entry<IntCut, IntRange>>(){
                IntCut nextComplementRangeLowerBound;
                {
                    this.nextComplementRangeLowerBound = firstComplementRangeLowerBound;
                }

                protected Map.Entry<IntCut, IntRange> computeNext() {
                    IntRange negativeRange;
                    if (((ComplementRangesByLowerBound)this).complementLowerBoundWindow.upperBound.isLessThan(this.nextComplementRangeLowerBound.endpoint()) || this.nextComplementRangeLowerBound == IntCut.aboveAll()) {
                        return (Map.Entry)this.endOfData();
                    }
                    if (positiveItr.hasNext()) {
                        IntRange positiveRange = (IntRange)positiveItr.next();
                        negativeRange = IntRange.create(this.nextComplementRangeLowerBound, positiveRange.lowerBound);
                        this.nextComplementRangeLowerBound = positiveRange.upperBound;
                    } else {
                        negativeRange = IntRange.create(this.nextComplementRangeLowerBound, IntCut.aboveAll());
                        this.nextComplementRangeLowerBound = IntCut.aboveAll();
                    }
                    return Maps.immutableEntry((Object)negativeRange.lowerBound, (Object)negativeRange);
                }
            };
        }

        Iterator<Map.Entry<IntCut, IntRange>> descendingEntryIterator() {
            IntCut cut;
            boolean inclusive;
            IntCut startingPoint = this.complementLowerBoundWindow.hasUpperBound() ? this.complementLowerBoundWindow.upperBound() : IntCut.aboveAll();
            final PeekingIterator positiveItr = Iterators.peekingIterator(this.positiveRangesByUpperBound.headMap(startingPoint, inclusive = this.complementLowerBoundWindow.hasUpperBound() && this.complementLowerBoundWindow.upperBoundType() == BoundType.CLOSED).descendingMap().values().iterator());
            if (positiveItr.hasNext()) {
                cut = ((IntRange)positiveItr.peek()).upperBound == IntCut.aboveAll() ? ((IntRange)positiveItr.next()).lowerBound : this.positiveRangesByLowerBound.higherKey(((IntRange)positiveItr.peek()).upperBound);
            } else {
                if (!this.complementLowerBoundWindow.contains(IntCut.belowAll().endpoint()) || this.positiveRangesByLowerBound.containsKey(IntCut.belowAll())) {
                    return Collections.emptyIterator();
                }
                cut = this.positiveRangesByLowerBound.higherKey(IntCut.belowAll());
            }
            final IntCut firstComplementRangeUpperBound = (IntCut)MoreObjects.firstNonNull((Object)cut, (Object)IntCut.aboveAll());
            return new AbstractIterator<Map.Entry<IntCut, IntRange>>(){
                IntCut nextComplementRangeUpperBound;
                {
                    this.nextComplementRangeUpperBound = firstComplementRangeUpperBound;
                }

                protected Map.Entry<IntCut, IntRange> computeNext() {
                    if (this.nextComplementRangeUpperBound == IntCut.belowAll()) {
                        return (Map.Entry)this.endOfData();
                    }
                    if (positiveItr.hasNext()) {
                        IntRange positiveRange = (IntRange)positiveItr.next();
                        IntRange negativeRange = IntRange.create(positiveRange.upperBound, this.nextComplementRangeUpperBound);
                        this.nextComplementRangeUpperBound = positiveRange.lowerBound;
                        if (((ComplementRangesByLowerBound)this).complementLowerBoundWindow.lowerBound.isLessThan(negativeRange.lowerEndpoint())) {
                            return Maps.immutableEntry((Object)negativeRange.lowerBound, (Object)negativeRange);
                        }
                    } else if (((ComplementRangesByLowerBound)this).complementLowerBoundWindow.lowerBound.isLessThan(IntCut.belowAll().endpoint())) {
                        IntRange negativeRange = IntRange.create(IntCut.belowAll(), this.nextComplementRangeUpperBound);
                        this.nextComplementRangeUpperBound = IntCut.belowAll();
                        return Maps.immutableEntry((Object)IntCut.belowAll(), (Object)negativeRange);
                    }
                    return (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public int size() {
            return Iterators.size(this.entryIterator());
        }

        @Override
        @Nullable
        public IntRange get(Object key) {
            if (key instanceof IntCut) {
                try {
                    IntCut cut = (IntCut)key;
                    Map.Entry<IntCut, IntRange> firstEntry = this.tailMap(cut, true).firstEntry();
                    if (firstEntry != null && firstEntry.getKey().equals(cut)) {
                        return firstEntry.getValue();
                    }
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }
    }

    static final class RangesByUpperBound
    extends TreeMap<IntCut, IntRange> {
        private final NavigableMap<IntCut, IntRange> rangesByLowerBound;
        private final IntRange upperBoundWindow;

        RangesByUpperBound(NavigableMap<IntCut, IntRange> rangesByLowerBound) {
            this.rangesByLowerBound = rangesByLowerBound;
            this.upperBoundWindow = IntRange.all();
        }

        private RangesByUpperBound(NavigableMap<IntCut, IntRange> rangesByLowerBound, IntRange upperBoundWindow) {
            this.rangesByLowerBound = rangesByLowerBound;
            this.upperBoundWindow = upperBoundWindow;
        }

        private NavigableMap<IntCut, IntRange> subMap(IntRange window) {
            if (window.isConnected(this.upperBoundWindow)) {
                return new RangesByUpperBound(this.rangesByLowerBound, window.intersection(this.upperBoundWindow));
            }
            return ImmutableSortedMap.of();
        }

        @Override
        public NavigableMap<IntCut, IntRange> subMap(IntCut fromKey, boolean fromInclusive, IntCut toKey, boolean toInclusive) {
            return this.subMap(IntRange.range(fromKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(fromInclusive), toKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(toInclusive)));
        }

        @Override
        public NavigableMap<IntCut, IntRange> headMap(IntCut toKey, boolean inclusive) {
            return this.subMap(IntRange.upTo(toKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(inclusive)));
        }

        @Override
        public NavigableMap<IntCut, IntRange> tailMap(IntCut fromKey, boolean inclusive) {
            return this.subMap(IntRange.downTo(fromKey.endpoint(), IntTreeRangeSet.boundTypeForBoolean(inclusive)));
        }

        @Override
        public Comparator<? super IntCut> comparator() {
            return Ordering.natural();
        }

        @Override
        public boolean containsKey(@Nullable Object key) {
            return this.get(key) != null;
        }

        @Override
        public IntRange get(@Nullable Object key) {
            if (key instanceof IntCut) {
                try {
                    IntCut cut = (IntCut)key;
                    if (!this.upperBoundWindow.contains(cut.endpoint())) {
                        return null;
                    }
                    Map.Entry<IntCut, IntRange> candidate = this.rangesByLowerBound.lowerEntry(cut);
                    if (candidate != null && candidate.getValue().upperBound.equals(cut)) {
                        return candidate.getValue();
                    }
                }
                catch (ClassCastException e) {
                    return null;
                }
            }
            return null;
        }

        Iterator<Map.Entry<IntCut, IntRange>> entryIterator() {
            Map.Entry<IntCut, IntRange> lowerEntry;
            final Iterator backingItr = !this.upperBoundWindow.hasLowerBound() ? this.rangesByLowerBound.values().iterator() : ((lowerEntry = this.rangesByLowerBound.lowerEntry(this.upperBoundWindow.lowerBound())) == null ? this.rangesByLowerBound.values().iterator() : (this.upperBoundWindow.lowerBound.isLessThan(lowerEntry.getValue().upperEndpoint()) ? this.rangesByLowerBound.tailMap(lowerEntry.getKey(), true).values().iterator() : this.rangesByLowerBound.tailMap(this.upperBoundWindow.lowerBound(), true).values().iterator()));
            return new AbstractIterator<Map.Entry<IntCut, IntRange>>(){

                protected Map.Entry<IntCut, IntRange> computeNext() {
                    if (!backingItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    IntRange range = (IntRange)backingItr.next();
                    if (((RangesByUpperBound)this).upperBoundWindow.upperBound.isLessThan(range.upperEndpoint())) {
                        return (Map.Entry)this.endOfData();
                    }
                    return Maps.immutableEntry((Object)range.upperBound, (Object)range);
                }
            };
        }

        Iterator<Map.Entry<IntCut, IntRange>> descendingEntryIterator() {
            Collection candidates = this.upperBoundWindow.hasUpperBound() ? this.rangesByLowerBound.headMap(this.upperBoundWindow.upperBound(), false).descendingMap().values() : this.rangesByLowerBound.descendingMap().values();
            final PeekingIterator backingItr = Iterators.peekingIterator(candidates.iterator());
            if (backingItr.hasNext() && this.upperBoundWindow.upperBound.isLessThan(((IntRange)backingItr.peek()).upperEndpoint())) {
                backingItr.next();
            }
            return new AbstractIterator<Map.Entry<IntCut, IntRange>>(){

                protected Map.Entry<IntCut, IntRange> computeNext() {
                    if (!backingItr.hasNext()) {
                        return (Map.Entry)this.endOfData();
                    }
                    IntRange range = (IntRange)backingItr.next();
                    return ((RangesByUpperBound)this).upperBoundWindow.lowerBound.isLessThan(range.upperEndpoint()) ? Maps.immutableEntry((Object)range.upperBound, (Object)range) : (Map.Entry)this.endOfData();
                }
            };
        }

        @Override
        public int size() {
            if (this.upperBoundWindow.equals(IntRange.all())) {
                return this.rangesByLowerBound.size();
            }
            return Iterators.size(this.entryIterator());
        }

        @Override
        public boolean isEmpty() {
            return this.upperBoundWindow.equals(IntRange.all()) ? this.rangesByLowerBound.isEmpty() : !this.entryIterator().hasNext();
        }
    }
}

