/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.table;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.Column;

public interface Relation {
    public void addColumn(Column ... var1);

    public void setName(String var1);

    default public boolean isEmpty() {
        return this.rowCount() == 0;
    }

    default public String shape() {
        return this.rowCount() + " rows X " + this.columnCount() + " cols";
    }

    default public void removeColumn(int columnIndex) {
        this.removeColumns(this.column(columnIndex));
    }

    public void removeColumns(Column ... var1);

    default public void removeColumns(String ... columnName) {
        Column[] cols = new Column[columnName.length];
        for (int i = 0; i < columnName.length; ++i) {
            cols[i] = this.column(columnName[i]);
        }
        this.removeColumns(cols);
    }

    public Table first(int var1);

    default public int columnIndex(String columnName) {
        int columnIndex = -1;
        for (int i = 0; i < this.columnCount(); ++i) {
            if (!this.columnNames().get(i).equalsIgnoreCase(columnName)) continue;
            columnIndex = i;
            break;
        }
        if (columnIndex == -1) {
            throw new IllegalArgumentException(String.format("Column %s is not present in table %s", columnName, this.name()));
        }
        return columnIndex;
    }

    default public Column column(String columnName) {
        Column result = null;
        for (Column column : this.columns()) {
            String name = column.name().trim();
            if (!name.equalsIgnoreCase(columnName)) continue;
            result = column;
            break;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("Column %s does not exist in table %s", columnName, this.name()));
        }
        return result;
    }

    public Column column(int var1);

    public int columnCount();

    public int rowCount();

    public List<Column> columns();

    public int columnIndex(Column var1);

    public String get(int var1, int var2);

    public String name();

    public void clear();

    public List<String> columnNames();

    default public ColumnType[] columnTypes() {
        ColumnType[] columnTypes = new ColumnType[this.columnCount()];
        for (int i = 0; i < this.columnCount(); ++i) {
            columnTypes[i] = this.columns().get(i).type();
        }
        return columnTypes;
    }

    default public int[] colWidths() {
        int cols = this.columnCount();
        int[] widths = new int[cols];
        for (int i = 0; i < this.columnCount(); ++i) {
            widths[i] = this.columns().get(i).columnWidth();
        }
        return widths;
    }

    default public String print() {
        StringBuilder buf = new StringBuilder();
        int[] colWidths = this.colWidths();
        buf.append(this.name()).append('\n');
        List<String> names = this.columnNames();
        for (int colNum = 0; colNum < this.columnCount(); ++colNum) {
            buf.append(StringUtils.rightPad((String)StringUtils.defaultString((String)String.valueOf(names.get(colNum))), (int)colWidths[colNum]));
            buf.append(' ');
        }
        buf.append('\n');
        for (int r = 0; r < this.rowCount(); ++r) {
            for (int c = 0; c < this.columnCount(); ++c) {
                String cell = StringUtils.rightPad((String)this.get(c, r), (int)colWidths[c]);
                buf.append(cell);
                buf.append(' ');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    default public Table structure() {
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append("Table: ").append(this.name()).append(" - ").append(this.rowCount()).append(" observations (rows) of ").append(this.columnCount()).append(" variables (cols)");
        Table structure = Table.create(nameBuilder.toString());
        structure.addColumn(new IntColumn("Index"));
        structure.addColumn(new CategoryColumn("Column Name"));
        structure.addColumn(new CategoryColumn("Type"));
        structure.addColumn(new IntColumn("Unique Values"));
        structure.addColumn(new CategoryColumn("First"));
        structure.addColumn(new CategoryColumn("Last"));
        for (Column column : this.columns()) {
            structure.intColumn("Index").append(this.columnIndex(column));
            structure.categoryColumn("Column Name").add(column.name());
            structure.categoryColumn("Type").add(column.type().name());
            structure.intColumn("Unique Values").append(column.countUnique());
            structure.categoryColumn("First").add(column.first());
            structure.categoryColumn("Last").add(column.getString(column.size() - 1));
        }
        return structure;
    }

    default public String summary() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n").append("Table summary for: ").append(this.name()).append("\n");
        for (Column column : this.columns()) {
            builder.append(column.summary().print());
            builder.append("\n");
        }
        builder.append("\n");
        return builder.toString();
    }

    default public BooleanColumn booleanColumn(int columnIndex) {
        return (BooleanColumn)this.column(columnIndex);
    }

    default public BooleanColumn booleanColumn(String columnName) {
        return (BooleanColumn)this.column(columnName);
    }

    default public NumericColumn numericColumn(int columnIndex) {
        Column c = this.column(columnIndex);
        if (c.type() == ColumnType.CATEGORY) {
            CategoryColumn categoryColumn = (CategoryColumn)c;
            return categoryColumn.toIntColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            BooleanColumn booleanColumn = (BooleanColumn)c;
            return booleanColumn.toIntColumn();
        }
        return (NumericColumn)this.column(columnIndex);
    }

    default public NumericColumn numericColumn(String columnName) {
        Column c = this.column(columnName);
        if (c.type() == ColumnType.CATEGORY) {
            CategoryColumn categoryColumn = (CategoryColumn)c;
            return categoryColumn.toIntColumn();
        }
        if (c.type() == ColumnType.BOOLEAN) {
            BooleanColumn booleanColumn = (BooleanColumn)c;
            return booleanColumn.toIntColumn();
        }
        return (NumericColumn)this.column(columnName);
    }

    default public NumericColumn nCol(String columnName) {
        return this.numericColumn(columnName);
    }

    default public NumericColumn nCol(int columnIndex) {
        return this.numericColumn(columnIndex);
    }

    default public FloatColumn floatColumn(int columnIndex) {
        return (FloatColumn)this.column(columnIndex);
    }

    default public FloatColumn floatColumn(String columnName) {
        return (FloatColumn)this.column(columnName);
    }

    default public DoubleColumn doubleColumn(int columnIndex) {
        return (DoubleColumn)this.column(columnIndex);
    }

    default public DoubleColumn doubleColumn(String columnName) {
        return (DoubleColumn)this.column(columnName);
    }

    default public IntColumn intColumn(String columnName) {
        return (IntColumn)this.column(columnName);
    }

    default public IntColumn intColumn(int columnIndex) {
        return (IntColumn)this.column(columnIndex);
    }

    default public ShortColumn shortColumn(String columnName) {
        return (ShortColumn)this.column(columnName);
    }

    default public ShortColumn shortColumn(int columnIndex) {
        return (ShortColumn)this.column(columnIndex);
    }

    default public LongColumn longColumn(String columnName) {
        return (LongColumn)this.column(columnName);
    }

    default public LongColumn longColumn(int columnIndex) {
        return (LongColumn)this.column(columnIndex);
    }

    default public DateColumn dateColumn(int columnIndex) {
        return (DateColumn)this.column(columnIndex);
    }

    default public DateColumn dateColumn(String columnName) {
        return (DateColumn)this.column(columnName);
    }

    default public TimeColumn timeColumn(String columnName) {
        return (TimeColumn)this.column(columnName);
    }

    default public TimeColumn timeColumn(int columnIndex) {
        return (TimeColumn)this.column(columnIndex);
    }

    default public CategoryColumn categoryColumn(String columnName) {
        return (CategoryColumn)this.column(columnName);
    }

    default public CategoryColumn categoryColumn(int columnIndex) {
        return (CategoryColumn)this.column(columnIndex);
    }

    default public DateTimeColumn dateTimeColumn(int columnIndex) {
        return (DateTimeColumn)this.column(columnIndex);
    }

    default public DateTimeColumn dateTimeColumn(String columnName) {
        return (DateTimeColumn)this.column(columnName);
    }
}

