/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.mapping;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.api.CategoryColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.columns.Column;

public interface StringMapUtils
extends Column {
    default public CategoryColumn upperCase() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[ucase]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            if (value == null) {
                newColumn.add(null);
                continue;
            }
            newColumn.add(value.toUpperCase());
        }
        return newColumn;
    }

    default public CategoryColumn lowerCase() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[lcase]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(value.toLowerCase());
        }
        return newColumn;
    }

    default public CategoryColumn trim() {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[trim]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(value.trim());
        }
        return newColumn;
    }

    default public CategoryColumn replaceAll(String regex, String replacement) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[repl]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(value.replaceAll(regex, replacement));
        }
        return newColumn;
    }

    default public CategoryColumn replaceFirst(String regex, String replacement) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[repl]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(value.replaceFirst(regex, replacement));
        }
        return newColumn;
    }

    default public CategoryColumn substring(int start, int end) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[sub]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(value.substring(start, end));
        }
        return newColumn;
    }

    default public CategoryColumn substring(int start) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[sub]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(value.substring(start));
        }
        return newColumn;
    }

    default public CategoryColumn abbreviate(int maxWidth) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[abbr]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(StringUtils.abbreviate((String)value, (int)maxWidth));
        }
        return newColumn;
    }

    default public CategoryColumn padEnd(int minLength, char padChar) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[pad]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(Strings.padEnd((String)value, (int)minLength, (char)padChar));
        }
        return newColumn;
    }

    default public CategoryColumn padStart(int minLength, char padChar) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + "[pad]");
        for (int r = 0; r < this.size(); ++r) {
            String value = this.getString(r);
            newColumn.add(Strings.padStart((String)value, (int)minLength, (char)padChar));
        }
        return newColumn;
    }

    default public CategoryColumn commonPrefix(Column column2) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + column2.name() + "[prefix]");
        for (int r = 0; r < this.size(); ++r) {
            String value1 = this.getString(r);
            String value2 = column2.getString(r);
            newColumn.add(Strings.commonPrefix((CharSequence)value1, (CharSequence)value2));
        }
        return newColumn;
    }

    default public CategoryColumn commonSuffix(Column column2) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + column2.name() + "[suffix]");
        for (int r = 0; r < this.size(); ++r) {
            String value1 = this.getString(r);
            String value2 = column2.getString(r);
            newColumn.add(Strings.commonSuffix((CharSequence)value1, (CharSequence)value2));
        }
        return newColumn;
    }

    default public Column distance(Column column2) {
        FloatColumn newColumn = new FloatColumn(this.name() + column2.name() + "[distance]");
        for (int r = 0; r < this.size(); ++r) {
            String value1 = this.getString(r);
            String value2 = column2.getString(r);
            newColumn.append(StringUtils.getLevenshteinDistance((CharSequence)value1, (CharSequence)value2));
        }
        return newColumn;
    }

    default public CategoryColumn join(Column column2, String delimiter) {
        CategoryColumn newColumn = new CategoryColumn(this.name() + column2.name() + "[join]");
        for (int r = 0; r < this.size(); ++r) {
            Object[] values = new String[]{this.getString(r), column2.getString(r)};
            newColumn.add(StringUtils.join((Object[])values, (String)delimiter));
        }
        return newColumn;
    }
}

