/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.csv;

import com.opencsv.CSVReader;
import com.opencsv.CSVWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CsvCombiner {
    private CsvCombiner() {
    }

    public static void combineAll(String foldername, String newFileName, char columnSeparator, boolean headers) throws IOException {
        FileWriter fileWriter = new FileWriter(newFileName);
        try (CSVWriter writer = new CSVWriter((Writer)fileWriter, ',');){
            boolean[] skipHeader = new boolean[]{false};
            Files.walk(Paths.get(foldername, new String[0]), new FileVisitOption[0]).forEach(filePath -> {
                if (Files.isRegularFile(filePath, new LinkOption[0]) && filePath.toString().endsWith(".csv")) {
                    CsvCombiner.append(filePath.toString(), writer, columnSeparator, headers && skipHeader[0]);
                    skipHeader[0] = true;
                }
            });
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void append(String fileName, CSVWriter writer, char columnSeparator, boolean skipHeader) {
        CSVReader reader = null;
        try {
            String[] nextLine;
            reader = new CSVReader((Reader)new FileReader(fileName), columnSeparator);
            if (skipHeader) {
                reader.readNext();
            }
            while ((nextLine = reader.readNext()) != null) {
                writer.writeNext(nextLine, false);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

