/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import tech.tablesaw.columns.Column;
import tech.tablesaw.store.ColumnMetadata;

public abstract class AbstractColumn<E extends AbstractColumn>
implements Column {
    private static final String UTF8_BOM = "\ufeff";
    private String id;
    private String name;
    private String comment;

    public AbstractColumn(String name) {
        this.setName(name);
        this.comment = "";
        this.id = UUID.randomUUID().toString();
    }

    public AbstractColumn(ColumnMetadata metadata) {
        this.setName(metadata.getName());
        this.comment = "";
        this.id = metadata.getId();
    }

    private static String removeUtf8Bom(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String metadata() {
        return this.columnMetadata().toJson();
    }

    @Override
    public void setName(String name) {
        name = AbstractColumn.removeUtf8Bom(name);
        this.name = name.trim();
    }

    @Override
    public abstract void appendCell(String var1);

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public ColumnMetadata columnMetadata() {
        return new ColumnMetadata(this);
    }

    @Override
    public int columnWidth() {
        int width = this.name().length();
        for (int rowNum = 0; rowNum < this.size(); ++rowNum) {
            width = Math.max(width, StringUtils.length((CharSequence)this.getString(rowNum)));
        }
        return width;
    }

    @Override
    public E difference() {
        throw new UnsupportedOperationException("difference() method not supported for all data types");
    }
}

