/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.interpolation.Interpolator;

public class NumberInterpolator<T extends Number>
extends Interpolator<T> {
    protected final NumericColumn<T> col;

    public NumberInterpolator(NumericColumn<T> col) {
        super(col);
        this.col = col;
    }

    public DoubleColumn linear() {
        DoubleColumn result = this.col.asDoubleColumn();
        int last = -1;
        for (int i = 0; i < this.col.size(); ++i) {
            if (this.col.isMissing(i)) continue;
            if (last >= 0 && last != i - 1) {
                for (int j = last + 1; j < i; ++j) {
                    result.set(j, this.col.getDouble(last) + (this.col.getDouble(i) - this.col.getDouble(last)) * (double)(j - last) / (double)(i - last));
                }
            }
            last = i;
        }
        return result;
    }
}

