/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.columns.strings.StringFilters;
import tech.tablesaw.columns.strings.StringReduceUtils;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface DictionaryMap
extends StringReduceUtils,
StringFilters {
    public void sortDescending();

    public void sortAscending();

    public int getKeyAtIndex(int var1);

    public String getValueForKey(int var1);

    @Override
    public int size();

    public String getValueForIndex(int var1);

    public int countOccurrences(String var1);

    public Set<String> asSet();

    default public int uniqueValuesAt(int index) {
        int result = 0;
        ArrayList<String> uniqueValues = new ArrayList<String>();
        for (int i = 0; i <= index; ++i) {
            String value = this.getValueForIndex(i);
            int uniqueIndex = uniqueValues.indexOf(value);
            if (uniqueIndex >= 0) continue;
            uniqueValues.add(value);
            ++result;
        }
        return result;
    }

    default public int[] asIntArray() {
        int[] result = new int[this.size()];
        ArrayList<String> uniqueValues = new ArrayList<String>();
        for (int i = 0; i < this.size(); ++i) {
            String value = this.getValueForIndex(i);
            int uniqueIndex = uniqueValues.indexOf(value);
            if (uniqueIndex < 0) {
                uniqueValues.add(value);
                uniqueIndex = uniqueValues.size() - 1;
            }
            result[i] = uniqueIndex;
        }
        return result;
    }

    public int getKeyForIndex(int var1);

    public int firstIndexOf(String var1);

    public String[] asObjectArray();

    public Selection selectIsIn(String ... var1);

    public Selection selectIsIn(Collection<String> var1);

    public void append(String var1) throws NoKeysAvailableException;

    public void set(int var1, String var2) throws NoKeysAvailableException;

    public void clear();

    public int countUnique();

    public Table countByCategory(String var1);

    @Override
    public Selection isEqualTo(String var1);

    @Override
    default public Selection isNotEqualTo(String string) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(0, this.size());
        selection.andNot(this.isEqualTo(string));
        return selection;
    }

    @Override
    default public String get(int index) {
        return this.getValueForIndex(index);
    }

    @Override
    default public Selection isIn(String ... strings) {
        return this.selectIsIn(strings);
    }

    @Override
    default public Selection isIn(Collection<String> strings) {
        return this.selectIsIn(strings);
    }

    @Override
    default public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(strings));
        return results;
    }

    @Override
    default public Selection isNotIn(Collection<String> strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot((Selection)this.isIn((Collection)strings));
        return results;
    }

    public List<BooleanColumn> getDummies();

    public byte[] asBytes(int var1);

    public int countMissing();

    @Override
    public Iterator<String> iterator();

    public void appendMissing();

    public boolean isMissing(int var1);

    public DictionaryMap promoteYourself();

    public int nextKeyWithoutIncrementing();

    public boolean canPromoteToText();

    default public boolean isEmpty() {
        return this.size() == 0;
    }
}

