/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.dates;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javax.annotation.concurrent.Immutable;
import tech.tablesaw.columns.TemporalColumnFormatter;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.dates.PackedLocalDate;

@Immutable
public class DateColumnFormatter
extends TemporalColumnFormatter {
    public DateColumnFormatter(DateTimeFormatter format) {
        super(format);
    }

    public DateColumnFormatter() {
    }

    public DateColumnFormatter(DateTimeFormatter format, String missingValueString) {
        super(format, missingValueString);
    }

    public String format(int value) {
        if (value == DateColumnType.missingValueIndicator()) {
            return this.getMissingString();
        }
        if (this.getFormat() == null) {
            return PackedLocalDate.toDateString(value);
        }
        LocalDate date = PackedLocalDate.asLocalDate(value);
        if (date == null) {
            return "";
        }
        return this.getFormat().format(date);
    }

    public String toString() {
        return "DateColumnFormatter{format=" + this.getFormat() + ", missingString='" + this.getMissingString() + "'}";
    }
}

