/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.joining.ColumnIndexPair;
import tech.tablesaw.joining.JoinStrategy;
import tech.tablesaw.joining.JoinType;
import tech.tablesaw.joining.SortKey;
import tech.tablesaw.selection.Selection;

class SortMergeJoin
implements JoinStrategy {
    private static final String LEFT_RECORD_ID_NAME = "_left_record_id_";
    private static final String RIGHT_RECORD_ID_NAME = "_right_record_id_";
    private static final String TABLE_ALIAS = "T";
    public static final String PLACEHOLDER_COL_PREFIX = "Placeholder_";
    private final String[] leftjoinColumnNames;
    private int[] leftJoinColumnPositions;
    private int[] rightJoinColumnPositions;
    private final AtomicInteger joinTableId = new AtomicInteger(1);

    public SortMergeJoin(Table table, String ... joinColumnNames) {
        this.leftJoinColumnPositions = this.getJoinIndexes(table, joinColumnNames);
        this.leftjoinColumnNames = joinColumnNames;
    }

    private int[] getJoinIndexes(Table table, String[] columnNames) {
        int[] results = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String nm = columnNames[i];
            results[i] = table.columnIndex(nm);
        }
        return results;
    }

    @Override
    public Table performJoin(Table t1, Table t2, JoinType joinType, boolean allowDuplicates, boolean keepAllJoinKeyColumns, int[] leftJoinColumnIndexes, String ... table2JoinColumnNames) {
        this.leftJoinColumnPositions = leftJoinColumnIndexes;
        this.rightJoinColumnPositions = this.getJoinIndexes(t2, table2JoinColumnNames);
        Table table1 = t1.sortAscendingOn(this.leftjoinColumnNames);
        Table table2 = t2.sortAscendingOn(table2JoinColumnNames);
        Column[] cols = (Column[])Streams.concat((Stream[])new Stream[]{table1.columns().stream(), table2.columns().stream()}).map(Column::emptyCopy).toArray(Column[]::new);
        int[] resultIgnoreColIndexes = keepAllJoinKeyColumns ? new int[]{} : this.getIgnoredColumns(table1, joinType, cols);
        Table result = this.emptyTableFromColumns(table1, allowDuplicates, cols);
        IntColumn indexLeft = IntColumn.indexColumn(LEFT_RECORD_ID_NAME, table1.rowCount(), 0);
        table1.addColumns(new Column[]{indexLeft});
        result.addColumns(new Column[]{IntColumn.create(LEFT_RECORD_ID_NAME)});
        IntColumn indexRight = IntColumn.indexColumn(RIGHT_RECORD_ID_NAME, table2.rowCount(), 0);
        table2.addColumns(new Column[]{indexRight});
        result.addColumns(new Column[]{IntColumn.create(RIGHT_RECORD_ID_NAME)});
        this.validateJoinColumns(table1, table2);
        if (table1.rowCount() == 0 && (joinType == JoinType.LEFT_OUTER || joinType == JoinType.INNER)) {
            if (!keepAllJoinKeyColumns) {
                result.removeColumns(resultIgnoreColIndexes);
            }
            return result;
        }
        if (joinType == JoinType.INNER) {
            this.joinInner(result, table1, table2, resultIgnoreColIndexes);
        } else if (joinType == JoinType.LEFT_OUTER) {
            this.joinLeft(result, table1, table2, resultIgnoreColIndexes);
        } else if (joinType == JoinType.RIGHT_OUTER) {
            this.joinRight(result, table1, table2, resultIgnoreColIndexes);
        } else if (joinType == JoinType.FULL_OUTER) {
            this.joinFull(result, table1, table2, resultIgnoreColIndexes);
        }
        result.removeColumns(LEFT_RECORD_ID_NAME, RIGHT_RECORD_ID_NAME);
        if (!keepAllJoinKeyColumns) {
            result = result.removeColumns(resultIgnoreColIndexes);
        } else {
            this.renameJoinColumns(result, table1, resultIgnoreColIndexes);
        }
        return result;
    }

    private void renameJoinColumns(Table result, Table left, int[] resultIgnoreColIndexes) {
        String table2Alias = TABLE_ALIAS + this.joinTableId.get();
        for (int position : resultIgnoreColIndexes) {
            String realName = result.column(position).name().replace(PLACEHOLDER_COL_PREFIX, "");
            if (position >= left.columnCount()) {
                if (result.containsColumn(realName.toLowerCase())) {
                    result.column(position).setName(this.newName(table2Alias, realName));
                    continue;
                }
                result.column(position).setName(realName);
                continue;
            }
            result.column(position).setName(realName);
        }
    }

    private String newName(String table2Alias, String columnName) {
        return table2Alias + "." + columnName;
    }

    Table emptyTableFromColumns(Table table1, boolean allowDuplicates, Column<?>[] cols) {
        Table destination = Table.create(table1.name());
        if (allowDuplicates) {
            Set table1ColNames = Arrays.stream(cols).map(Column::name).map(String::toLowerCase).limit(table1.columnCount()).collect(Collectors.toSet());
            String table2Alias = TABLE_ALIAS + this.joinTableId.incrementAndGet();
            for (int c = table1.columnCount(); c < cols.length; ++c) {
                String columnName = cols[c].name();
                if (!table1ColNames.contains(columnName.toLowerCase())) continue;
                cols[c].setName(this.newName(table2Alias, columnName));
            }
        }
        destination.addColumns((Column[])cols);
        return destination;
    }

    private int[] getIgnoredColumns(Table table1, JoinType joinType, Column<?>[] cols) {
        int[] ignoreColumns = new int[this.leftJoinColumnPositions.length];
        int ignoreIndex = 0;
        for (int c = 0; c < cols.length; ++c) {
            if (joinType == JoinType.RIGHT_OUTER) {
                if (c >= table1.columnCount() || !this.indexesContainsValue(this.leftJoinColumnPositions, c)) continue;
                ignoreColumns[ignoreIndex] = c;
                cols[c].setName(PLACEHOLDER_COL_PREFIX + cols[c].name());
                ++ignoreIndex;
                continue;
            }
            int table2Index = c + table1.columnCount();
            if (!this.indexesContainsValue(this.rightJoinColumnPositions, c)) continue;
            ignoreColumns[ignoreIndex] = table2Index;
            cols[table2Index].setName(PLACEHOLDER_COL_PREFIX + cols[table2Index].name());
            ++ignoreIndex;
        }
        return ignoreColumns;
    }

    private void joinInner(Table destination, Table left, Table right, int[] ignoreColumns) {
        Comparator<Row> comparator = this.getRowComparator(left, this.rightJoinColumnPositions);
        Row leftRow = left.row(0);
        Row rightRow = right.row(0);
        int mark = -1;
        while (leftRow.hasNext() || rightRow.hasNext()) {
            if (mark == -1) {
                while (comparator.compare(leftRow, rightRow) < 0 && leftRow.hasNext()) {
                    leftRow.next();
                }
                while (comparator.compare(leftRow, rightRow) > 0 && rightRow.hasNext()) {
                    rightRow.next();
                }
                mark = rightRow.getRowNumber();
            }
            if (comparator.compare(leftRow, rightRow) == 0 && (leftRow.hasNext() || rightRow.hasNext())) {
                this.addValues(destination, leftRow, rightRow);
                if (rightRow.hasNext()) {
                    rightRow.next();
                    continue;
                }
                rightRow.at(mark);
                if (leftRow.hasNext()) {
                    leftRow.next();
                }
                mark = -1;
                continue;
            }
            if (rightRow.hasNext() && leftRow.hasNext()) {
                rightRow.at(mark);
                leftRow.next();
                mark = -1;
                continue;
            }
            if (leftRow.hasNext()) {
                leftRow.next();
            }
            if (leftRow.hasNext()) continue;
        }
        if (comparator.compare(leftRow, rightRow) == 0) {
            this.addValues(destination, leftRow, rightRow);
        }
    }

    private void joinLeft(Table destination, Table left, Table right, int[] ignoreColumns) {
        this.joinInner(destination, left, right, ignoreColumns);
        Selection unmatched = left.intColumn(LEFT_RECORD_ID_NAME).isNotIn(destination.intColumn(LEFT_RECORD_ID_NAME).unique());
        this.addLeftOnlyValues(destination, left, unmatched);
    }

    private void joinRight(Table destination, Table left, Table right, int[] ignoreColumns) {
        this.joinInner(destination, left, right, ignoreColumns);
        Selection unmatched = right.intColumn(RIGHT_RECORD_ID_NAME).isNotIn(destination.intColumn(RIGHT_RECORD_ID_NAME).unique());
        this.addRightOnlyValues(destination, left, right, unmatched);
    }

    private void joinFull(Table destination, Table left, Table right, int[] ignoreColumns) {
        Table tempDestination = destination.emptyCopy();
        this.joinInner(destination, left, right, ignoreColumns);
        Selection unmatchedLeft = left.intColumn(LEFT_RECORD_ID_NAME).isNotIn(destination.intColumn(LEFT_RECORD_ID_NAME).unique());
        this.addLeftOnlyValues(destination, left, unmatchedLeft);
        Selection unmatchedRight = right.intColumn(RIGHT_RECORD_ID_NAME).isNotIn(destination.intColumn(RIGHT_RECORD_ID_NAME).unique());
        this.addRightOnlyValues(tempDestination, left, right, unmatchedRight);
        for (int i = 0; i < ignoreColumns.length; ++i) {
            String name = tempDestination.columnNames().get(this.leftJoinColumnPositions[i]);
            tempDestination.replaceColumn(this.leftJoinColumnPositions[i], tempDestination.column(ignoreColumns[i]).copy().setName(name));
        }
        destination.append(tempDestination);
    }

    private void addLeftOnlyValues(Table destination, Table left, Selection unmatched) {
        for (Row leftRow : left.where(unmatched)) {
            Row destRow = destination.appendRow();
            for (int c = 0; c < leftRow.columnCount() - 1; ++c) {
                this.updateDestinationRow(destRow, leftRow, c, c);
            }
            this.updateDestinationRow(destRow, leftRow, destRow.columnCount() - 2, leftRow.columnCount() - 1);
        }
    }

    private void addRightOnlyValues(Table destination, Table left, Table right, Selection unmatched) {
        int leftColumnCount = left.columnCount();
        for (Row rightRow : right.where(unmatched)) {
            Row destRow = destination.appendRow();
            for (int c = 0; c < rightRow.columnCount() - 1; ++c) {
                this.updateDestinationRow(destRow, rightRow, c + leftColumnCount - 1, c);
            }
            this.updateDestinationRow(destRow, rightRow, destRow.columnCount() - 1, rightRow.columnCount() - 1);
        }
    }

    private Comparator<Row> getRowComparator(Table left, int[] rightJoinColumnIndexes) {
        List<ColumnIndexPair> pairs = this.createJoinColumnPairs(left, rightJoinColumnIndexes);
        return SortKey.getChain(SortKey.create(pairs));
    }

    private List<ColumnIndexPair> createJoinColumnPairs(Table left, int[] rightJoinColumnIndexes) {
        ArrayList<ColumnIndexPair> pairs = new ArrayList<ColumnIndexPair>();
        for (int i = 0; i < this.leftJoinColumnPositions.length; ++i) {
            ColumnIndexPair columnIndexPair = new ColumnIndexPair(left.column(this.leftJoinColumnPositions[i]).type(), this.leftJoinColumnPositions[i], rightJoinColumnIndexes[i]);
            pairs.add(columnIndexPair);
        }
        return pairs;
    }

    private void updateDestinationRow(Row destRow, Row sourceRow, int destColumnPosition, int sourceColumnPosition) {
        ColumnType type = destRow.getColumnType(destColumnPosition);
        if (type.equals(ColumnType.INTEGER)) {
            destRow.setInt(destColumnPosition, sourceRow.getInt(sourceColumnPosition));
        } else if (type.equals(ColumnType.LONG)) {
            destRow.setLong(destColumnPosition, sourceRow.getLong(sourceColumnPosition));
        } else if (type.equals(ColumnType.SHORT)) {
            destRow.setShort(destColumnPosition, sourceRow.getShort(sourceColumnPosition));
        } else if (type.equals(ColumnType.STRING)) {
            destRow.setString(destColumnPosition, sourceRow.getString(sourceColumnPosition));
        } else if (type.equals(ColumnType.LOCAL_DATE)) {
            destRow.setPackedDate(destColumnPosition, sourceRow.getPackedDate(sourceColumnPosition));
        } else if (type.equals(ColumnType.LOCAL_TIME)) {
            destRow.setPackedTime(destColumnPosition, sourceRow.getPackedTime(sourceColumnPosition));
        } else if (type.equals(ColumnType.LOCAL_DATE_TIME)) {
            destRow.setPackedDateTime(destColumnPosition, sourceRow.getPackedDateTime(sourceColumnPosition));
        } else if (type.equals(ColumnType.INSTANT)) {
            destRow.setPackedInstant(destColumnPosition, sourceRow.getPackedInstant(sourceColumnPosition));
        } else if (type.equals(ColumnType.DOUBLE)) {
            destRow.setDouble(destColumnPosition, sourceRow.getDouble(sourceColumnPosition));
        } else if (type.equals(ColumnType.FLOAT)) {
            destRow.setFloat(destColumnPosition, sourceRow.getFloat(sourceColumnPosition));
        } else if (type.equals(ColumnType.BOOLEAN)) {
            destRow.setBooleanAsByte(destColumnPosition, sourceRow.getBooleanAsByte(sourceColumnPosition));
        }
    }

    private void addValues(Table destination, Row leftRow, Row rightRow) {
        Row destRow = destination.appendRow();
        int leftColumnCount = leftRow.columnCount();
        int rightColumnCount = rightRow.columnCount();
        for (int destIdx1 = 0; destIdx1 < leftColumnCount - 1; ++destIdx1) {
            this.updateDestinationRow(destRow, leftRow, destIdx1, destIdx1);
        }
        for (int destIdx2 = leftColumnCount - 1; destIdx2 < leftColumnCount + rightColumnCount - 2; ++destIdx2) {
            int rightIndex = destIdx2 - (leftColumnCount - 1);
            this.updateDestinationRow(destRow, rightRow, destIdx2, rightIndex);
        }
        this.updateDestinationRow(destRow, leftRow, destRow.columnCount() - 2, leftColumnCount - 1);
        this.updateDestinationRow(destRow, rightRow, destRow.columnCount() - 1, rightColumnCount - 1);
    }

    private boolean indexesContainsValue(int[] joinColumnIndexes, int columnIndex) {
        for (int i : joinColumnIndexes) {
            if (columnIndex != i) continue;
            return true;
        }
        return false;
    }

    private void validateJoinColumns(Table table1, Table table2) {
        if (this.leftJoinColumnPositions.length != this.rightJoinColumnPositions.length) {
            throw new IllegalArgumentException("Cannot join using a different number of indices on each table: " + Arrays.toString(this.leftJoinColumnPositions) + " and " + Arrays.toString(this.rightJoinColumnPositions));
        }
        for (int i = 0; i < this.leftJoinColumnPositions.length; ++i) {
            if (table1.column(this.leftJoinColumnPositions[i]).getClass().equals(table2.column(this.rightJoinColumnPositions[i]).getClass())) continue;
            throw new IllegalArgumentException("Cannot join using different index types: " + Arrays.toString(this.leftJoinColumnPositions) + " and " + Arrays.toString(this.rightJoinColumnPositions));
        }
    }

    public String toString() {
        return "SortMergeJoin";
    }
}

