/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import tech.tablesaw.api.Row;

class RowComparatorChain
implements Comparator<Row> {
    private final List<Comparator<Row>> comparatorChain = new ArrayList<Comparator<Row>>(1);
    private BitSet orderingBits = null;
    private boolean isLocked = false;

    public RowComparatorChain(Comparator<Row> comparator) {
        this(comparator, false);
    }

    private RowComparatorChain(Comparator<Row> comparator, boolean reverse) {
        this.comparatorChain.add(comparator);
        this.orderingBits = new BitSet(1);
        if (reverse) {
            this.orderingBits.set(0);
        }
    }

    public void addComparator(Comparator<Row> comparator) {
        this.comparatorChain.add(comparator);
    }

    public int size() {
        return this.comparatorChain.size();
    }

    private void checkChainIntegrity() {
        if (this.comparatorChain.isEmpty()) {
            throw new UnsupportedOperationException("ComparatorChains must contain at least one Comparator");
        }
    }

    @Override
    public int compare(Row o1, Row o2) throws UnsupportedOperationException {
        if (!this.isLocked) {
            this.checkChainIntegrity();
            this.isLocked = true;
        }
        Iterator<Comparator<Row>> comparators = this.comparatorChain.iterator();
        int comparatorIndex = 0;
        while (comparators.hasNext()) {
            Comparator<Row> comparator = comparators.next();
            int retval = comparator.compare(o1, o2);
            if (retval != 0) {
                if (this.orderingBits.get(comparatorIndex)) {
                    retval = retval > 0 ? -1 : 1;
                }
                return retval;
            }
            ++comparatorIndex;
        }
        return 0;
    }

    public int hashCode() {
        int hash = 0;
        if (null != this.comparatorChain) {
            hash ^= this.comparatorChain.hashCode();
        }
        if (null != this.orderingBits) {
            hash ^= this.orderingBits.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (null == object) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        RowComparatorChain chain = (RowComparatorChain)object;
        return !(null != this.orderingBits ? !this.orderingBits.equals(chain.orderingBits) : null != chain.orderingBits) && (null == this.comparatorChain ? null == chain.comparatorChain : this.comparatorChain.equals(chain.comparatorChain));
        {
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowComparatorChain{");
        sb.append("comparatorChain=").append(this.comparatorChain);
        sb.append('}');
        return sb.toString();
    }
}

