/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.StringData;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class TextualStringData
implements StringData {
    protected List<String> values;
    private final IntComparator rowComparator = (i, i1) -> {
        String f1 = this.get(i);
        String f2 = this.get(i1);
        return f1.compareTo(f2);
    };
    private final Comparator<String> descendingStringComparator = Comparator.reverseOrder();

    public int valueHash(int rowNumber) {
        return this.get(rowNumber).hashCode();
    }

    public boolean equals(int rowNumber1, int rowNumber2) {
        return this.get(rowNumber1).equals(this.get(rowNumber2));
    }

    private TextualStringData(Collection<String> strings) {
        this.values = new ArrayList<String>(strings.size());
        for (String string : strings) {
            this.append(string);
        }
    }

    private TextualStringData() {
        this.values = new ArrayList<String>(128);
    }

    private TextualStringData(String[] strings) {
        this.values = new ArrayList<String>(strings.length);
        for (String string : strings) {
            this.append(string);
        }
    }

    public static boolean valueIsMissing(String string) {
        return StringColumnType.valueIsMissing(string);
    }

    @Override
    public TextualStringData appendMissing() {
        this.append(StringColumnType.missingValueIndicator());
        return this;
    }

    public static TextualStringData create() {
        return new TextualStringData();
    }

    public static TextualStringData create(String ... strings) {
        return new TextualStringData(strings);
    }

    public static TextualStringData create(Collection<String> strings) {
        return new TextualStringData(strings);
    }

    public static TextualStringData create(int size) {
        ArrayList<String> strings = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            strings.add(StringColumnType.missingValueIndicator());
        }
        return new TextualStringData(strings);
    }

    public static TextualStringData create(Stream<String> stream) {
        TextualStringData column = TextualStringData.create();
        stream.forEach(column::append);
        return column;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.get(rowNumber).equals(StringColumnType.missingValueIndicator());
    }

    @Override
    public TextualStringData emptyCopy() {
        return TextualStringData.create();
    }

    @Override
    public TextualStringData emptyCopy(int rowSize) {
        return TextualStringData.create(rowSize);
    }

    @Override
    public void sortAscending() {
        this.values.sort(String::compareTo);
    }

    @Override
    public void sortDescending() {
        this.values.sort(this.descendingStringComparator);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String get(int rowIndex) {
        return this.values.get(rowIndex);
    }

    @Override
    public List<String> asList() {
        return new ArrayList<String>(this.values);
    }

    @Override
    public Table countByCategory(String columnName) {
        throw new UnsupportedOperationException();
    }

    public Table summary() {
        Table table = Table.create();
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(new Column[]{measure});
        table.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        return table;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public TextualStringData lead(int n) {
        return this.lag(-n);
    }

    @Override
    public TextualStringData lag(int n) {
        TextualStringData copy = this.emptyCopy();
        if (n >= 0) {
            for (int m = 0; m < n; ++m) {
                copy.appendMissing();
            }
            for (int i = 0; i < this.size() && i + n < this.size(); ++i) {
                copy.append(this.get(i));
            }
        } else {
            for (int i = -n; i < this.size(); ++i) {
                copy.append(this.get(i));
            }
            for (int m = 0; m > n; --m) {
                copy.appendMissing();
            }
        }
        return copy;
    }

    @Override
    public TextualStringData set(Selection rowSelection, String newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public TextualStringData set(int rowIndex, String stringValue) {
        if (stringValue == null) {
            return this.setMissing(rowIndex);
        }
        this.values.set(rowIndex, stringValue);
        return this;
    }

    @Override
    public int countUnique() {
        return this.asSet().size();
    }

    @Override
    public boolean contains(String aString) {
        return this.values.contains(aString);
    }

    @Override
    public TextualStringData setMissing(int i) {
        return this.set(i, StringColumnType.missingValueIndicator());
    }

    public TextualStringData addAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.append(stringValue);
        }
        return this;
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public TextualStringData unique() {
        ArrayList<String> strings = new ArrayList<String>(this.asSet());
        return TextualStringData.create(strings);
    }

    @Override
    public TextualStringData where(Selection selection) {
        return (TextualStringData)this.subset(selection.toArray());
    }

    @Override
    public TextualStringData copy() {
        TextualStringData newCol = TextualStringData.create(this.size());
        int r = 0;
        for (String string : this) {
            newCol.set(r, string);
            ++r;
        }
        return newCol;
    }

    @Override
    public void append(Column<String> column) {
        int size = column.size();
        for (int i = 0; i < size; ++i) {
            this.append(column.getString(i));
        }
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!StringColumnType.missingValueIndicator().equals(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public TextualStringData removeMissing() {
        TextualStringData noMissing = this.emptyCopy();
        for (String v : this) {
            if (StringColumnType.valueIsMissing(v)) continue;
            noMissing.append(v);
        }
        return noMissing;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    @Override
    public Set<String> asSet() {
        return new HashSet<String>(this.values);
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        String value = this.get(rowNumber);
        return value.getBytes();
    }

    @Override
    public TextualStringData append(String value) {
        this.values.add(value);
        return this;
    }

    @Override
    public TextualStringData appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to TextColumn");
        }
        return this.append((String)obj);
    }

    @Override
    public Selection isIn(String ... strings) {
        HashSet stringSet = Sets.newHashSet((Object[])strings);
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!stringSet.contains(this.values.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isIn(Collection<String> strings) {
        HashSet stringSet = Sets.newHashSet(strings);
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!stringSet.contains(this.values.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(strings));
        return results;
    }

    @Override
    public Selection isNotIn(Collection<String> strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot((Selection)this.isIn((Collection)strings));
        return results;
    }

    @Override
    public int firstIndexOf(String value) {
        return this.values.indexOf(value);
    }

    @Override
    public String[] asObjectArray() {
        String[] output = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public double getDouble(int i) {
        return this.values.get(i).hashCode();
    }

    @Override
    public double[] asDoubleArray() {
        double[] result = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.getDouble(i);
        }
        return result;
    }

    @Override
    public int countOccurrences(String value) {
        return this.isEqualTo(value).size();
    }

    @Override
    public List<BooleanColumn> getDummies() {
        throw new UnsupportedOperationException("StringColumns containing arbitary, non-categorical strings do not support the getDummies() method for performance reasons");
    }

    @Override
    @Nullable
    public DictionaryMap getDictionary() {
        return null;
    }
}

