/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.univocity.parsers.common.AbstractParser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.AddCellToColumnException;
import tech.tablesaw.io.ColumnTypeDetector;
import tech.tablesaw.io.ReadOptions;

public abstract class FileReader {
    private static Logger logger = LoggerFactory.getLogger(FileReader.class);
    private static final int UNLIMITED_SAMPLE_SIZE = -1;

    public ColumnType[] getColumnTypes(Reader reader, ReadOptions options, int linesToSkip, final AbstractParser<?> parser, String[] columnNames) {
        if (parser.getContext() == null) {
            parser.beginParsing(reader);
        }
        for (int i = 0; i < linesToSkip; ++i) {
            parser.parseNext();
        }
        ColumnTypeDetector detector = new ColumnTypeDetector(options.columnTypesToDetect());
        ColumnType[] columnTypes = detector.detectColumnTypes(new Iterator<String[]>(){
            String[] nextRow;
            {
                this.nextRow = parser.parseNext();
            }

            @Override
            public boolean hasNext() {
                return this.nextRow != null;
            }

            @Override
            public String[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String[] tmp = this.nextRow;
                this.nextRow = parser.parseNext();
                return tmp;
            }
        }, options);
        for (int i = 0; i < columnTypes.length; ++i) {
            boolean hasColumnName = columnNames != null && i < columnNames.length;
            Optional<ColumnType> configuredColumnType = options.columnTypeReadOptions().columnType(i, hasColumnName ? columnNames[i] : null);
            if (!configuredColumnType.isPresent()) continue;
            columnTypes[i] = configuredColumnType.get();
        }
        return columnTypes;
    }

    private String cleanName(String name) {
        return name.trim();
    }

    public String[] getColumnNames(ReadOptions options, ReadOptions.ColumnTypeReadOptions columnTypeReadOptions, AbstractParser<?> parser) {
        if (options.header()) {
            String[] headerNames = parser.parseNext();
            if (headerNames == null) {
                return new String[0];
            }
            for (int i = 0; i < headerNames.length; ++i) {
                headerNames[i] = headerNames[i] == null ? "C" + i : headerNames[i].trim();
            }
            if (options.allowDuplicateColumnNames()) {
                this.renameDuplicateColumnHeaders(headerNames);
            }
            return headerNames;
        }
        int columnCount = columnTypeReadOptions.columnTypes() != null ? columnTypeReadOptions.columnTypes().length : 0;
        String[] headerNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            headerNames[i] = "C" + i;
        }
        return headerNames;
    }

    private void renameDuplicateColumnHeaders(String[] headerNames) {
        HashMap<String, Integer> nameCounter = new HashMap<String, Integer>();
        for (int i = 0; i < headerNames.length; ++i) {
            String name = headerNames[i];
            String lowerCase = name.toLowerCase();
            Integer count = (Integer)nameCounter.get(lowerCase);
            if (count == null) {
                nameCounter.put(lowerCase, 1);
                continue;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            nameCounter.put(lowerCase, count);
            headerNames[i] = name + "-" + count;
        }
    }

    protected Table parseRows(ReadOptions options, boolean headerOnly, Reader reader, ReadOptions.ColumnTypeReadOptions columnTypeReadOptions, AbstractParser<?> parser) {
        return this.parseRows(options, headerOnly, reader, columnTypeReadOptions, parser, -1);
    }

    protected Table parseRows(ReadOptions options, boolean headerOnly, Reader reader, ReadOptions.ColumnTypeReadOptions columnTypeReadOptions, AbstractParser<?> parser, int sampleSize) {
        parser.beginParsing(reader);
        Table table = Table.create(options.tableName());
        ArrayList headerRow = Lists.newArrayList((Object[])this.getColumnNames(options, columnTypeReadOptions, parser));
        ColumnType[] types = (ColumnType[])Streams.mapWithIndex(headerRow.stream(), (columnName, idx) -> columnTypeReadOptions.columnType((int)idx, (String)columnName)).filter(Optional::isPresent).map(Optional::get).toArray(ColumnType[]::new);
        for (int x = 0; x < types.length; ++x) {
            if (types[x] == ColumnType.SKIP) continue;
            Object columnName2 = this.cleanName((String)headerRow.get(x));
            if (Strings.isNullOrEmpty((String)columnName2)) {
                columnName2 = "Column " + table.columnCount();
            }
            ColumnType type = types[x];
            Column<?> newColumn = type.create((String)columnName2);
            table.addColumns(new Column[]{newColumn});
        }
        if (!headerOnly) {
            String[] columnNames = this.selectColumnNames(headerRow, types);
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
            this.addRows(options, types, parser, table, columnIndexes, sampleSize);
        }
        return table;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void addRows(ReadOptions options, ColumnType[] types, AbstractParser<?> reader, Table table, int[] columnIndexes, int sampleSize) {
        int rowNumber;
        Map<String, AbstractColumnParser<?>> parserMap = this.getParserMap(options, table);
        Random random = new Random(0L);
        int n = rowNumber = options.header() ? 1 : 0;
        while (true) {
            block10: {
                String[] nextLine;
                if ((nextLine = reader.parseNext()) == null) {
                    return;
                }
                if (!options.skipRowsWithInvalidColumnCount() || !options.header() || nextLine.length == types.length) {
                    if (nextLine.length < types.length) {
                        if (nextLine.length == 1 && Strings.isNullOrEmpty((String)nextLine[0])) {
                            logger.error("Warning: Invalid file. Row " + rowNumber + " is empty. Continuing.");
                            break block10;
                        } else {
                            IndexOutOfBoundsException e = new IndexOutOfBoundsException("Row number " + rowNumber + " contains " + nextLine.length + " columns. " + types.length + " expected.");
                            throw new AddCellToColumnException(e, 0, rowNumber, table.columnNames(), nextLine);
                        }
                    }
                    if (nextLine.length > types.length) {
                        throw new IllegalArgumentException("Row number " + rowNumber + " contains " + nextLine.length + " columns. " + types.length + " expected.");
                    }
                    int samplesCount = table.rowCount();
                    if (sampleSize < 0 || samplesCount < sampleSize) {
                        this.addValuesToColumns(table, columnIndexes, nextLine, parserMap, rowNumber, -1);
                    } else {
                        int randomIndex = random.nextInt(samplesCount + 1);
                        if (randomIndex < sampleSize) {
                            this.addValuesToColumns(table, columnIndexes, nextLine, parserMap, rowNumber, randomIndex);
                        }
                    }
                }
            }
            ++rowNumber;
        }
    }

    private void addValuesToColumns(Table table, int[] columnIndexes, String[] nextLine, Map<String, AbstractColumnParser<?>> parserMap, int rowNumber, int rowIndex) {
        int cellIndex = 0;
        for (int columnIndex : columnIndexes) {
            Column<?> column = table.column(cellIndex);
            AbstractColumnParser<?> parser = parserMap.get(column.name());
            try {
                String value = nextLine[columnIndex];
                if (rowIndex >= 0) {
                    column.set(rowIndex, value, parser);
                } else {
                    column.appendCell(value, parser);
                }
            }
            catch (Exception e) {
                throw new AddCellToColumnException(e, columnIndex, rowNumber, table.columnNames(), nextLine);
            }
            ++cellIndex;
        }
    }

    private Map<String, AbstractColumnParser<?>> getParserMap(ReadOptions options, Table table) {
        HashMap parserMap = new HashMap();
        for (Column<?> column : table.columns()) {
            AbstractColumnParser<?> parser = column.type().customParser(options);
            parserMap.put(column.name(), parser);
        }
        return parserMap;
    }

    private String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            String name = names.get(i);
            name = name.trim();
            header.add(name);
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    protected String getTypeString(Table structure) {
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append(System.lineSeparator());
        Column<?> typeCol = structure.column("Column Type");
        Column<?> indxCol = structure.column("Index");
        Column<?> nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        int padChar = 32;
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = Strings.padEnd((String)(structure.get(r, typeColIndex) + ","), (int)typeColWidth, (char)' ');
            buf.append(cell);
            buf.append(" // ");
            cell = Strings.padEnd((String)structure.getUnformatted(r, indxColIndex), (int)indxColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            cell = Strings.padEnd((String)structure.getUnformatted(r, nameColIndex), (int)nameColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            buf.append(System.lineSeparator());
        }
        buf.append("}");
        buf.append(System.lineSeparator());
        return buf.toString();
    }
}

