/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.columns.ColumnFormatter;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.LongColumnType;
import tech.tablesaw.columns.numbers.ShortColumnType;

public class NumberColumnFormatter
extends ColumnFormatter {
    private final NumberFormat format;
    private ColumnType columnType;

    public static NumberColumnFormatter percent(int fractionalDigits) {
        NumberFormat format = NumberFormat.getPercentInstance();
        format.setGroupingUsed(false);
        format.setMinimumFractionDigits(fractionalDigits);
        format.setMaximumFractionDigits(fractionalDigits);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter floatingPointDefault() {
        DecimalFormat format = new DecimalFormat("0", DecimalFormatSymbols.getInstance(Locale.getDefault()));
        ((NumberFormat)format).setMaximumFractionDigits(340);
        ((NumberFormat)format).setMaximumIntegerDigits(340);
        ((NumberFormat)format).setGroupingUsed(false);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter standard() {
        return new NumberColumnFormatter();
    }

    public static NumberColumnFormatter ints() {
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(false);
        ((NumberFormat)format).setMinimumFractionDigits(0);
        ((NumberFormat)format).setMaximumFractionDigits(0);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter intsWithGrouping() {
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(true);
        ((NumberFormat)format).setMinimumFractionDigits(0);
        ((NumberFormat)format).setMaximumFractionDigits(0);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter fixedWithGrouping(int fractionalDigits) {
        DecimalFormat format = new DecimalFormat();
        ((NumberFormat)format).setGroupingUsed(true);
        ((NumberFormat)format).setMinimumFractionDigits(fractionalDigits);
        ((NumberFormat)format).setMaximumFractionDigits(fractionalDigits);
        return new NumberColumnFormatter(format);
    }

    public static NumberColumnFormatter currency(String language, String country) {
        NumberFormat format = NumberFormat.getCurrencyInstance(new Locale(language, country));
        return new NumberColumnFormatter(format);
    }

    public NumberColumnFormatter() {
        super("");
        this.format = null;
    }

    public NumberColumnFormatter(NumberFormat format) {
        super("");
        this.format = format;
    }

    public NumberColumnFormatter(NumberFormat format, String missingString) {
        super(missingString);
        this.format = format;
    }

    public NumberColumnFormatter(String missingString) {
        super(missingString);
        this.format = null;
    }

    public void setColumnType(ColumnType columnType) {
        this.columnType = columnType;
    }

    public NumberFormat getFormat() {
        return this.format;
    }

    public String format(long value) {
        if (this.isMissingValue(value)) {
            return this.getMissingString();
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    public String format(int value) {
        if (this.isMissingValue(value)) {
            return this.getMissingString();
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    public String format(short value) {
        if (this.isMissingValue(value)) {
            return this.getMissingString();
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    public String format(float value) {
        if (this.isMissingValue(value)) {
            return this.getMissingString();
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    public String format(double value) {
        if (this.isMissingValue(value)) {
            return this.getMissingString();
        }
        if (this.format == null) {
            return String.valueOf(value);
        }
        return this.format.format(value);
    }

    public String toString() {
        return "NumberColumnFormatter{format=" + this.format + ", missingString='" + this.getMissingString() + "'}";
    }

    private boolean isMissingValue(double value) {
        if (this.columnType.equals(ColumnType.DOUBLE)) {
            return DoubleColumnType.valueIsMissing(value);
        }
        throw new RuntimeException("Unhandled column type in NumberColumnFormatter: " + this.columnType);
    }

    private boolean isMissingValue(float value) {
        if (this.columnType.equals(ColumnType.FLOAT)) {
            return FloatColumnType.valueIsMissing(value);
        }
        throw new RuntimeException("Unhandled column type in NumberColumnFormatter: " + this.columnType);
    }

    private boolean isMissingValue(int value) {
        if (this.columnType.equals(ColumnType.INTEGER)) {
            return IntColumnType.valueIsMissing(value);
        }
        if (this.columnType.equals(ColumnType.SHORT)) {
            return ShortColumnType.valueIsMissing(value);
        }
        throw new RuntimeException("Unhandled column type in NumberColumnFormatter: " + this.columnType);
    }

    private boolean isMissingValue(short value) {
        if (this.columnType.equals(ColumnType.SHORT)) {
            return ShortColumnType.valueIsMissing(value);
        }
        throw new RuntimeException("Unhandled column type in NumberColumnFormatter: " + this.columnType);
    }

    private boolean isMissingValue(long value) {
        if (this.columnType.equals(ColumnType.LONG)) {
            return LongColumnType.valueIsMissing(value);
        }
        throw new RuntimeException("Unhandled column type in NumberColumnFormatter: " + this.columnType);
    }
}

