/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.temporal;

import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.function.BiPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.instant.PackedInstant;
import tech.tablesaw.columns.temporal.TemporalPredicates;
import tech.tablesaw.filtering.InstantFilterSpec;
import tech.tablesaw.filtering.predicates.LongBiPredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface TemporalFilters<T extends Temporal>
extends Column<T>,
InstantFilterSpec<Selection> {
    default public Selection eval(LongPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            long next = this.getLongInternal(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    default public Selection eval(LongBiPredicate predicate, long value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            long next = this.getLongInternal(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    default public Selection eval(LongBiPredicate predicate, DateTimeColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.getLongInternal(idx), otherColumn.getLongInternal(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<T, T> predicate, T valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<T> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection isBetweenExcluding(long lowPackedDateTime, long highPackedDateTime) {
        return this.eval(PackedInstant::isAfter, lowPackedDateTime).and(this.eval(PackedInstant::isBefore, highPackedDateTime));
    }

    default public Selection isBetweenIncluding(long lowPackedDateTime, long highPackedDateTime) {
        return this.eval(PackedInstant::isOnOrAfter, lowPackedDateTime).and(this.eval(PackedInstant::isOnOrBefore, highPackedDateTime));
    }

    @Override
    default public Selection isAfter(Instant value) {
        return this.eval(TemporalPredicates.isGreaterThan, PackedInstant.pack(value));
    }

    @Override
    default public Selection isBefore(Instant value) {
        return this.eval(TemporalPredicates.isLessThan, PackedInstant.pack(value));
    }

    @Override
    default public Selection isEqualTo(Instant value) {
        return this.eval(TemporalPredicates.isEqualTo, PackedInstant.pack(value));
    }

    @Override
    public int size();

    public long getLongInternal(int var1);

    @Override
    public T get(int var1);

    @Override
    public Selection isMissing();

    @Override
    public Selection isNotMissing();
}

