/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers;

import java.util.function.DoublePredicate;

public interface NumberPredicates {
    public static final DoublePredicate isZero = i -> i == 0.0;
    public static final DoublePredicate isNegative = i -> i < 0.0;
    public static final DoublePredicate isPositive = i -> i > 0.0;
    public static final DoublePredicate isNonNegative = i -> i >= 0.0;
    public static final DoublePredicate isMissing = i -> i != i;
    public static final DoublePredicate isNotMissing = i -> i == i;

    public static DoublePredicate isGreaterThan(double valueToCompareAgainst) {
        return valueToTest -> valueToTest > valueToCompareAgainst;
    }

    public static DoublePredicate isBetweenExclusive(double rangeStart, double rangeEnd) {
        return valueToTest -> valueToTest > rangeStart && valueToTest < rangeEnd;
    }

    public static DoublePredicate isBetweenInclusive(double rangeStart, double rangeEnd) {
        return valueToTest -> valueToTest >= rangeStart && valueToTest <= rangeEnd;
    }

    public static DoublePredicate isGreaterThanOrEqualTo(double valueToCompareAgainst) {
        return valueToTest -> valueToTest >= valueToCompareAgainst;
    }

    public static DoublePredicate isLessThan(double valueToCompareAgainst) {
        return valueToTest -> valueToTest < valueToCompareAgainst;
    }

    public static DoublePredicate isLessThanOrEqualTo(double valueToCompareAgainst) {
        return valueToTest -> valueToTest <= valueToCompareAgainst;
    }

    public static DoublePredicate isEqualTo(double valueToCompareAgainst) {
        return valueToTest -> valueToTest == valueToCompareAgainst;
    }

    public static DoublePredicate isNotEqualTo(double valueToCompareAgainst) {
        return valueToTest -> valueToTest != valueToCompareAgainst;
    }
}

