/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.io.ByIdxColumnTypeReadOptions;
import tech.tablesaw.io.ByNameMapColumnTypeReadOptions;
import tech.tablesaw.io.CompleteFunctionColumnTypeReadOptions;
import tech.tablesaw.io.PartialFunctionColumnTypeReadOptions;
import tech.tablesaw.io.Source;

public class ReadOptions {
    public static final boolean DEFAULT_IGNORE_ZERO_DECIMAL = true;
    public static final boolean DEFAULT_SKIP_ROWS_WITH_INVALID_COLUMN_COUNT = false;
    private static final List<ColumnType> DEFAULT_TYPES = Lists.newArrayList((Object[])new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.INTEGER, ColumnType.LONG, ColumnType.DOUBLE, ColumnType.STRING, ColumnType.TEXT});
    protected static final List<ColumnType> EXTENDED_TYPES = Lists.newArrayList((Object[])new ColumnType[]{ColumnType.LOCAL_DATE_TIME, ColumnType.LOCAL_TIME, ColumnType.LOCAL_DATE, ColumnType.BOOLEAN, ColumnType.SHORT, ColumnType.INTEGER, ColumnType.LONG, ColumnType.FLOAT, ColumnType.DOUBLE, ColumnType.STRING, ColumnType.TEXT});
    protected final Source source;
    protected final String tableName;
    protected final List<ColumnType> columnTypesToDetect;
    protected final boolean sample;
    protected final String dateFormat;
    protected final String dateTimeFormat;
    protected final String timeFormat;
    protected final Locale locale;
    protected final String[] missingValueIndicators;
    protected final boolean minimizeColumnSizes;
    protected final int maxCharsPerColumn;
    protected final boolean ignoreZeroDecimal;
    protected final boolean allowDuplicateColumnNames;
    protected final boolean skipRowsWithInvalidColumnCount;
    protected final DateTimeFormatter dateFormatter;
    protected final DateTimeFormatter dateTimeFormatter;
    protected final DateTimeFormatter timeFormatter;
    protected final ColumnTypeReadOptions columnTypeReadOptions;
    protected final boolean header;

    protected ReadOptions(Builder builder) {
        this.source = builder.source;
        this.tableName = builder.tableName;
        this.columnTypesToDetect = builder.columnTypesToDetect;
        this.sample = builder.sample;
        this.dateFormat = builder.dateFormat;
        this.timeFormat = builder.timeFormat;
        this.dateTimeFormat = builder.dateTimeFormat;
        this.missingValueIndicators = builder.missingValueIndicators;
        this.minimizeColumnSizes = builder.minimizeColumnSizes;
        this.header = builder.header;
        this.maxCharsPerColumn = builder.maxCharsPerColumn;
        this.ignoreZeroDecimal = builder.ignoreZeroDecimal;
        this.skipRowsWithInvalidColumnCount = builder.skipRowsWithInvalidColumnCount;
        this.dateFormatter = builder.dateFormatter;
        this.timeFormatter = builder.timeFormatter;
        this.dateTimeFormatter = builder.dateTimeFormatter;
        this.allowDuplicateColumnNames = builder.allowDuplicateColumnNames;
        this.locale = builder.locale;
        this.columnTypeReadOptions = builder.columnTypes != null ? new ByIdxColumnTypeReadOptions(builder.columnTypes) : (!builder.columnTypeMap.isEmpty() ? new ByNameMapColumnTypeReadOptions(builder.columnTypeMap) : (builder.completeColumnTypeFunction != null ? new CompleteFunctionColumnTypeReadOptions(builder.completeColumnTypeFunction) : (builder.columnTypeFunction != null ? new PartialFunctionColumnTypeReadOptions(builder.columnTypeFunction) : ColumnTypeReadOptions.EMPTY)));
    }

    public Source source() {
        return this.source;
    }

    public String tableName() {
        return this.tableName;
    }

    public boolean allowDuplicateColumnNames() {
        return this.allowDuplicateColumnNames;
    }

    public List<ColumnType> columnTypesToDetect() {
        return this.columnTypesToDetect;
    }

    public boolean sample() {
        return this.sample;
    }

    public boolean minimizeColumnSizes() {
        return this.minimizeColumnSizes;
    }

    public String[] missingValueIndicators() {
        return this.missingValueIndicators;
    }

    public Locale locale() {
        return this.locale;
    }

    public boolean header() {
        return this.header;
    }

    public boolean ignoreZeroDecimal() {
        return this.ignoreZeroDecimal;
    }

    public boolean skipRowsWithInvalidColumnCount() {
        return this.skipRowsWithInvalidColumnCount;
    }

    public DateTimeFormatter dateTimeFormatter() {
        if (this.dateTimeFormatter != null) {
            return this.dateTimeFormatter;
        }
        if (Strings.isNullOrEmpty((String)this.dateTimeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateTimeFormat, this.locale);
    }

    public DateTimeFormatter timeFormatter() {
        if (this.timeFormatter != null) {
            return this.timeFormatter;
        }
        if (Strings.isNullOrEmpty((String)this.timeFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.timeFormat, this.locale);
    }

    public DateTimeFormatter dateFormatter() {
        if (this.dateFormatter != null) {
            return this.dateFormatter;
        }
        if (Strings.isNullOrEmpty((String)this.dateFormat)) {
            return null;
        }
        return DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
    }

    public ColumnTypeReadOptions columnTypeReadOptions() {
        return this.columnTypeReadOptions;
    }

    static /* synthetic */ List access$100() {
        return DEFAULT_TYPES;
    }

    public static interface ColumnTypeReadOptions {
        public static final ColumnTypeReadOptions EMPTY = (columnNumber, columnName) -> Optional.empty();

        public Optional<ColumnType> columnType(int var1, String var2);

        default public boolean hasColumnTypeForAllColumnsIfHavingColumnNames() {
            return false;
        }

        default public boolean hasColumnTypeForAllColumns() {
            return false;
        }

        default public ColumnType[] columnTypes() {
            return null;
        }

        public static ColumnTypeReadOptions of(ColumnType[] allColumnTypes) {
            return new ByIdxColumnTypeReadOptions(allColumnTypes);
        }
    }

    protected static class Builder {
        protected final Source source;
        protected String tableName = "";
        protected List<ColumnType> columnTypesToDetect = ReadOptions.access$100();
        protected boolean sample = true;
        protected String dateFormat;
        protected DateTimeFormatter dateFormatter;
        protected String timeFormat;
        protected DateTimeFormatter timeFormatter;
        protected String dateTimeFormat;
        protected DateTimeFormatter dateTimeFormatter;
        protected Locale locale = Locale.getDefault();
        protected String[] missingValueIndicators = new String[0];
        protected boolean minimizeColumnSizes = false;
        protected boolean header = true;
        protected int maxCharsPerColumn = 4096;
        protected boolean ignoreZeroDecimal = true;
        protected boolean skipRowsWithInvalidColumnCount = false;
        private boolean allowDuplicateColumnNames = false;
        protected ColumnType[] columnTypes;
        protected Map<String, ColumnType> columnTypeMap = new HashMap<String, ColumnType>();
        protected Function<String, Optional<ColumnType>> columnTypeFunction;
        protected Function<String, ColumnType> completeColumnTypeFunction;

        protected Builder() {
            this.source = null;
        }

        protected Builder(Source source) {
            this.source = source;
        }

        protected Builder(File file) {
            this.source = new Source(file);
            this.tableName = file.getName();
        }

        protected Builder(URL url) throws IOException {
            this.source = new Source(url.openStream());
            this.tableName = url.toString();
        }

        protected Builder(InputStream stream) {
            this.source = new Source(stream);
        }

        protected Builder(InputStreamReader reader) {
            this.source = new Source(reader);
        }

        protected Builder(Reader reader) {
            this.source = new Source(reader);
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder header(boolean hasHeader) {
            this.header = hasHeader;
            return this;
        }

        @Deprecated
        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder dateFormat(DateTimeFormatter dateFormat) {
            this.dateFormatter = dateFormat;
            return this;
        }

        public Builder allowDuplicateColumnNames(Boolean allow) {
            this.allowDuplicateColumnNames = allow;
            return this;
        }

        @Deprecated
        public Builder timeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder timeFormat(DateTimeFormatter dateFormat) {
            this.timeFormatter = dateFormat;
            return this;
        }

        @Deprecated
        public Builder dateTimeFormat(String dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
            return this;
        }

        public Builder dateTimeFormat(DateTimeFormatter dateFormat) {
            this.dateTimeFormatter = dateFormat;
            return this;
        }

        public Builder missingValueIndicator(String ... missingValueIndicators) {
            this.missingValueIndicators = missingValueIndicators;
            return this;
        }

        public Builder maxCharsPerColumn(int maxCharsPerColumn) {
            this.maxCharsPerColumn = maxCharsPerColumn;
            return this;
        }

        public Builder ignoreZeroDecimal(boolean ignoreZeroDecimal) {
            this.ignoreZeroDecimal = ignoreZeroDecimal;
            return this;
        }

        public Builder skipRowsWithInvalidColumnCount(boolean skipRowsWithInvalidColumnCount) {
            this.skipRowsWithInvalidColumnCount = skipRowsWithInvalidColumnCount;
            return this;
        }

        public Builder sample(boolean sample) {
            this.sample = sample;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder columnTypesToDetect(List<ColumnType> columnTypesToDetect) {
            ArrayList<ColumnType> orderedTypes = new ArrayList<ColumnType>();
            for (ColumnType t : EXTENDED_TYPES) {
                if (!columnTypesToDetect.contains(t)) continue;
                orderedTypes.add(t);
            }
            this.columnTypesToDetect = orderedTypes;
            return this;
        }

        public Builder minimizeColumnSizes() {
            this.columnTypesToDetect = EXTENDED_TYPES;
            return this;
        }

        public Builder columnTypes(ColumnType[] columnTypes) {
            if (this.columnTypeOptionsAlreadySet()) {
                throw new IllegalStateException("columnTypes already set");
            }
            this.columnTypes = columnTypes;
            return this;
        }

        public Builder columnTypes(Function<String, ColumnType> columnTypeFunction) {
            if (this.columnTypeOptionsAlreadySet()) {
                throw new IllegalStateException("columnTypes already set");
            }
            this.completeColumnTypeFunction = columnTypeFunction;
            return this;
        }

        public Builder columnTypesPartial(Function<String, Optional<ColumnType>> columnTypeFunction) {
            if (this.columnTypeOptionsAlreadySet()) {
                throw new IllegalStateException("columnTypes already set");
            }
            this.columnTypeFunction = columnTypeFunction;
            return this;
        }

        public Builder columnTypesPartial(Map<String, ColumnType> columnTypeByName) {
            if (this.columnTypeOptionsAlreadySet()) {
                throw new IllegalStateException("columnTypes already set");
            }
            if (columnTypeByName != null) {
                this.columnTypeMap = columnTypeByName;
            }
            return this;
        }

        private boolean columnTypeOptionsAlreadySet() {
            return this.columnTypes != null || this.columnTypeFunction != null || this.completeColumnTypeFunction != null || !this.columnTypeMap.isEmpty();
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }
    }
}

