/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleComparators;
import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleRBTreeSet;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.stream.DoubleStream;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.numbers.NumberFillers;
import tech.tablesaw.columns.numbers.fillers.DoubleRangeIterable;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class DoubleColumn
extends NumberColumn<DoubleColumn, Double>
implements NumberFillers<DoubleColumn> {
    protected final DoubleArrayList data;

    protected DoubleColumn(String name, DoubleArrayList data) {
        super(DoubleColumnType.instance(), name, DoubleColumnType.DEFAULT_PARSER);
        this.setPrintFormatter(NumberColumnFormatter.floatingPointDefault());
        this.data = data;
    }

    public static boolean valueIsMissing(double value) {
        return DoubleColumnType.valueIsMissing(value);
    }

    @Override
    public String getString(int row) {
        double value = this.getDouble(row);
        return String.valueOf(this.getPrintFormatter().format(value));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public DoubleColumn setMissing(int index) {
        this.set(index, DoubleColumnType.missingValueIndicator());
        return this;
    }

    protected DoubleColumn(String name) {
        super(DoubleColumnType.instance(), name, DoubleColumnType.DEFAULT_PARSER);
        this.setPrintFormatter(NumberColumnFormatter.floatingPointDefault());
        this.data = new DoubleArrayList(128);
    }

    public static DoubleColumn create(String name, double ... arr) {
        return new DoubleColumn(name, new DoubleArrayList(arr));
    }

    public static DoubleColumn create(String name) {
        return new DoubleColumn(name);
    }

    public static DoubleColumn create(String name, float ... arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, int ... arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, long ... arr) {
        double[] doubles = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            doubles[i] = arr[i];
        }
        return new DoubleColumn(name, new DoubleArrayList(doubles));
    }

    public static DoubleColumn create(String name, Collection<? extends Number> numberList) {
        DoubleColumn newColumn = new DoubleColumn(name, new DoubleArrayList(0));
        for (Number number : numberList) {
            newColumn.append(number);
        }
        return newColumn;
    }

    public static DoubleColumn create(String name, Number[] numbers) {
        DoubleColumn newColumn = new DoubleColumn(name, new DoubleArrayList(0));
        for (Number number : numbers) {
            newColumn.append(number);
        }
        return newColumn;
    }

    public static DoubleColumn create(String name, int initialSize) {
        DoubleColumn column = new DoubleColumn(name);
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static DoubleColumn create(String name, DoubleStream stream) {
        DoubleArrayList list = new DoubleArrayList();
        stream.forEach(arg_0 -> ((DoubleArrayList)list).add(arg_0));
        return new DoubleColumn(name, list);
    }

    @Override
    public DoubleColumn createCol(String name, int initialSize) {
        return DoubleColumn.create(name, initialSize);
    }

    @Override
    public DoubleColumn createCol(String name) {
        return DoubleColumn.create(name);
    }

    @Override
    public Double get(int index) {
        double result = this.getDouble(index);
        return this.isMissingValue(result) ? null : Double.valueOf(result);
    }

    @Override
    public DoubleColumn where(Selection selection) {
        return (DoubleColumn)super.where(selection);
    }

    public Selection isNotIn(double ... doubles) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(doubles));
        return results;
    }

    public Selection isIn(double ... doubles) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        DoubleRBTreeSet doubleSet = new DoubleRBTreeSet(doubles);
        for (int i = 0; i < this.size(); ++i) {
            if (!doubleSet.contains(this.getDouble(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public DoubleColumn subset(int[] rows) {
        DoubleColumn c = (DoubleColumn)this.emptyCopy();
        for (int row : rows) {
            c.append(this.getDouble(row));
        }
        return c;
    }

    public DoubleColumn unique() {
        DoubleOpenHashSet doubles = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            doubles.add(this.getDouble(i));
        }
        DoubleColumn column = DoubleColumn.create(this.name() + " Unique values");
        doubles.forEach(column::append);
        return column;
    }

    public DoubleColumn top(int n) {
        DoubleArrayList top = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values, (DoubleComparator)DoubleComparators.OPPOSITE_COMPARATOR);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new DoubleColumn(this.name() + "[Top " + n + "]", top);
    }

    public DoubleColumn bottom(int n) {
        DoubleArrayList bottom = new DoubleArrayList();
        double[] values = this.data.toDoubleArray();
        DoubleArrays.parallelQuickSort((double[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new DoubleColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public DoubleColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        double[] dest = new double[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = FloatColumnType.missingValueIndicator();
        }
        double[] array = this.data.toDoubleArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new DoubleColumn(this.name() + " lag(" + n + ")", new DoubleArrayList(dest));
    }

    public DoubleColumn removeMissing() {
        DoubleColumn result = this.copy();
        result.clear();
        DoubleListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            double v = iterator.nextDouble();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public DoubleColumn append(float f) {
        this.data.add((double)f);
        return this;
    }

    public DoubleColumn append(double d) {
        this.data.add(d);
        return this;
    }

    public DoubleColumn append(int i) {
        this.data.add((double)i);
        return this;
    }

    public DoubleColumn append(Double val) {
        if (val == null) {
            this.appendMissing();
        } else {
            this.append((double)val);
        }
        return this;
    }

    public DoubleColumn append(Number val) {
        if (val == null) {
            this.appendMissing();
        } else {
            this.append(val.doubleValue());
        }
        return this;
    }

    @Override
    public DoubleColumn copy() {
        return new DoubleColumn(this.name(), this.data.clone());
    }

    @Override
    public Iterator<Double> iterator() {
        return this.data.iterator();
    }

    @Override
    public double[] asDoubleArray() {
        return this.data.toDoubleArray();
    }

    public Double[] asObjectArray() {
        Double[] output = new Double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = !this.isMissing(i) ? Double.valueOf(this.getDouble(i)) : null;
        }
        return output;
    }

    @Override
    public int compare(Double o1, Double o2) {
        return Double.compare(o1, o2);
    }

    public DoubleColumn set(int i, Double val) {
        return val == null ? this.setMissing(i) : this.set(i, (double)val);
    }

    public DoubleColumn set(int i, double val) {
        this.data.set(i, val);
        return this;
    }

    public DoubleColumn set(DoublePredicate condition, NumericColumn<?> other) {
        for (int row = 0; row < this.size(); ++row) {
            if (!condition.test(this.getDouble(row))) continue;
            this.set(row, other.getDouble(row));
        }
        return this;
    }

    @Override
    public Column<Double> set(int row, String stringValue, AbstractColumnParser<?> parser) {
        return this.set(row, parser.parseDouble(stringValue));
    }

    public DoubleColumn append(Column<Double> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn numberColumn = (DoubleColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getDouble(i));
        }
        return this;
    }

    public DoubleColumn append(Column<Double> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn doubleColumn = (DoubleColumn)column;
        return this.append(doubleColumn.getDouble(row));
    }

    public DoubleColumn set(int row, Column<Double> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        DoubleColumn doubleColumn = (DoubleColumn)column;
        return this.set(row, doubleColumn.getDouble(sourceRow));
    }

    public DoubleColumn filter(DoublePredicate test) {
        DoubleColumn result = DoubleColumn.create(this.name());
        for (int i = 0; i < this.size(); ++i) {
            double d = this.getDouble(i);
            if (!test.test(d)) continue;
            result.append(d);
        }
        return result;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(DoubleColumnType.instance().byteSize()).putDouble(this.getDouble(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        DoubleOpenHashSet uniqueElements = new DoubleOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            uniqueElements.add(this.getDouble(i));
        }
        return uniqueElements.size();
    }

    @Override
    public double getDouble(int row) {
        return this.data.getDouble(row);
    }

    public boolean isMissingValue(double value) {
        return DoubleColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getDouble(rowNumber));
    }

    @Override
    public void sortAscending() {
        this.data.sort(DoubleComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sortDescending() {
        this.data.sort(DoubleComparators.OPPOSITE_COMPARATOR);
    }

    @Override
    public DoubleColumn appendMissing() {
        return this.append(DoubleColumnType.missingValueIndicator());
    }

    public DoubleColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Double) {
            return this.append((double)((Double)obj));
        }
        if (obj instanceof BigDecimal) {
            return this.append(((BigDecimal)obj).doubleValue());
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public DoubleColumn appendCell(String value) {
        try {
            return this.append(this.parser().parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public DoubleColumn appendCell(String value, AbstractColumnParser<?> parser) {
        try {
            return this.append(parser.parseDouble(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        double value = this.getDouble(row);
        if (DoubleColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public DoubleColumn fillWith(DoubleIterator iterator) {
        for (int r = 0; r < this.size() && iterator.hasNext(); ++r) {
            this.set(r, iterator.nextDouble());
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(DoubleRangeIterable iterable) {
        DoubleIterator iterator = iterable.iterator();
        for (int r = 0; r < this.size() && (iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            this.set(r, iterator.nextDouble());
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(DoubleSupplier supplier) {
        for (int r = 0; r < this.size(); ++r) {
            try {
                this.set(r, supplier.getAsDouble());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public DoubleColumn fillWith(double d) {
        for (int r = 0; r < this.size(); ++r) {
            this.set(r, d);
        }
        return this;
    }

    @Override
    public LongColumn asLongColumn() {
        LongColumn result = LongColumn.create(this.name());
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            if (DoubleColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((long)d);
        }
        return result;
    }

    @Override
    public IntColumn asIntColumn() {
        IntColumn result = IntColumn.create(this.name());
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            if (DoubleColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((int)d);
        }
        return result;
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortColumn result = ShortColumn.create(this.name());
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            if (DoubleColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((short)d);
        }
        return result;
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatColumn result = FloatColumn.create(this.name());
        DoubleListIterator doubleListIterator = this.data.iterator();
        while (doubleListIterator.hasNext()) {
            double d = (Double)doubleListIterator.next();
            if (DoubleColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((float)d);
        }
        return result;
    }
}

