/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import java.util.function.Function;
import tech.tablesaw.columns.ColumnFormatter;
import tech.tablesaw.columns.strings.StringColumnType;

public class StringColumnFormatter
extends ColumnFormatter {
    private final Function<String, String> formatter;

    public StringColumnFormatter() {
        super("");
        this.formatter = null;
    }

    public StringColumnFormatter(Function<String, String> formatFunction) {
        super("");
        this.formatter = formatFunction;
    }

    public StringColumnFormatter(Function<String, String> formatFunction, String missingString) {
        super(missingString);
        this.formatter = formatFunction;
    }

    public String format(String value) {
        if (StringColumnType.missingValueIndicator().equals(value)) {
            return this.getMissingString();
        }
        if (this.formatter == null) {
            return value;
        }
        return this.formatter.apply(value);
    }

    public String toString() {
        return "StringColumnFormatter{format=" + this.formatter + ", missingString='" + this.getMissingString() + '\'' + '}';
    }
}

