/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.AbstractStringColumn;
import tech.tablesaw.columns.strings.TextColumnType;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class TextColumn
extends AbstractStringColumn<TextColumn> {
    private List<String> values;
    private final IntComparator rowComparator = (i, i1) -> {
        String f1 = this.get(i);
        String f2 = this.get(i1);
        return f1.compareTo(f2);
    };
    private final Comparator<String> descendingStringComparator = Comparator.reverseOrder();

    private TextColumn(String name, Collection<String> strings) {
        super((ColumnType)TextColumnType.instance(), name, TextColumnType.DEFAULT_PARSER);
        this.values = new ArrayList<String>(strings.size());
        for (String string : strings) {
            this.append(string);
        }
    }

    private TextColumn(String name) {
        super((ColumnType)TextColumnType.instance(), name, TextColumnType.DEFAULT_PARSER);
        this.values = new ArrayList<String>(128);
    }

    private TextColumn(String name, String[] strings) {
        super((ColumnType)TextColumnType.instance(), name, TextColumnType.DEFAULT_PARSER);
        this.values = new ArrayList<String>(strings.length);
        for (String string : strings) {
            this.append(string);
        }
    }

    public static boolean valueIsMissing(String string) {
        return TextColumnType.valueIsMissing(string);
    }

    public TextColumn appendMissing() {
        this.append(TextColumnType.missingValueIndicator());
        return this;
    }

    public static TextColumn create(String name) {
        return new TextColumn(name);
    }

    public static TextColumn create(String name, String ... strings) {
        return new TextColumn(name, strings);
    }

    public static TextColumn create(String name, Collection<String> strings) {
        return new TextColumn(name, strings);
    }

    public static TextColumn create(String name, int size) {
        ArrayList<String> strings = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            strings.add(TextColumnType.missingValueIndicator());
        }
        return new TextColumn(name, strings);
    }

    public static TextColumn create(String name, Stream<String> stream) {
        TextColumn column = TextColumn.create(name);
        stream.forEach(column::append);
        return column;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.get(rowNumber).equals(TextColumnType.missingValueIndicator());
    }

    public TextColumn emptyCopy() {
        return TextColumn.create(this.name());
    }

    public TextColumn emptyCopy(int rowSize) {
        return TextColumn.create(this.name(), rowSize);
    }

    @Override
    public void sortAscending() {
        this.values.sort(String::compareTo);
    }

    @Override
    public void sortDescending() {
        this.values.sort(this.descendingStringComparator);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String get(int rowIndex) {
        return this.values.get(rowIndex);
    }

    @Override
    public List<String> asList() {
        return new ArrayList<String>(this.values);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(new Column[]{measure});
        table.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        return table;
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    public TextColumn lead(int n) {
        TextColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public TextColumn lag(int n) {
        TextColumn copy = this.emptyCopy();
        copy.setName(this.name() + " lag(" + n + ")");
        if (n >= 0) {
            for (int m = 0; m < n; ++m) {
                copy.appendMissing();
            }
            for (int i = 0; i < this.size() && i + n < this.size(); ++i) {
                copy.append(this.get(i));
            }
        } else {
            for (int i = -n; i < this.size(); ++i) {
                copy.append(this.get(i));
            }
            for (int m = 0; m > n; --m) {
                copy.appendMissing();
            }
        }
        return copy;
    }

    @Override
    public TextColumn set(Selection rowSelection, String newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public TextColumn set(int rowIndex, String stringValue) {
        if (stringValue == null) {
            return this.setMissing(rowIndex);
        }
        this.values.set(rowIndex, stringValue);
        return this;
    }

    @Override
    public int countUnique() {
        return this.asSet().size();
    }

    @Override
    public boolean contains(String aString) {
        return this.values.contains(aString);
    }

    public TextColumn setMissing(int i) {
        return this.set(i, TextColumnType.missingValueIndicator());
    }

    public TextColumn addAll(List<String> stringValues) {
        for (String stringValue : stringValues) {
            this.append(stringValue);
        }
        return this;
    }

    public TextColumn appendCell(String object) {
        this.append((String)this.parser().parse(object));
        return this;
    }

    public TextColumn appendCell(String object, AbstractColumnParser<?> parser) {
        this.append(String.valueOf(parser.parse(object)));
        return this;
    }

    @Override
    public IntComparator rowComparator() {
        return this.rowComparator;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public TextColumn unique() {
        ArrayList<String> strings = new ArrayList<String>(this.asSet());
        return TextColumn.create(this.name() + " Unique values", strings);
    }

    public TextColumn where(Selection selection) {
        return (TextColumn)this.subset(selection.toArray());
    }

    public TextColumn copy() {
        TextColumn newCol = TextColumn.create(this.name(), this.size());
        int r = 0;
        for (String string : this) {
            newCol.set(r, string);
            ++r;
        }
        return newCol;
    }

    public TextColumn append(Column<String> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        TextColumn source = (TextColumn)column;
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            this.append(source.getString(i));
        }
        return this;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!TextColumnType.missingValueIndicator().equals(this.get(i))) continue;
            ++count;
        }
        return count;
    }

    public TextColumn removeMissing() {
        TextColumn noMissing = this.emptyCopy();
        for (String v : this) {
            if (TextColumnType.valueIsMissing(v)) continue;
            noMissing.append(v);
        }
        return noMissing;
    }

    @Override
    public Iterator<String> iterator() {
        return this.values.iterator();
    }

    public Set<String> asSet() {
        return new HashSet<String>(this.values);
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return new byte[0];
    }

    public TextColumn append(String value) {
        this.values.add(value);
        return this;
    }

    public TextColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to TextColumn");
        }
        return this.append((String)obj);
    }

    @Override
    public Selection isIn(String ... strings) {
        HashSet stringSet = Sets.newHashSet((Object[])strings);
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!stringSet.contains(this.values.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isIn(Collection<String> strings) {
        HashSet stringSet = Sets.newHashSet(strings);
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            if (!stringSet.contains(this.values.get(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection isNotIn(String ... strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot(this.isIn(strings));
        return results;
    }

    @Override
    public Selection isNotIn(Collection<String> strings) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        results.addRange(0, this.size());
        results.andNot((Selection)this.isIn((Collection)strings));
        return results;
    }

    public int firstIndexOf(String value) {
        return this.values.indexOf(value);
    }

    public String[] asObjectArray() {
        String[] output = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public StringColumn asStringColumn() {
        StringColumn textColumn = StringColumn.create(this.name(), this.size());
        for (int i = 0; i < this.size(); ++i) {
            textColumn.set(i, this.get(i));
        }
        return textColumn;
    }
}

