/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongComparators;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.instant.InstantColumnFormatter;
import tech.tablesaw.columns.instant.InstantColumnType;
import tech.tablesaw.columns.instant.InstantMapFunctions;
import tech.tablesaw.columns.instant.PackedInstant;
import tech.tablesaw.columns.temporal.TemporalFillers;
import tech.tablesaw.columns.temporal.TemporalFilters;
import tech.tablesaw.columns.temporal.TemporalPredicates;
import tech.tablesaw.selection.Selection;

public class InstantColumn
extends AbstractColumn<InstantColumn, Instant>
implements InstantMapFunctions,
TemporalFillers<Instant, InstantColumn>,
TemporalFilters<Instant>,
CategoricalColumn<Instant> {
    private LongArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        long f1 = this.getPackedDateTime(r1);
        long f2 = this.getPackedDateTime(r2);
        return Long.compare(f1, f2);
    };
    private InstantColumnFormatter printFormatter = new InstantColumnFormatter();

    private InstantColumn(String name, LongArrayList data) {
        super(InstantColumnType.instance(), name, InstantColumnType.DEFAULT_PARSER);
        this.data = data;
    }

    public static InstantColumn create(String name) {
        return new InstantColumn(name, new LongArrayList(128));
    }

    public static InstantColumn createInternal(String name, long[] data) {
        return new InstantColumn(name, new LongArrayList(data));
    }

    public static InstantColumn create(String name, int initialSize) {
        InstantColumn column = new InstantColumn(name, new LongArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static InstantColumn create(String name, Collection<Instant> data) {
        InstantColumn column = new InstantColumn(name, new LongArrayList(data.size()));
        for (Instant date : data) {
            column.append(date);
        }
        return column;
    }

    public static InstantColumn create(String name, Instant ... data) {
        InstantColumn column = new InstantColumn(name, new LongArrayList(data.length));
        for (Instant date : data) {
            column.append(date);
        }
        return column;
    }

    public static InstantColumn create(String name, Stream<Instant> stream) {
        InstantColumn column = InstantColumn.create(name);
        stream.forEach(column::append);
        return column;
    }

    public static boolean valueIsMissing(long value) {
        return InstantColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return InstantColumn.valueIsMissing(this.getLongInternal(rowNumber));
    }

    @Override
    public InstantColumn plus(long amountToAdd, ChronoUnit unit) {
        InstantColumn newColumn = this.emptyCopy();
        newColumn.setName(this.temporalColumnName(this, amountToAdd, unit));
        InstantColumn column1 = this;
        for (int r = 0; r < column1.size(); ++r) {
            long packedDateTime = column1.getLongInternal(r);
            if (packedDateTime == InstantColumnType.missingValueIndicator()) {
                newColumn.appendMissing();
                continue;
            }
            newColumn.appendInternal(PackedInstant.plus(packedDateTime, amountToAdd, unit));
        }
        return newColumn;
    }

    @Override
    public InstantColumn subset(int[] rows) {
        InstantColumn c = this.emptyCopy();
        for (int row : rows) {
            c.appendInternal(this.getLongInternal(row));
        }
        return c;
    }

    public InstantColumn removeMissing() {
        InstantColumn noMissing = this.emptyCopy();
        LongIterator iterator = this.longIterator();
        while (iterator.hasNext()) {
            long i = iterator.nextLong();
            if (InstantColumn.valueIsMissing(i)) continue;
            noMissing.appendInternal(i);
        }
        return noMissing;
    }

    @Override
    public boolean contains(Instant dateTime) {
        long dt = PackedInstant.pack(dateTime);
        return this.data.contains(dt);
    }

    public InstantColumn setMissing(int i) {
        return this.set(i, InstantColumnType.missingValueIndicator());
    }

    public InstantColumn where(Selection selection) {
        return this.subset(selection.toArray());
    }

    public void setPrintFormatter(InstantColumnFormatter formatter) {
        Preconditions.checkNotNull((Object)formatter);
        this.printFormatter = formatter;
    }

    public InstantColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        long[] dest = new long[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = InstantColumnType.missingValueIndicator();
        }
        System.arraycopy(this.data.toLongArray(), srcPos, dest, destPos, length);
        InstantColumn copy = this.emptyCopy(this.size());
        copy.data = new LongArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    public InstantColumn appendCell(String stringValue) {
        return this.appendInternal(PackedInstant.pack((Instant)this.parser().parse(stringValue)));
    }

    public InstantColumn appendCell(String stringValue, AbstractColumnParser<?> parser) {
        return this.appendObj(parser.parse(stringValue));
    }

    public InstantColumn append(Instant dateTime) {
        if (dateTime != null) {
            long dt = PackedInstant.pack(dateTime);
            this.appendInternal(dt);
        } else {
            this.appendInternal(InstantColumnType.missingValueIndicator());
        }
        return this;
    }

    public InstantColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Instant) {
            return this.append((Instant)obj);
        }
        if (obj instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)obj;
            return this.append(timestamp.toInstant());
        }
        throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to DateTimeColumn");
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public InstantColumn appendInternal(long dateTime) {
        this.data.add(dateTime);
        return this;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.getPackedDateTime(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return PackedInstant.toString(this.getPackedDateTime(row));
    }

    @Override
    public InstantColumn emptyCopy() {
        InstantColumn empty = InstantColumn.create(this.name());
        empty.printFormatter = this.printFormatter;
        return empty;
    }

    public InstantColumn emptyCopy(int rowSize) {
        InstantColumn column = InstantColumn.create(this.name(), rowSize);
        column.setPrintFormatter(this.printFormatter);
        return column;
    }

    public InstantColumn copy() {
        InstantColumn column = this.emptyCopy(this.data.size());
        column.data = this.data.clone();
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public void sortAscending() {
        this.data.sort(LongComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sortDescending() {
        this.data.sort(LongComparators.OPPOSITE_COMPARATOR);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(new Column[]{measure});
        table.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countUnique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        return ints.size();
    }

    public InstantColumn unique() {
        LongOpenHashSet ints = new LongOpenHashSet(this.data.size());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long i = (Long)longListIterator.next();
            ints.add(i);
        }
        InstantColumn column = this.emptyCopy(ints.size());
        column.setName(this.name() + " Unique values");
        column.data = LongArrayList.wrap((long[])ints.toLongArray());
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public long getLongInternal(int index) {
        return this.data.getLong(index);
    }

    protected long getPackedDateTime(int index) {
        return this.getLongInternal(index);
    }

    @Override
    public Instant get(int index) {
        return PackedInstant.asInstant(this.getPackedDateTime(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public InstantColumn set(Selection rowSelection, Instant newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getPackedDateTime(i) != InstantColumnType.missingValueIndicator()) continue;
            ++count;
        }
        return count;
    }

    public long[] asEpochSecondArray() {
        return this.asEpochSecondArray(ZoneOffset.UTC);
    }

    public long[] asEpochSecondArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            Instant instant = PackedInstant.asInstant(this.data.getLong(i));
            output[i] = instant == null ? InstantColumnType.missingValueIndicator() : instant.getEpochSecond();
        }
        return output;
    }

    public long[] asEpochMillisArray() {
        return this.asEpochMillisArray(ZoneOffset.UTC);
    }

    public long[] asEpochMillisArray(ZoneOffset offset) {
        long[] output = new long[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            Instant instant = PackedInstant.asInstant(this.data.getLong(i));
            output[i] = instant == null ? InstantColumnType.missingValueIndicator() : instant.toEpochMilli();
        }
        return output;
    }

    public DateTimeColumn asLocalDateTimeColumn() {
        return this.asLocalDateTimeColumn(ZoneOffset.UTC);
    }

    public DateTimeColumn asLocalDateTimeColumn(ZoneId zone) {
        LocalDateTime[] output = new LocalDateTime[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            Instant instant = PackedInstant.asInstant(this.data.getLong(i));
            output[i] = instant == null ? null : LocalDateTime.ofInstant(instant, zone);
        }
        return DateTimeColumn.create(this.name(), output);
    }

    public InstantColumn append(Column<Instant> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        InstantColumn dateTimeColumn = (InstantColumn)column;
        int size = dateTimeColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(dateTimeColumn.get(i));
        }
        return this;
    }

    public InstantColumn append(Column<Instant> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.appendInternal(((InstantColumn)column).getLongInternal(row));
    }

    public InstantColumn set(int row, Column<Instant> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((InstantColumn)column).getLongInternal(sourceRow));
    }

    public Instant max() {
        if (this.isEmpty()) {
            return null;
        }
        long max = Long.MIN_VALUE;
        boolean allMissing = true;
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (InstantColumnType.missingValueIndicator() == aData) continue;
            max = Math.max(max, aData);
            allMissing = false;
        }
        if (allMissing) {
            return null;
        }
        return PackedInstant.asInstant(max);
    }

    public InstantColumn appendMissing() {
        this.appendInternal(InstantColumnType.missingValueIndicator());
        return this;
    }

    @Override
    public Instant min() {
        if (this.isEmpty()) {
            return null;
        }
        long min = Long.MAX_VALUE;
        boolean allMissing = true;
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long aData = (Long)longListIterator.next();
            if (InstantColumnType.missingValueIndicator() == aData) continue;
            min = Math.min(min, aData);
            allMissing = false;
        }
        if (allMissing) {
            return null;
        }
        return PackedInstant.asInstant(min);
    }

    public InstantColumn set(int index, long value) {
        this.data.set(index, value);
        return this;
    }

    public InstantColumn set(int index, Instant value) {
        return value == null ? this.setMissing(index) : this.set(index, PackedInstant.pack(value));
    }

    public List<Instant> top(int n) {
        ArrayList<Instant> top = new ArrayList<Instant>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values, (LongComparator)LongComparators.OPPOSITE_COMPARATOR);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedInstant.asInstant(values[i]));
        }
        return top;
    }

    public List<Instant> bottom(int n) {
        ArrayList<Instant> bottom = new ArrayList<Instant>();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(PackedInstant.asInstant(values[i]));
        }
        return bottom;
    }

    public LongIterator longIterator() {
        return this.data.iterator();
    }

    public Set<Instant> asSet() {
        HashSet<Instant> times = new HashSet<Instant>();
        InstantColumn unique = this.unique();
        for (Instant Instant2 : unique) {
            times.add(Instant2);
        }
        return times;
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putLong(this.getPackedDateTime(rowNumber)).array();
    }

    public double getDouble(int i) {
        return this.getPackedDateTime(i);
    }

    public double[] asDoubleArray() {
        double[] doubles = new double[this.size()];
        long[] millis = this.asEpochSecondArray();
        for (int i = 0; i < millis.length; ++i) {
            doubles[i] = millis[i];
        }
        return doubles;
    }

    public DoubleColumn asDoubleColumn() {
        return DoubleColumn.create(this.name(), this.asEpochSecondArray());
    }

    @Override
    public Iterator<Instant> iterator() {
        return new Iterator<Instant>(){
            final LongIterator longIterator;
            {
                this.longIterator = InstantColumn.this.longIterator();
            }

            @Override
            public boolean hasNext() {
                return this.longIterator.hasNext();
            }

            @Override
            public Instant next() {
                return PackedInstant.asInstant(this.longIterator.nextLong());
            }
        };
    }

    private InstantColumn fillWith(int count, Iterator<Instant> iterator, Consumer<Instant> acceptor) {
        for (int r = 0; r < count && iterator.hasNext(); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public InstantColumn fillWith(Iterator<Instant> iterator) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterator, (Instant date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (Instant)date);
        });
        return this;
    }

    private InstantColumn fillWith(int count, Iterable<Instant> iterable, Consumer<Instant> acceptor) {
        Iterator<Instant> iterator = iterable.iterator();
        for (int r = 0; r < count && (iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public InstantColumn fillWith(Iterable<Instant> iterable) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterable, (Instant date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (Instant)date);
        });
        return this;
    }

    private InstantColumn fillWith(int count, Supplier<Instant> supplier, Consumer<Instant> acceptor) {
        for (int r = 0; r < count; ++r) {
            try {
                acceptor.accept(supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public InstantColumn fillWith(Supplier<Instant> supplier) {
        int[] r = new int[1];
        this.fillWith(this.size(), supplier, (Instant date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (Instant)date);
        });
        return this;
    }

    public Instant[] asObjectArray() {
        Instant[] output = new Instant[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public int compare(Instant o1, Instant o2) {
        return o1.compareTo(o2);
    }

    @Override
    public Selection isMissing() {
        return this.eval(TemporalPredicates.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.eval(TemporalPredicates.isNotMissing);
    }
}

