/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.shorts.Short2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectSortedMap;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.index.Index;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class ShortIndex
implements Index {
    private final Short2ObjectAVLTreeMap<IntArrayList> index;

    public ShortIndex(ShortColumn column) {
        Preconditions.checkArgument((boolean)column.type().equals(ShortColumnType.instance()), (Object)"Short indexing only allowed on SHORT numeric columns");
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Short2ObjectOpenHashMap tempMap = new Short2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            short value = column.getShort(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Short2ObjectAVLTreeMap((Short2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(short value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        if (list != null) {
            ShortIndex.addAllToSelection(list, selection);
        }
        return selection;
    }

    public Selection atLeast(short value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Short2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            ShortIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(short value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Short2ObjectSortedMap tail = this.index.tailMap((short)(value + 1));
        for (IntArrayList keys : tail.values()) {
            ShortIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(short value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Short2ObjectSortedMap head = this.index.headMap((short)(value + 1));
        for (IntArrayList keys : head.values()) {
            ShortIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(short value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Short2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            ShortIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }
}

