/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.booleans.BooleanIterable;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanOpenHashSet;
import it.unimi.dsi.fastutil.booleans.BooleanSet;
import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteComparators;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.booleans.BooleanColumnUtils;
import tech.tablesaw.columns.booleans.BooleanFillers;
import tech.tablesaw.columns.booleans.BooleanFilters;
import tech.tablesaw.columns.booleans.BooleanFormatter;
import tech.tablesaw.columns.booleans.BooleanMapUtils;
import tech.tablesaw.filtering.BooleanFilterSpec;
import tech.tablesaw.filtering.predicates.BytePredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class BooleanColumn
extends AbstractColumn<BooleanColumn, Boolean>
implements BooleanFilterSpec<Selection>,
BooleanMapUtils,
CategoricalColumn<Boolean>,
BooleanFillers<BooleanColumn>,
BooleanFilters {
    private ByteArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        byte f1 = this.getByte(r1);
        byte f2 = this.getByte(r2);
        return Byte.compare(f1, f2);
    };
    private BooleanFormatter formatter = new BooleanFormatter("true", "false", "");

    private BooleanColumn(String name, ByteArrayList values) {
        super(BooleanColumnType.instance(), name);
        this.data = values;
    }

    public static boolean valueIsMissing(byte b) {
        return BooleanColumnType.valueIsMissing(b);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return BooleanColumn.valueIsMissing(this.getByte(rowNumber));
    }

    public BooleanColumn setMissing(int i) {
        this.set(i, BooleanColumnType.missingValueIndicator());
        return this;
    }

    public static BooleanColumn create(String name, Selection hits, int columnSize) {
        BooleanColumn column = BooleanColumn.create(name, columnSize);
        Preconditions.checkArgument((hits.size() <= columnSize ? 1 : 0) != 0, (Object)"Cannot have more true values than total values in a boolean column");
        IntIterator intIterator = hits.iterator();
        while (intIterator.hasNext()) {
            int hit = (Integer)intIterator.next();
            column.set(hit, true);
        }
        column.set(column.isMissing(), false);
        return column;
    }

    public static BooleanColumn create(String name) {
        return new BooleanColumn(name, new ByteArrayList(128));
    }

    public static BooleanColumn create(String name, int initialSize) {
        BooleanColumn column = new BooleanColumn(name, new ByteArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static BooleanColumn create(String name, boolean ... values) {
        BooleanColumn column = BooleanColumn.create(name, values.length);
        int r = 0;
        for (boolean b : values) {
            column.set(r, b);
            ++r;
        }
        return column;
    }

    public static BooleanColumn create(String name, Collection<Boolean> values) {
        BooleanColumn column = BooleanColumn.create(name);
        for (Boolean b : values) {
            column.append(b);
        }
        return column;
    }

    public static BooleanColumn create(String name, Boolean[] arr) {
        BooleanColumn column = BooleanColumn.create(name);
        for (Boolean val : arr) {
            column.append(val);
        }
        return column;
    }

    public static BooleanColumn create(String name, Stream<Boolean> stream) {
        BooleanColumn column = BooleanColumn.create(name);
        stream.forEach(column::append);
        return column;
    }

    public void setPrintFormatter(BooleanFormatter formatter) {
        this.formatter = formatter;
    }

    public BooleanFormatter getPrintFormatter() {
        return this.formatter;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public Table summary() {
        Byte2IntOpenHashMap counts = new Byte2IntOpenHashMap(3);
        counts.put((byte)0, 0);
        counts.put((byte)1, 0);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            counts.put(next, counts.get(next) + 1);
        }
        Table table = Table.create(this.name());
        StringColumn label = StringColumn.create("Value");
        DoubleColumn countColumn = DoubleColumn.create("Count");
        table.addColumns(new Column[]{label});
        table.addColumns(new Column[]{countColumn});
        for (Map.Entry entry : counts.byte2IntEntrySet()) {
            label.append((Byte)entry.getKey() == 1 ? "true" : "false");
            countColumn.append((Number)entry.getValue());
        }
        return table;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!BooleanColumn.valueIsMissing(this.getByte(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        ByteOpenHashSet count = new ByteOpenHashSet(3);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            count.add(next);
        }
        return count.size();
    }

    public BooleanColumn unique() {
        ByteOpenHashSet count = new ByteOpenHashSet(3);
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            count.add(next);
        }
        ByteArrayList list = new ByteArrayList((ByteCollection)count);
        return new BooleanColumn(this.name() + " Unique values", list);
    }

    public BooleanColumn append(boolean b) {
        if (b) {
            this.data.add((byte)1);
        } else {
            this.data.add((byte)0);
        }
        return this;
    }

    public BooleanColumn append(Boolean b) {
        if (b == null) {
            this.appendMissing();
        } else if (b.booleanValue()) {
            this.data.add((byte)1);
        } else {
            this.data.add((byte)0);
        }
        return this;
    }

    public BooleanColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (!(obj instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to BooleanColumn");
        }
        return this.append((Boolean)obj);
    }

    public BooleanColumn append(byte b) {
        this.data.add(b);
        return this;
    }

    public BooleanColumn appendMissing() {
        this.append(BooleanColumnType.MISSING_VALUE);
        return this;
    }

    @Override
    public String getString(int row) {
        return this.formatter.format(this.get(row));
    }

    @Override
    public String getUnformattedString(int row) {
        Boolean b = this.get(row);
        if (b == null) {
            return "";
        }
        return String.valueOf(b);
    }

    public BooleanColumn emptyCopy() {
        return BooleanColumn.create(this.name());
    }

    public BooleanColumn emptyCopy(int rowSize) {
        return BooleanColumn.create(this.name(), rowSize);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    public BooleanColumn copy() {
        return new BooleanColumn(this.name(), this.data.clone());
    }

    @Override
    public void sortAscending() {
        this.data.sort(ByteComparators.NATURAL_COMPARATOR);
    }

    @Override
    public void sortDescending() {
        this.data.sort(ByteComparators.OPPOSITE_COMPARATOR);
    }

    public BooleanColumn appendCell(String object) {
        return this.append(BooleanColumnType.DEFAULT_PARSER.parseByte(object));
    }

    public BooleanColumn appendCell(String object, AbstractColumnParser<?> parser) {
        return this.append(parser.parseByte(object));
    }

    @Override
    public Boolean get(int i) {
        byte b = this.data.getByte(i);
        if (b == 1) {
            return Boolean.TRUE;
        }
        if (b == 0) {
            return Boolean.FALSE;
        }
        return null;
    }

    public byte getByte(int i) {
        return this.data.getByte(i);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int countTrue() {
        int count = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte b = (Byte)byteListIterator.next();
            if (b != 1) continue;
            ++count;
        }
        return count;
    }

    public int countFalse() {
        int count = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte b = (Byte)byteListIterator.next();
            if (b != 0) continue;
            ++count;
        }
        return count;
    }

    public double proportionTrue() {
        return (double)this.countTrue() / (double)(this.size() - this.countMissing());
    }

    public double proportionFalse() {
        return 1.0 - this.proportionTrue();
    }

    public boolean any() {
        return this.countTrue() > 0;
    }

    public boolean all() {
        return this.countTrue() == this.size();
    }

    public boolean none() {
        return this.countTrue() == 0;
    }

    @Override
    public Selection isFalse() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 0) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Selection isTrue() {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == 1) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    @Override
    public Selection isEqualTo(BooleanColumn other) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        ByteIterator booleanIterator = other.byteIterator();
        ByteListIterator byteListIterator = this.data.iterator();
        while (byteListIterator.hasNext()) {
            byte next = (Byte)byteListIterator.next();
            if (next == booleanIterator.nextByte()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    public ByteArrayList data() {
        return this.data;
    }

    public BooleanColumn set(int i, boolean b) {
        if (b) {
            this.data.set(i, (byte)1);
        } else {
            this.data.set(i, (byte)0);
        }
        return this;
    }

    private BooleanColumn set(int i, byte b) {
        this.data.set(i, b);
        return this;
    }

    public BooleanColumn set(int i, Boolean val) {
        return val == null ? this.setMissing(i) : this.set(i, (boolean)val);
    }

    public BooleanColumn set(int row, String stringValue, AbstractColumnParser<?> parser) {
        return this.set(row, parser.parseByte(stringValue));
    }

    public BooleanColumn lead(int n) {
        BooleanColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public BooleanColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        byte[] dest = new byte[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = BooleanColumnType.MISSING_VALUE;
        }
        System.arraycopy(this.data.toByteArray(), srcPos, dest, destPos, length);
        BooleanColumn copy = this.emptyCopy(this.size());
        copy.data = new ByteArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    @Override
    public BooleanColumn set(Selection rowSelection, boolean newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public double getDouble(int row) {
        return this.getByte(row);
    }

    public double[] asDoubleArray() {
        double[] doubles = new double[this.data.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.data.getByte(i);
        }
        return doubles;
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    public BooleanColumn append(Column<Boolean> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        BooleanColumn col = (BooleanColumn)column;
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            this.append(col.getByte(i));
        }
        return this;
    }

    @Override
    public Column<Boolean> append(Column<Boolean> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        BooleanColumn col = (BooleanColumn)column;
        this.append(col.getByte(row));
        return this;
    }

    @Override
    public Column<Boolean> set(int row, Column<Boolean> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        BooleanColumn col = (BooleanColumn)column;
        this.set(row, col.getByte(sourceRow));
        return this;
    }

    @Override
    public Selection asSelection() {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int i = 0; i < this.size(); ++i) {
            byte value = this.getByte(i);
            if (value != 1) continue;
            selection.add(i);
        }
        return selection;
    }

    @Override
    public Selection isMissing() {
        return this.eval(BooleanColumnUtils.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.eval(BooleanColumnUtils.isNotMissing);
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new BooleanColumnIterator(this.byteIterator());
    }

    public ByteIterator byteIterator() {
        return this.data.iterator();
    }

    public BooleanSet asSet() {
        BooleanOpenHashSet set = new BooleanOpenHashSet(3);
        BooleanColumn unique = this.unique();
        for (int i = 0; i < unique.size(); ++i) {
            set.add(unique.get(i).booleanValue());
        }
        return set;
    }

    @Override
    public boolean contains(boolean aBoolean) {
        if (aBoolean) {
            return this.data().contains((byte)1);
        }
        return this.data().contains((byte)0);
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int row) {
        byte[] result = new byte[this.byteSize()];
        result[0] = this.get(row) != false ? (byte)1 : 0;
        return result;
    }

    public BooleanColumn where(Selection selection) {
        return (BooleanColumn)this.subset(selection.toArray());
    }

    public BooleanColumn removeMissing() {
        BooleanColumn noMissing = this.emptyCopy();
        ByteListIterator iterator = this.byteListIterator();
        while (iterator.hasNext()) {
            byte b = iterator.nextByte();
            if (BooleanColumn.valueIsMissing(b)) continue;
            noMissing.append(b);
        }
        return noMissing;
    }

    public Selection eval(BytePredicate predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            byte next = this.data.getByte(idx);
            if (!predicate.test(next)) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection eval(Predicate<Boolean> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    public Selection eval(BiPredicate<Boolean, Boolean> predicate, Boolean valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.data.size(); ++idx) {
            if (!predicate.test(this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    private ByteListIterator byteListIterator() {
        return this.data.iterator();
    }

    public DoubleColumn asDoubleColumn() {
        DoubleColumn numberColumn = DoubleColumn.create(this.name(), this.size());
        ByteArrayList data = this.data();
        for (int i = 0; i < this.size(); ++i) {
            numberColumn.set(i, data.getByte(i));
        }
        return numberColumn;
    }

    @Override
    public int compare(Boolean o1, Boolean o2) {
        return Boolean.compare(o1, o2);
    }

    @Override
    public BooleanColumn fillWith(BooleanIterator iterator) {
        for (int r = 0; r < this.size() && iterator.hasNext(); ++r) {
            this.set(r, iterator.nextBoolean());
        }
        return this;
    }

    @Override
    public BooleanColumn fillWith(BooleanIterable iterable) {
        BooleanIterator iterator = iterable.iterator();
        for (int r = 0; r < this.size() && (iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            this.set(r, iterator.nextBoolean());
        }
        return this;
    }

    @Override
    public BooleanColumn fillWith(Supplier<Boolean> supplier) {
        for (int r = 0; r < this.size(); ++r) {
            try {
                this.set(r, supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    public Boolean[] asObjectArray() {
        Boolean[] output = new Boolean[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    private static class BooleanColumnIterator
    implements Iterator<Boolean> {
        private final ByteIterator iterator;

        BooleanColumnIterator(ByteIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Boolean next() {
            byte b = this.iterator.nextByte();
            if (b == 0) {
                return false;
            }
            if (b == 1) {
                return true;
            }
            return null;
        }
    }
}

