/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import java.util.function.Function;
import tech.tablesaw.analytic.AggregateFunction;
import tech.tablesaw.analytic.AggregateFunctions;
import tech.tablesaw.analytic.WindowFrame;
import tech.tablesaw.columns.Column;
import tech.tablesaw.table.TableSlice;

class WindowSlider {
    private final boolean mirrored;
    private final WindowFrame.WindowGrowthType windowGrowthType;
    private final int initialLeftBound;
    private final int initialRightBound;
    private final AggregateFunction function;
    private final TableSlice slice;
    private final Column<?> sourceColumn;
    private final Column destinationColumn;

    WindowSlider(WindowFrame windowFrame, AggregateFunctions func, TableSlice slice, Column<?> sourceColumn, Column<?> destinationColumn) {
        this.slice = slice;
        this.destinationColumn = destinationColumn;
        this.sourceColumn = sourceColumn;
        this.function = func.getImplementation(windowFrame.windowGrowthType());
        if (windowFrame.windowGrowthType() == WindowFrame.WindowGrowthType.FIXED_RIGHT) {
            this.windowGrowthType = WindowFrame.WindowGrowthType.FIXED_LEFT;
            this.mirrored = true;
            this.initialLeftBound = windowFrame.getInitialRightBound() * -1;
            this.initialRightBound = windowFrame.getInitialLeftBound() * -1;
        } else {
            this.mirrored = false;
            this.initialLeftBound = windowFrame.getInitialLeftBound();
            this.initialRightBound = windowFrame.getInitialRightBound();
            this.windowGrowthType = windowFrame.windowGrowthType();
        }
    }

    void execute() {
        this.initWindow();
        int leftBound = this.getInitialLeftBound() - 1;
        int rightBound = this.getInitialRightBound();
        for (int i = 0; i < this.slice.rowCount(); ++i) {
            this.set(i, this.function.getValue());
            int newLeftBound = this.slideLeftStrategy().apply(leftBound);
            if (newLeftBound > leftBound && this.isRowNumberInSlice(newLeftBound)) {
                this.function.removeLeftMost();
            }
            leftBound = newLeftBound;
            int newRightBound = this.slideRightStrategy().apply(rightBound);
            if (newRightBound > rightBound && this.isRowNumberInSlice(newRightBound)) {
                if (this.isMissing(newRightBound)) {
                    this.function.addRightMostMissing();
                } else {
                    this.function.addRightMost(this.get(newRightBound));
                }
            }
            rightBound = newRightBound;
        }
    }

    int mirror(int rowNumber) {
        if (this.mirrored) {
            return this.slice.rowCount() - rowNumber - 1;
        }
        return rowNumber;
    }

    private void initWindow() {
        int leftBound = Math.max(this.getInitialLeftBound(), 0);
        int rightBound = Math.min(this.getInitialRightBound(), this.slice.rowCount() - 1);
        for (int i = leftBound; i <= rightBound; ++i) {
            if (this.isMissing(i)) {
                this.function.addRightMostMissing();
                continue;
            }
            this.function.addRightMost(this.get(i));
        }
    }

    private void set(int rowNumberInSlice, Object value) {
        this.destinationColumn.set(this.slice.mappedRowNumber(this.mirror(rowNumberInSlice)), value);
    }

    private Object get(int rowNumberInSlice) {
        return this.sourceColumn.get(this.slice.mappedRowNumber(this.mirror(rowNumberInSlice)));
    }

    private boolean isMissing(int rowNumberInSlice) {
        return this.sourceColumn.isMissing(this.slice.mappedRowNumber(this.mirror(rowNumberInSlice)));
    }

    private boolean isRowNumberInSlice(int rowNumber) {
        return rowNumber >= 0 && rowNumber < this.slice.rowCount();
    }

    private Function<Integer, Integer> slideLeftStrategy() {
        switch (this.windowGrowthType) {
            case FIXED: 
            case FIXED_LEFT: {
                return i -> i;
            }
            case SLIDING: {
                return i -> i + 1;
            }
        }
        throw new IllegalArgumentException("Unexpected growthType: " + (Object)((Object)this.windowGrowthType));
    }

    private Function<Integer, Integer> slideRightStrategy() {
        switch (this.windowGrowthType) {
            case FIXED: {
                return i -> i;
            }
            case FIXED_LEFT: 
            case SLIDING: {
                return i -> i + 1;
            }
        }
        throw new IllegalArgumentException("Unexpected growthType: " + (Object)((Object)this.windowGrowthType));
    }

    private int getInitialLeftBound() {
        return this.initialLeftBound;
    }

    private int getInitialRightBound() {
        switch (this.windowGrowthType) {
            case FIXED: {
                return this.slice.rowCount() - 1;
            }
            case FIXED_LEFT: 
            case SLIDING: {
                return this.initialRightBound;
            }
        }
        throw new IllegalArgumentException("Unexpected growthType: " + (Object)((Object)this.windowGrowthType));
    }
}

