/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.descriptive.moment.Kurtosis;
import org.apache.commons.math3.stat.descriptive.moment.Skewness;
import tech.tablesaw.aggregate.BooleanAggregateFunction;
import tech.tablesaw.aggregate.BooleanCountFunction;
import tech.tablesaw.aggregate.BooleanNumericFunction;
import tech.tablesaw.aggregate.CountFunction;
import tech.tablesaw.aggregate.DateAggregateFunction;
import tech.tablesaw.aggregate.DateTimeAggregateFunction;
import tech.tablesaw.aggregate.InstantAggregateFunction;
import tech.tablesaw.aggregate.NumericAggregateFunction;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;

public class AggregateFunctions {
    public static final DateTimeAggregateFunction earliestDateTime = new DateTimeAggregateFunction("Earliest Date-Time"){

        @Override
        public LocalDateTime summarize(DateTimeColumn column) {
            return column.min();
        }
    };
    public static final DateAggregateFunction earliestDate = new DateAggregateFunction("Earliest Date"){

        @Override
        public LocalDate summarize(DateColumn column) {
            return column.min();
        }
    };
    public static final DateAggregateFunction latestDate = new DateAggregateFunction("Latest Date"){

        @Override
        public LocalDate summarize(DateColumn column) {
            return column.max();
        }
    };
    public static final DateTimeAggregateFunction latestDateTime = new DateTimeAggregateFunction("Latest Date-Time"){

        @Override
        public LocalDateTime summarize(DateTimeColumn column) {
            return column.max();
        }
    };
    public static final InstantAggregateFunction maxInstant = new InstantAggregateFunction("Max Instant"){

        @Override
        public Instant summarize(InstantColumn column) {
            return column.max();
        }
    };
    public static final InstantAggregateFunction minInstant = new InstantAggregateFunction("Min Instant"){

        @Override
        public Instant summarize(InstantColumn column) {
            return column.min();
        }
    };
    public static final BooleanCountFunction countTrue = new BooleanCountFunction("Number True"){

        @Override
        public Integer summarize(BooleanColumn column) {
            return column.countTrue();
        }
    };
    public static final BooleanAggregateFunction allTrue = new BooleanAggregateFunction("All True"){

        @Override
        public Boolean summarize(BooleanColumn column) {
            return column.all();
        }
    };
    public static final BooleanAggregateFunction anyTrue = new BooleanAggregateFunction("Any True"){

        @Override
        public Boolean summarize(BooleanColumn column) {
            return column.any();
        }
    };
    public static final BooleanAggregateFunction noneTrue = new BooleanAggregateFunction("None True"){

        @Override
        public Boolean summarize(BooleanColumn column) {
            return column.none();
        }
    };
    public static final BooleanCountFunction countFalse = new BooleanCountFunction("Number False"){

        @Override
        public Integer summarize(BooleanColumn column) {
            return column.countFalse();
        }
    };
    public static final BooleanNumericFunction proportionTrue = new BooleanNumericFunction("Proportion True"){

        @Override
        public Double summarize(BooleanColumn column) {
            return column.proportionTrue();
        }
    };
    public static final BooleanNumericFunction proportionFalse = new BooleanNumericFunction("Proportion False"){

        @Override
        public Double summarize(BooleanColumn column) {
            return column.proportionFalse();
        }
    };
    public static final NumericAggregateFunction first = new NumericAggregateFunction("First"){

        @Override
        public Double summarize(NumericColumn<?> column) {
            return column.isEmpty() ? DoubleColumnType.missingValueIndicator() : column.getDouble(0);
        }
    };
    public static final NumericAggregateFunction last = new NumericAggregateFunction("Last"){

        @Override
        public Double summarize(NumericColumn<?> column) {
            return column.isEmpty() ? DoubleColumnType.missingValueIndicator() : column.getDouble(column.size() - 1);
        }
    };
    public static final NumericAggregateFunction change = new NumericAggregateFunction("Change"){

        @Override
        public Double summarize(NumericColumn<?> column) {
            return column.size() < 2 ? DoubleColumnType.missingValueIndicator() : column.getDouble(column.size() - 1) - column.getDouble(0);
        }
    };
    public static final NumericAggregateFunction pctChange = new NumericAggregateFunction("Percent Change"){

        @Override
        public Double summarize(NumericColumn<?> column) {
            return column.size() < 2 ? DoubleColumnType.missingValueIndicator() : (column.getDouble(column.size() - 1) - column.getDouble(0)) / column.getDouble(0);
        }
    };
    public static final CountFunction countNonMissing;
    public static final CountFunction count;
    public static final CountFunction countMissing;
    public static final CountFunction countUnique;
    public static final NumericAggregateFunction mean;
    public static final NumericAggregateFunction cv;
    public static final NumericAggregateFunction sum;
    public static final NumericAggregateFunction median;
    public static final CountFunction countWithMissing;
    public static final NumericAggregateFunction quartile1;
    public static final NumericAggregateFunction quartile3;
    public static final NumericAggregateFunction percentile90;
    public static final NumericAggregateFunction percentile95;
    public static final NumericAggregateFunction percentile99;
    public static final NumericAggregateFunction range;
    public static final NumericAggregateFunction min;
    public static final NumericAggregateFunction max;
    public static final NumericAggregateFunction product;
    public static final NumericAggregateFunction geometricMean;
    public static final NumericAggregateFunction populationVariance;
    public static final NumericAggregateFunction quadraticMean;
    public static final NumericAggregateFunction kurtosis;
    public static final NumericAggregateFunction skewness;
    public static final NumericAggregateFunction sumOfSquares;
    public static final NumericAggregateFunction sumOfLogs;
    public static final NumericAggregateFunction variance;
    public static final NumericAggregateFunction stdDev;
    @Deprecated
    public static final NumericAggregateFunction standardDeviation;

    private AggregateFunctions() {
    }

    public static Double percentile(NumericColumn<?> data, Double percentile) {
        return StatUtils.percentile((double[])AggregateFunctions.removeMissing(data), (double)percentile);
    }

    private static double[] removeMissing(NumericColumn<?> column) {
        NumericColumn numericColumn = (NumericColumn)column.removeMissing();
        return numericColumn.asDoubleArray();
    }

    public static Double meanDifference(NumericColumn<?> column1, NumericColumn<?> column2) {
        return StatUtils.meanDifference((double[])column1.asDoubleArray(), (double[])column2.asDoubleArray());
    }

    public static Double sumDifference(NumericColumn<?> column1, NumericColumn<?> column2) {
        return StatUtils.sumDifference((double[])column1.asDoubleArray(), (double[])column2.asDoubleArray());
    }

    static {
        count = countNonMissing = new CountFunction("Count"){

            @Override
            public Integer summarize(Column<?> column) {
                return column.size() - column.countMissing();
            }
        };
        countMissing = new CountFunction("Missing Values"){

            @Override
            public Integer summarize(Column<?> column) {
                return column.countMissing();
            }
        };
        countUnique = new CountFunction("Count Unique"){

            @Override
            public Integer summarize(Column<?> doubles) {
                return doubles.unique().removeMissing().size();
            }
        };
        mean = new NumericAggregateFunction("Mean"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.mean((double[])AggregateFunctions.removeMissing(column));
            }
        };
        cv = new NumericAggregateFunction("CV"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                double[] col = AggregateFunctions.removeMissing(column);
                return Math.sqrt(StatUtils.variance((double[])col)) / StatUtils.mean((double[])col);
            }
        };
        sum = new NumericAggregateFunction("Sum"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.sum((double[])AggregateFunctions.removeMissing(column));
            }
        };
        median = new NumericAggregateFunction("Median"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return AggregateFunctions.percentile(column, 50.0);
            }
        };
        countWithMissing = new CountFunction("Count (incl. missing)"){

            @Override
            public Integer summarize(Column<?> column) {
                return column.size();
            }
        };
        quartile1 = new NumericAggregateFunction("First Quartile"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return AggregateFunctions.percentile(column, 25.0);
            }
        };
        quartile3 = new NumericAggregateFunction("Third Quartile"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return AggregateFunctions.percentile(column, 75.0);
            }
        };
        percentile90 = new NumericAggregateFunction("90th Percentile"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return AggregateFunctions.percentile(column, 90.0);
            }
        };
        percentile95 = new NumericAggregateFunction("95th Percentile"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return AggregateFunctions.percentile(column, 95.0);
            }
        };
        percentile99 = new NumericAggregateFunction("99th Percentile"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return AggregateFunctions.percentile(column, 99.0);
            }
        };
        range = new NumericAggregateFunction("Range"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                double[] data = AggregateFunctions.removeMissing(column);
                return StatUtils.max((double[])data) - StatUtils.min((double[])data);
            }
        };
        min = new NumericAggregateFunction("Min"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.min((double[])AggregateFunctions.removeMissing(column));
            }
        };
        max = new NumericAggregateFunction("Max"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.max((double[])AggregateFunctions.removeMissing(column));
            }
        };
        product = new NumericAggregateFunction("Product"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.product((double[])AggregateFunctions.removeMissing(column));
            }
        };
        geometricMean = new NumericAggregateFunction("Geometric Mean"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.geometricMean((double[])AggregateFunctions.removeMissing(column));
            }
        };
        populationVariance = new NumericAggregateFunction("Population Variance"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.populationVariance((double[])AggregateFunctions.removeMissing(column));
            }
        };
        quadraticMean = new NumericAggregateFunction("Quadratic Mean"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return new DescriptiveStatistics(AggregateFunctions.removeMissing(column)).getQuadraticMean();
            }
        };
        kurtosis = new NumericAggregateFunction("Kurtosis"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                double[] data = AggregateFunctions.removeMissing(column);
                return new Kurtosis().evaluate(data, 0, data.length);
            }
        };
        skewness = new NumericAggregateFunction("Skewness"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                double[] data = AggregateFunctions.removeMissing(column);
                return new Skewness().evaluate(data, 0, data.length);
            }
        };
        sumOfSquares = new NumericAggregateFunction("Sum of Squares"){

            @Override
            public String functionName() {
                return "Sum of Squares";
            }

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.sumSq((double[])AggregateFunctions.removeMissing(column));
            }
        };
        sumOfLogs = new NumericAggregateFunction("Sum of Logs"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return StatUtils.sumLog((double[])AggregateFunctions.removeMissing(column));
            }
        };
        variance = new NumericAggregateFunction("Variance"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                double[] values = AggregateFunctions.removeMissing(column);
                return StatUtils.variance((double[])values);
            }
        };
        standardDeviation = stdDev = new NumericAggregateFunction("Std. Deviation"){

            @Override
            public Double summarize(NumericColumn<?> column) {
                return Math.sqrt(StatUtils.variance((double[])AggregateFunctions.removeMissing(column)));
            }
        };
    }
}

