/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.time.Instant;
import java.time.LocalDateTime;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.instant.PackedInstant;
import tech.tablesaw.columns.temporal.TemporalColumn;
import tech.tablesaw.index.Index;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class LongIndex
implements Index {
    private final Long2ObjectAVLTreeMap<IntArrayList> index;

    public LongIndex(TemporalColumn<?> column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Long2ObjectOpenHashMap tempMap = new Long2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            long value = column.getLongInternal(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Long2ObjectAVLTreeMap((Long2ObjectMap)tempMap);
    }

    public LongIndex(IntColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Long2ObjectOpenHashMap tempMap = new Long2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            long value = column.getInt(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Long2ObjectAVLTreeMap((Long2ObjectMap)tempMap);
    }

    public LongIndex(LongColumn column) {
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Long2ObjectOpenHashMap tempMap = new Long2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            long value = column.getLong(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Long2ObjectAVLTreeMap((Long2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        if (list != null) {
            LongIndex.addAllToSelection(list, selection);
        }
        return selection;
    }

    public Selection get(Instant value) {
        return this.get(PackedInstant.pack(value));
    }

    public Selection get(LocalDateTime value) {
        return this.get(PackedLocalDateTime.pack(value));
    }

    public Selection atLeast(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atLeast(Instant value) {
        return this.atLeast(PackedInstant.pack(value));
    }

    public Selection atLeast(LocalDateTime value) {
        return this.atLeast(PackedLocalDateTime.pack(value));
    }

    public Selection greaterThan(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap tail = this.index.tailMap(value + 1L);
        for (IntArrayList keys : tail.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(Instant value) {
        return this.greaterThan(PackedInstant.pack(value));
    }

    public Selection greaterThan(LocalDateTime value) {
        return this.greaterThan(PackedLocalDateTime.pack(value));
    }

    public Selection atMost(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap head = this.index.headMap(value + 1L);
        for (IntArrayList keys : head.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(Instant value) {
        return this.atMost(PackedInstant.pack(value));
    }

    public Selection atMost(LocalDateTime value) {
        return this.atMost(PackedLocalDateTime.pack(value));
    }

    public Selection lessThan(long value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Long2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            LongIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(Instant value) {
        return this.lessThan(PackedInstant.pack(value));
    }

    public Selection lessThan(LocalDateTime value) {
        return this.lessThan(PackedLocalDateTime.pack(value));
    }
}

