/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.interpolation;

import tech.tablesaw.columns.Column;

public class Interpolator<T> {
    protected final Column<T> col;

    public Interpolator(Column<T> column) {
        this.col = column;
    }

    public Column<T> backfill() {
        Column<Object> result = this.col.copy();
        Object lastVal = null;
        for (int i = this.col.size() - 1; i >= 0; --i) {
            if (this.col.isMissing(i)) {
                if (lastVal == null) continue;
                result.set(i, lastVal);
                continue;
            }
            lastVal = this.col.get(i);
        }
        return result;
    }

    public Column<T> frontfill() {
        Column<Object> result = this.col.copy();
        Object lastVal = null;
        for (int i = 0; i < this.col.size(); ++i) {
            if (this.col.isMissing(i)) {
                if (lastVal == null) continue;
                result.set(i, lastVal);
                continue;
            }
            lastVal = this.col.get(i);
        }
        return result;
    }
}

