/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.index;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.index.Index;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class ByteIndex
implements Index {
    private final Byte2ObjectAVLTreeMap<IntArrayList> index;

    public ByteIndex(BooleanColumn column) {
        Preconditions.checkArgument((boolean)column.type().equals(ColumnType.BOOLEAN), (Object)"Byte indexing only allowed on BOOLEAN columns");
        int sizeEstimate = Integer.min(1000000, column.size() / 100);
        Byte2ObjectOpenHashMap tempMap = new Byte2ObjectOpenHashMap(sizeEstimate);
        for (int i = 0; i < column.size(); ++i) {
            byte value = column.getByte(i);
            IntArrayList recordIds = (IntArrayList)tempMap.get(value);
            if (recordIds == null) {
                recordIds = new IntArrayList();
                recordIds.add(i);
                tempMap.trim();
                tempMap.put(value, (Object)recordIds);
                continue;
            }
            recordIds.add(i);
        }
        this.index = new Byte2ObjectAVLTreeMap((Byte2ObjectMap)tempMap);
    }

    private static void addAllToSelection(IntArrayList tableKeys, Selection selection) {
        IntListIterator intListIterator = tableKeys.iterator();
        while (intListIterator.hasNext()) {
            int i = (Integer)intListIterator.next();
            selection.add(i);
        }
    }

    public Selection get(byte value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        IntArrayList list = (IntArrayList)this.index.get(value);
        if (list != null) {
            ByteIndex.addAllToSelection(list, selection);
        }
        return selection;
    }

    public Selection atLeast(byte value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Byte2ObjectSortedMap tail = this.index.tailMap(value);
        for (IntArrayList keys : tail.values()) {
            ByteIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection greaterThan(byte value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Byte2ObjectSortedMap tail = this.index.tailMap((byte)(value + 1));
        for (IntArrayList keys : tail.values()) {
            ByteIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection atMost(byte value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Byte2ObjectSortedMap head = this.index.headMap((byte)(value + 1));
        for (IntArrayList keys : head.values()) {
            ByteIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }

    public Selection lessThan(byte value) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        Byte2ObjectSortedMap head = this.index.headMap(value);
        for (IntArrayList keys : head.values()) {
            ByteIndex.addAllToSelection(keys, selection);
        }
        return selection;
    }
}

