/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.analytic;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import tech.tablesaw.sorting.Sort;

final class WindowSpecification {
    private final String windowName;
    private final LinkedHashSet<String> partitionColumns;
    private final Sort sort;

    private WindowSpecification(String windowName, LinkedHashSet<String> partitionColumns, Sort sort) {
        this.windowName = windowName;
        this.partitionColumns = partitionColumns;
        this.sort = sort;
    }

    static Builder builder() {
        return new Builder();
    }

    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        if (!this.partitionColumns.isEmpty()) {
            sb.append("PARTITION BY ");
            sb.append(String.join((CharSequence)", ", this.partitionColumns));
            sb.append(System.lineSeparator());
        }
        if (!this.sort.isEmpty()) {
            sb.append("ORDER BY ");
            sb.append(Streams.stream(this.sort.iterator()).map(this::formatOrdering).collect(Collectors.joining(", ")));
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.partitionColumns.isEmpty() && this.sort == null;
    }

    public String toString() {
        return this.toSqlString();
    }

    public String getWindowName() {
        return this.windowName;
    }

    public LinkedHashSet<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Optional<Sort> getSort() {
        return Optional.ofNullable(this.sort);
    }

    private String formatOrdering(Map.Entry<String, Sort.Order> sortEntry) {
        String formattedOrder = "ASC";
        if (sortEntry.getValue() == Sort.Order.DESCEND) {
            formattedOrder = "DESC";
        }
        return sortEntry.getKey() + " " + formattedOrder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowSpecification that = (WindowSpecification)o;
        return Objects.equal((Object)this.windowName, (Object)that.windowName) && Objects.equal(this.partitionColumns, that.partitionColumns) && Objects.equal((Object)this.sort, (Object)that.sort);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.windowName, this.partitionColumns, this.sort});
    }

    static class Builder {
        private String windowName = "w1";
        private LinkedHashSet<String> partitioning = new LinkedHashSet();
        private Sort sort = null;

        private Builder() {
        }

        Builder setWindowName(String windowName) {
            this.windowName = windowName;
            return this;
        }

        Builder setPartitionColumns(List<String> columns) {
            this.partitioning.clear();
            this.partitioning.addAll(columns);
            Preconditions.checkArgument((this.partitioning.size() == columns.size() ? 1 : 0) != 0, (Object)"Partition by Columns cannot contain duplicate columns");
            return this;
        }

        Builder setSort(Sort sort) {
            this.sort = sort;
            return this;
        }

        WindowSpecification build() {
            return new WindowSpecification(this.windowName, this.partitioning, this.sort);
        }
    }
}

