/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.strings.ByteDictionaryMap;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.IntDictionaryMap;
import tech.tablesaw.columns.strings.ShortDictionaryMap;

public class LookupTableWrapper {
    private final DictionaryMap dictionaryMap;

    public LookupTableWrapper(DictionaryMap dictionaryMap) {
        this.dictionaryMap = dictionaryMap;
    }

    public void writeToStream(DataOutputStream dos) {
        try {
            dos.writeInt(this.dictionaryMap.countUnique());
            if (this.dictionaryMap instanceof IntDictionaryMap) {
                IntDictionaryMap dictionary = (IntDictionaryMap)this.dictionaryMap;
                ObjectSet<Int2ObjectMap.Entry<String>> entries = dictionary.getKeyValueEntries();
                for (Int2ObjectMap.Entry entry : entries) {
                    dos.writeInt(entry.getIntKey());
                    dos.writeUTF((String)entry.getValue());
                }
                ObjectIterator objectIterator = dictionary.values().iterator();
                while (objectIterator.hasNext()) {
                    int d = (Integer)objectIterator.next();
                    dos.writeInt(d);
                }
            } else if (this.dictionaryMap instanceof ShortDictionaryMap) {
                ShortDictionaryMap dictionary = (ShortDictionaryMap)this.dictionaryMap;
                ObjectSet<Short2ObjectMap.Entry<String>> entries = dictionary.getKeyValueEntries();
                for (Short2ObjectMap.Entry entry : entries) {
                    dos.writeShort(entry.getShortKey());
                    dos.writeUTF((String)entry.getValue());
                }
                ObjectIterator objectIterator = dictionary.values().iterator();
                while (objectIterator.hasNext()) {
                    short d = (Short)objectIterator.next();
                    dos.writeShort(d);
                }
            } else if (this.dictionaryMap instanceof ByteDictionaryMap) {
                ByteDictionaryMap dictionary = (ByteDictionaryMap)this.dictionaryMap;
                ObjectSet<Byte2ObjectMap.Entry<String>> entries = dictionary.getKeyValueEntries();
                for (Byte2ObjectMap.Entry entry : entries) {
                    dos.writeByte(entry.getByteKey());
                    dos.writeUTF((String)entry.getValue());
                }
                ObjectIterator objectIterator = dictionary.values().iterator();
                while (objectIterator.hasNext()) {
                    byte d = (Byte)objectIterator.next();
                    dos.writeByte(d);
                }
            }
            dos.flush();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public Class<? extends DictionaryMap> dictionaryClass() {
        return this.dictionaryMap.getClass();
    }

    public StringColumn readFromStream(DataInputStream dis, String name, String dictionarySizeString, int columnSize) {
        StringColumn stringColumn;
        block11: {
            try {
                int stringCount = dis.readInt();
                if (dictionarySizeString.equals(Integer.class.getSimpleName())) {
                    IntDictionaryMap dictionaryMap = (IntDictionaryMap)new ByteDictionaryMap().promoteYourself().promoteYourself();
                    for (int j = 0; j < stringCount; ++j) {
                        int key = dis.readInt();
                        String value = dis.readUTF();
                        dictionaryMap.updateMaps(key, value);
                    }
                    int size = columnSize;
                    for (int i = 0; i < size; ++i) {
                        dictionaryMap.addValue(dis.readInt());
                    }
                    stringColumn = StringColumn.createInternal(name, dictionaryMap);
                    break block11;
                }
                if (dictionarySizeString.equals(Short.class.getSimpleName())) {
                    ShortDictionaryMap dictionaryMap = (ShortDictionaryMap)new ByteDictionaryMap().promoteYourself();
                    for (int j = 0; j < stringCount; ++j) {
                        short key = dis.readShort();
                        String value = dis.readUTF();
                        dictionaryMap.updateMaps(key, value);
                    }
                    for (int i = 0; i < columnSize; ++i) {
                        dictionaryMap.addValue(dis.readShort());
                    }
                    stringColumn = StringColumn.createInternal(name, dictionaryMap);
                    break block11;
                }
                if (dictionarySizeString.equals(Byte.class.getSimpleName())) {
                    ByteDictionaryMap dictionaryMap = new ByteDictionaryMap();
                    for (int j = 0; j < stringCount; ++j) {
                        byte key = dis.readByte();
                        String value = dis.readUTF();
                        dictionaryMap.updateMaps(key, value);
                    }
                    for (int i = 0; i < columnSize; ++i) {
                        dictionaryMap.addValue(dis.readByte());
                    }
                    stringColumn = StringColumn.createInternal(name, dictionaryMap);
                    break block11;
                }
                throw new RuntimeException("Unable to match the dictionary map type for StringColum");
            }
            catch (Exception exception) {
                System.out.println("Failed reading " + name + " of type " + dictionarySizeString + " with exception " + exception.getMessage());
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
        }
        return stringColumn;
    }
}

