/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.longs.LongComparator;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.stream.LongStream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.NumberColumn;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.LongColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;

public class LongColumn
extends NumberColumn<LongColumn, Long>
implements CategoricalColumn<Long> {
    private final LongComparator descendingComparator = (o2, o1) -> Long.compare(o1, o2);
    private final LongArrayList data;

    private LongColumn(String name, LongArrayList data) {
        super(LongColumnType.instance(), name);
        this.setPrintFormatter(NumberColumnFormatter.ints());
        this.data = data;
    }

    public static LongColumn create(String name) {
        return new LongColumn(name, new LongArrayList());
    }

    public static LongColumn create(String name, long[] arr) {
        return new LongColumn(name, new LongArrayList(arr));
    }

    public static LongColumn create(String name, int initialSize) {
        LongColumn column = new LongColumn(name, new LongArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static LongColumn create(String name, LongStream stream) {
        LongArrayList list = new LongArrayList();
        stream.forEach((long val) -> list.add(val));
        return new LongColumn(name, list);
    }

    @Override
    public LongColumn createCol(String name, int initialSize) {
        return LongColumn.create(name, initialSize);
    }

    @Override
    public LongColumn createCol(String name) {
        return LongColumn.create(name);
    }

    public static LongColumn indexColumn(String columnName, int size, int startsWith) {
        LongColumn indexColumn = LongColumn.create(columnName, size);
        for (int i = 0; i < size; ++i) {
            indexColumn.append(i + startsWith);
        }
        return indexColumn;
    }

    @Override
    public String getString(int row) {
        long value = this.getLong(row);
        if (LongColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(this.getPrintFormatter().format(value));
    }

    public static boolean valueIsMissing(long value) {
        return LongColumnType.valueIsMissing(value);
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public Long get(int index) {
        return this.getLong(index);
    }

    @Override
    public LongColumn subset(int[] rows) {
        LongColumn c = this.emptyCopy();
        for (int row : rows) {
            c.append(this.getLong(row));
        }
        return c;
    }

    public LongColumn unique() {
        LongOpenHashSet values = new LongOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            values.add(this.getLong(i));
        }
        LongColumn column = LongColumn.create(this.name() + " Unique values");
        LongIterator longIterator = values.iterator();
        while (longIterator.hasNext()) {
            long value = (Long)longIterator.next();
            column.append(value);
        }
        return column;
    }

    public LongColumn top(int n) {
        LongArrayList top = new LongArrayList();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values, (LongComparator)this.descendingComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(values[i]);
        }
        return new LongColumn(this.name() + "[Top " + n + "]", top);
    }

    public LongColumn bottom(int n) {
        LongArrayList bottom = new LongArrayList();
        long[] values = this.data.toLongArray();
        LongArrays.parallelQuickSort((long[])values);
        for (int i = 0; i < n && i < values.length; ++i) {
            bottom.add(values[i]);
        }
        return new LongColumn(this.name() + "[Bottoms " + n + "]", bottom);
    }

    @Override
    public LongColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        long[] dest = new long[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = LongColumnType.missingValueIndicator();
        }
        long[] array = this.data.toLongArray();
        System.arraycopy(array, srcPos, dest, destPos, length);
        return new LongColumn(this.name() + " lag(" + n + ")", new LongArrayList(dest));
    }

    public LongColumn removeMissing() {
        LongColumn result = this.copy();
        result.clear();
        LongListIterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            long v = iterator.nextLong();
            if (this.isMissingValue(v)) continue;
            result.append(v);
        }
        return result;
    }

    public LongColumn append(long i) {
        this.data.add(i);
        return this;
    }

    public LongColumn append(Long val) {
        if (val == null) {
            this.appendMissing();
        } else {
            this.append((long)val);
        }
        return this;
    }

    @Override
    public LongColumn emptyCopy() {
        return (LongColumn)super.emptyCopy();
    }

    @Override
    public LongColumn emptyCopy(int rowSize) {
        return (LongColumn)super.emptyCopy(rowSize);
    }

    @Override
    public LongColumn copy() {
        return new LongColumn(this.name(), this.data.clone());
    }

    public long[] asLongArray() {
        long[] result = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            result[i] = this.getLong(i);
        }
        return result;
    }

    public DateTimeColumn asDateTimes(ZoneOffset offset) {
        DateTimeColumn column = DateTimeColumn.create(this.name() + ": date time");
        for (int i = 0; i < this.size(); ++i) {
            column.append(Instant.ofEpochMilli(this.getLong(i)).atZone(offset).toLocalDateTime());
        }
        return column;
    }

    @Override
    public Iterator<Long> iterator() {
        return this.data.iterator();
    }

    public Long[] asObjectArray() {
        Long[] output = new Long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = !this.isMissing(i) ? Long.valueOf(this.getLong(i)) : null;
        }
        return output;
    }

    @Override
    public int compare(Long o1, Long o2) {
        return Long.compare(o1, o2);
    }

    public LongColumn set(int i, Long val) {
        return this.set(i, (long)val);
    }

    public LongColumn set(int i, long val) {
        this.data.set(i, val);
        return this;
    }

    public LongColumn append(Column<Long> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        LongColumn numberColumn = (LongColumn)column;
        int size = numberColumn.size();
        for (int i = 0; i < size; ++i) {
            this.append(numberColumn.getLong(i));
        }
        return this;
    }

    public LongColumn append(Column<Long> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.append(((LongColumn)column).getLong(row));
    }

    public LongColumn set(int row, Column<Long> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((LongColumn)column).getLong(sourceRow));
    }

    @Override
    public LongColumn appendMissing() {
        return this.append(LongColumnType.missingValueIndicator());
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(LongColumnType.instance().byteSize()).putLong(this.getLong(rowNumber)).array();
    }

    @Override
    public int countUnique() {
        LongOpenHashSet uniqueElements = new LongOpenHashSet();
        for (int i = 0; i < this.size(); ++i) {
            uniqueElements.add(this.getLong(i));
        }
        return uniqueElements.size();
    }

    public long getLong(int row) {
        return this.data.getLong(row);
    }

    @Override
    public double getDouble(int row) {
        long value = this.data.getLong(row);
        if (this.isMissingValue(value)) {
            return DoubleColumnType.missingValueIndicator();
        }
        return value;
    }

    public boolean isMissingValue(long value) {
        return LongColumnType.valueIsMissing(value);
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.isMissingValue(this.getLong(rowNumber));
    }

    @Override
    public Column<Long> setMissing(int i) {
        return this.set(i, LongColumnType.missingValueIndicator());
    }

    @Override
    public void sortAscending() {
        LongArrays.parallelQuickSort((long[])this.data.elements());
    }

    @Override
    public void sortDescending() {
        LongArrays.parallelQuickSort((long[])this.data.elements(), (LongComparator)this.descendingComparator);
    }

    public LongColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (obj instanceof Long) {
            return this.append((long)((Long)obj));
        }
        throw new IllegalArgumentException("Could not append " + obj.getClass());
    }

    public LongColumn appendCell(String value) {
        try {
            return this.append(LongColumnType.DEFAULT_PARSER.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    public LongColumn appendCell(String value, AbstractColumnParser<?> parser) {
        try {
            return this.append(parser.parseLong(value));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Error adding value to column " + this.name() + ": " + e.getMessage());
        }
    }

    @Override
    public String getUnformattedString(int row) {
        long value = this.getLong(row);
        if (LongColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public Table countByCategory() {
        return null;
    }

    @Override
    public IntColumn asIntColumn() {
        IntColumn result = IntColumn.create(this.name());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long d = (Long)longListIterator.next();
            if (LongColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((int)d);
        }
        return result;
    }

    @Override
    public ShortColumn asShortColumn() {
        ShortColumn result = ShortColumn.create(this.name());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long d = (Long)longListIterator.next();
            if (LongColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append((short)d);
        }
        return result;
    }

    @Override
    public FloatColumn asFloatColumn() {
        FloatColumn result = FloatColumn.create(this.name());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long d = (Long)longListIterator.next();
            if (LongColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }

    @Override
    public DoubleColumn asDoubleColumn() {
        DoubleColumn result = DoubleColumn.create(this.name());
        LongListIterator longListIterator = this.data.iterator();
        while (longListIterator.hasNext()) {
            long d = (Long)longListIterator.next();
            if (LongColumnType.valueIsMissing(d)) {
                result.appendMissing();
                continue;
            }
            result.append(d);
        }
        return result;
    }
}

