/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.strings;

import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.bytes.ByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.bytes.ByteOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.strings.DictionaryMap;
import tech.tablesaw.columns.strings.NoKeysAvailableException;
import tech.tablesaw.columns.strings.ShortDictionaryMap;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class ByteDictionaryMap
implements DictionaryMap {
    private static final int MAX_UNIQUE = 255;
    private static final byte MISSING_VALUE = 127;
    private static final byte DEFAULT_RETURN_VALUE = -128;
    private final ByteComparator reverseDictionarySortComparator = (i, i1) -> -this.getValueForByteKey(i).compareTo(this.getValueForByteKey(i1));
    private final ByteComparator dictionarySortComparator = (i, i1) -> this.getValueForByteKey(i).compareTo(this.getValueForByteKey(i1));
    private ByteArrayList values = new ByteArrayList();
    private final AtomicInteger nextIndex = new AtomicInteger(-128);
    private final Byte2ObjectMap<String> keyToValue = new Byte2ObjectOpenHashMap();
    private final Object2ByteOpenHashMap<String> valueToKey = new Object2ByteOpenHashMap();
    private final Byte2IntOpenHashMap keyToCount = new Byte2IntOpenHashMap();

    public ByteDictionaryMap() {
        this.valueToKey.defaultReturnValue((byte)-128);
        this.keyToCount.defaultReturnValue(0);
    }

    private void put(byte key, String value) {
        this.keyToValue.put(key, (Object)value);
        this.valueToKey.put((Object)value, key);
    }

    void updateMaps(byte key, String value) {
        this.put(key, value);
        this.keyToCount.addTo(key, 1);
    }

    ByteArrayList values() {
        return this.values;
    }

    void addValue(byte key) {
        this.values.add(key);
    }

    ObjectSet<Byte2ObjectMap.Entry<String>> getKeyValueEntries() {
        return this.keyToValue.byte2ObjectEntrySet();
    }

    private byte getKeyForValue(String value) {
        return this.valueToKey.getByte((Object)value);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public String getValueForIndex(int rowIndex) {
        byte k = this.values.getByte(rowIndex);
        return this.getValueForKey(k);
    }

    @Override
    public int getKeyForIndex(int rowIndex) {
        return this.values.getByte(rowIndex);
    }

    private Set<String> categories() {
        return this.valueToKey.keySet();
    }

    private Byte2ObjectMap<String> keyToValueMap() {
        return this.keyToValue;
    }

    @Override
    public void sortAscending() {
        byte[] elements = this.values.toByteArray();
        ByteArrays.parallelQuickSort((byte[])elements, (ByteComparator)this.dictionarySortComparator);
        this.values = new ByteArrayList(elements);
    }

    @Override
    public String getValueForKey(int key) {
        return (String)this.keyToValue.get((byte)key);
    }

    private String getValueForByteKey(byte key) {
        return (String)this.keyToValue.get(key);
    }

    @Override
    public void sortDescending() {
        byte[] elements = this.values.toByteArray();
        ByteArrays.parallelQuickSort((byte[])elements, (ByteComparator)this.reverseDictionarySortComparator);
        this.values = new ByteArrayList(elements);
    }

    @Override
    public int countOccurrences(String value) {
        return this.keyToCount.get(this.getKeyForValue(value));
    }

    @Override
    public Set<String> asSet() {
        return this.categories();
    }

    @Override
    public int firstIndexOf(String value) {
        return this.values.indexOf(this.getKeyForValue(value));
    }

    @Override
    public String[] asObjectArray() {
        String[] output = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            output[i] = this.getValueForIndex(i);
        }
        return output;
    }

    @Override
    public Selection selectIsIn(String ... strings) {
        ByteOpenHashSet keys = new ByteOpenHashSet();
        for (String string : strings) {
            byte key = this.getKeyForValue(string);
            if (key == -128) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getByte(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public Selection selectIsIn(Collection<String> strings) {
        ByteOpenHashSet keys = new ByteOpenHashSet();
        for (String string : strings) {
            byte key = this.getKeyForValue(string);
            if (key == -128) continue;
            keys.add(key);
        }
        BitmapBackedSelection results = new BitmapBackedSelection();
        for (int i = 0; i < this.values.size(); ++i) {
            if (!keys.contains(this.values.getByte(i))) continue;
            results.add(i);
        }
        return results;
    }

    @Override
    public void append(String value) throws NoKeysAvailableException {
        byte key;
        if (value == null || StringColumnType.missingValueIndicator().equals(value)) {
            key = 127;
            this.put(key, StringColumnType.missingValueIndicator());
        } else {
            key = this.getKeyForValue(value);
        }
        if (key == -128) {
            key = this.getValueId();
            this.put(key, value);
        }
        this.values.add(key);
        this.keyToCount.addTo(key, 1);
    }

    private byte getValueId() throws NoKeysAvailableException {
        int nextValue = this.nextIndex.incrementAndGet();
        if (nextValue >= 127) {
            String msg = String.format("String column can only contain %d unique values. Column has more.", 255);
            throw new NoKeysAvailableException(msg);
        }
        return (byte)nextValue;
    }

    private void addValuesToSelection(Selection results, byte key) {
        if (key != -128) {
            int i = 0;
            ByteListIterator byteListIterator = this.values.iterator();
            while (byteListIterator.hasNext()) {
                byte next = (Byte)byteListIterator.next();
                if (key == next) {
                    results.add(i);
                }
                ++i;
            }
        }
    }

    @Override
    public void set(int rowIndex, String stringValue) throws NoKeysAvailableException {
        byte valueId;
        String str = StringColumnType.missingValueIndicator();
        if (stringValue != null) {
            str = stringValue;
        }
        if ((valueId = this.getKeyForValue(str)) == -128) {
            valueId = this.getValueId();
            this.put(valueId, str);
        }
        byte oldKey = this.values.set(rowIndex, valueId);
        this.keyToCount.addTo(valueId, 1);
        if (this.keyToCount.addTo(oldKey, -1) == 1) {
            String obsoleteValue = (String)this.keyToValue.remove(oldKey);
            this.valueToKey.removeByte((Object)obsoleteValue);
            this.keyToCount.remove(oldKey);
        }
    }

    @Override
    public void clear() {
        this.values.clear();
        this.keyToValue.clear();
        this.valueToKey.clear();
        this.keyToCount.clear();
    }

    @Override
    public int countUnique() {
        return this.keyToValueMap().size();
    }

    @Override
    public Table countByCategory(String columnName) {
        Table t = Table.create("Column: " + columnName);
        StringColumn categories = StringColumn.create("Category");
        IntColumn counts = IntColumn.create("Count");
        for (Map.Entry entry : this.keyToCount.byte2IntEntrySet()) {
            categories.append(this.getValueForKey(((Byte)entry.getKey()).byteValue()));
            counts.append((Integer)entry.getValue());
        }
        t.addColumns(new Column[]{categories});
        t.addColumns(new Column[]{counts});
        return t;
    }

    @Override
    public Selection isEqualTo(String string) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        byte key = this.getKeyForValue(string);
        this.addValuesToSelection(results, key);
        return results;
    }

    @Override
    public List<BooleanColumn> getDummies() {
        ArrayList<BooleanColumn> results = new ArrayList<BooleanColumn>();
        for (Byte2ObjectMap.Entry entry : this.keyToValueMap().byte2ObjectEntrySet()) {
            BooleanColumn column = BooleanColumn.create((String)entry.getValue());
            results.add(column);
        }
        ObjectIterator objectIterator = this.values.iterator();
        while (objectIterator.hasNext()) {
            byte next = (Byte)objectIterator.next();
            String category = this.getValueForKey(next);
            for (BooleanColumn column : results) {
                if (category.equals(column.name())) {
                    column.append(true);
                    continue;
                }
                column.append(false);
            }
        }
        return results;
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).put((byte)this.getKeyForIndex(rowNumber)).array();
    }

    private int byteSize() {
        return 1;
    }

    @Override
    public int countMissing() {
        return this.keyToCount.get((byte)127);
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private final ByteListIterator valuesIt;
            {
                this.valuesIt = ByteDictionaryMap.this.values.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.valuesIt.hasNext();
            }

            @Override
            public String next() {
                return ByteDictionaryMap.this.getValueForKey(this.valuesIt.nextByte());
            }
        };
    }

    @Override
    public void appendMissing() {
        try {
            this.append(StringColumnType.missingValueIndicator());
        }
        catch (NoKeysAvailableException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return this.getKeyForIndex(rowNumber) == 127;
    }

    @Override
    public DictionaryMap promoteYourself() {
        ShortDictionaryMap dictionaryMap;
        try {
            dictionaryMap = new ShortDictionaryMap(this);
        }
        catch (NoKeysAvailableException e) {
            throw new IllegalStateException(e);
        }
        return dictionaryMap;
    }
}

