/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns;

import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.columns.Column;

public abstract class AbstractColumn<T>
implements Column<T> {
    public static final int DEFAULT_ARRAY_SIZE = 128;
    private String name;
    private final ColumnType type;

    public AbstractColumn(ColumnType type, String name) {
        this.type = type;
        this.setName(name);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Column<T> setName(String name) {
        this.name = name.trim();
        return this;
    }

    @Override
    public ColumnType type() {
        return this.type;
    }

    @Override
    public abstract Column<T> emptyCopy();

    public String toString() {
        return this.type().getPrinterFriendlyName() + " column: " + this.name();
    }

    @Override
    public StringColumn asStringColumn() {
        StringColumn sc = StringColumn.create(this.name() + " strings");
        for (int i = 0; i < this.size(); ++i) {
            sc.append(this.getUnformattedString(i));
        }
        return sc;
    }
}

