/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.DateAndTimePredicates;
import tech.tablesaw.columns.times.PackedLocalTime;
import tech.tablesaw.columns.times.TimeColumnFormatter;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.columns.times.TimeFillers;
import tech.tablesaw.columns.times.TimeFilters;
import tech.tablesaw.columns.times.TimeMapFunctions;
import tech.tablesaw.selection.Selection;
import tech.tablesaw.sorting.comparators.DescendingIntComparator;

public class TimeColumn
extends AbstractColumn<LocalTime>
implements CategoricalColumn<LocalTime>,
TimeFilters,
TimeFillers<TimeColumn>,
TimeMapFunctions {
    private final IntComparator descendingIntComparator = DescendingIntComparator.instance();
    private TimeColumnFormatter printFormatter = new TimeColumnFormatter();
    private IntArrayList data;
    private final IntComparator comparator = (r1, r2) -> {
        int f1 = this.getIntInternal(r1);
        int f2 = this.getIntInternal(r2);
        return Integer.compare(f1, f2);
    };

    private TimeColumn(String name, IntArrayList times) {
        super(TimeColumnType.instance(), name);
        this.data = times;
    }

    private TimeColumn(String name) {
        super(TimeColumnType.instance(), name);
        this.data = new IntArrayList(128);
    }

    public static boolean valueIsMissing(int i) {
        return TimeColumnType.valueIsMissing(i);
    }

    public static TimeColumn create(String name) {
        return new TimeColumn(name);
    }

    public static TimeColumn create(String name, List<LocalTime> data) {
        TimeColumn column = new TimeColumn(name, new IntArrayList(data.size()));
        for (LocalTime time : data) {
            column.append(time);
        }
        return column;
    }

    public static TimeColumn create(String name, LocalTime[] data) {
        TimeColumn column = new TimeColumn(name, new IntArrayList(data.length));
        for (LocalTime time : data) {
            column.append(time);
        }
        return column;
    }

    public static TimeColumn create(String name, int initialSize) {
        TimeColumn column = new TimeColumn(name, new IntArrayList(initialSize));
        for (int i = 0; i < initialSize; ++i) {
            column.appendMissing();
        }
        return column;
    }

    public static TimeColumn create(String name, Stream<LocalTime> stream) {
        TimeColumn column = TimeColumn.create(name);
        stream.forEach(val -> column.append((LocalTime)val));
        return column;
    }

    public TimeColumn appendMissing() {
        this.appendInternal(TimeColumnType.missingValueIndicator());
        return this;
    }

    public TimeColumn subset(int[] rows) {
        TimeColumn c = this.emptyCopy();
        for (int row : rows) {
            c.appendInternal(this.getIntInternal(row));
        }
        return c;
    }

    @Override
    public TimeColumn lag(int n) {
        int srcPos = n >= 0 ? 0 : 0 - n;
        int[] dest = new int[this.size()];
        int destPos = n <= 0 ? 0 : n;
        int length = n >= 0 ? this.size() - n : this.size() + n;
        for (int i = 0; i < this.size(); ++i) {
            dest[i] = TimeColumnType.missingValueIndicator();
        }
        System.arraycopy(this.data.toIntArray(), srcPos, dest, destPos, length);
        TimeColumn copy = this.emptyCopy(this.size());
        copy.data = new IntArrayList(dest);
        copy.setName(this.name() + " lag(" + n + ")");
        return copy;
    }

    @Override
    public boolean isMissing(int rowNumber) {
        return TimeColumn.valueIsMissing(this.getIntInternal(rowNumber));
    }

    @Override
    public int size() {
        return this.data.size();
    }

    public TimeColumn appendInternal(int f) {
        this.data.add(f);
        return this;
    }

    public TimeColumn append(LocalTime time) {
        int value = time == null ? TimeColumnType.missingValueIndicator() : PackedLocalTime.pack(time);
        this.appendInternal(value);
        return this;
    }

    public TimeColumn appendObj(Object obj) {
        if (obj == null) {
            return this.appendMissing();
        }
        if (!(obj instanceof LocalTime)) {
            throw new IllegalArgumentException("Cannot append " + obj.getClass().getName() + " to TimeColumn");
        }
        return this.append((LocalTime)obj);
    }

    public TimeColumn removeMissing() {
        TimeColumn noMissing = this.emptyCopy();
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            int i = iterator.nextInt();
            if (TimeColumn.valueIsMissing(i)) continue;
            noMissing.appendInternal(i);
        }
        return noMissing;
    }

    @Override
    public String getString(int row) {
        return this.printFormatter.format(this.getPackedTime(row));
    }

    @Override
    public String getUnformattedString(int row) {
        return PackedLocalTime.toShortTimeString(this.getPackedTime(row));
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter, String missingValueString) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        Preconditions.checkNotNull((Object)missingValueString);
        this.printFormatter = new TimeColumnFormatter(dateTimeFormatter, missingValueString);
    }

    public void setPrintFormatter(DateTimeFormatter dateTimeFormatter) {
        Preconditions.checkNotNull((Object)dateTimeFormatter);
        this.printFormatter = new TimeColumnFormatter(dateTimeFormatter);
    }

    public TimeColumn emptyCopy() {
        TimeColumn empty = TimeColumn.create(this.name());
        empty.printFormatter = this.printFormatter;
        return empty;
    }

    public TimeColumn emptyCopy(int rowSize) {
        TimeColumn column = TimeColumn.create(this.name(), rowSize);
        column.printFormatter = this.printFormatter;
        return column;
    }

    public TimeColumn copy() {
        TimeColumn column = this.emptyCopy(this.size());
        column.data = this.data.clone();
        return column;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public List<LocalTime> asList() {
        ArrayList<LocalTime> times = new ArrayList<LocalTime>();
        for (LocalTime time : this) {
            times.add(time);
        }
        return times;
    }

    @Override
    public void sortAscending() {
        int[] sorted = this.data.toIntArray();
        Arrays.parallelSort(sorted);
        this.data = new IntArrayList(sorted);
    }

    @Override
    public void sortDescending() {
        IntArrays.parallelQuickSort((int[])this.data.elements(), (IntComparator)this.descendingIntComparator);
    }

    public LocalTime max() {
        if (this.isEmpty()) {
            return null;
        }
        int max = this.getIntInternal(0);
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            max = max > aData ? max : aData;
        }
        if (max == TimeColumnType.missingValueIndicator()) {
            return null;
        }
        return PackedLocalTime.asLocalTime(max);
    }

    @Override
    public LocalTime min() {
        if (this.isEmpty()) {
            return null;
        }
        int min = Integer.MAX_VALUE;
        IntListIterator intListIterator = this.data.iterator();
        while (intListIterator.hasNext()) {
            int aData = (Integer)intListIterator.next();
            if (aData == TimeColumnType.missingValueIndicator()) continue;
            min = min < aData ? min : aData;
        }
        if (min == Integer.MAX_VALUE) {
            return null;
        }
        return PackedLocalTime.asLocalTime(min);
    }

    @Override
    public Table summary() {
        Table table = Table.create("Column: " + this.name());
        StringColumn measure = StringColumn.create("Measure");
        StringColumn value = StringColumn.create("Value");
        table.addColumns(new Column[]{measure});
        table.addColumns(new Column[]{value});
        measure.append("Count");
        value.append(String.valueOf(this.size()));
        measure.append("Missing");
        value.append(String.valueOf(this.countMissing()));
        measure.append("Earliest");
        value.append(String.valueOf(this.min()));
        measure.append("Latest");
        value.append(String.valueOf(this.max()));
        return table;
    }

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.getIntInternal(i) != TimeColumnType.missingValueIndicator()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int countUnique() {
        IntOpenHashSet hashSet = new IntOpenHashSet((IntCollection)this.data);
        return hashSet.size();
    }

    public TimeColumn unique() {
        IntOpenHashSet ints = new IntOpenHashSet((IntCollection)this.data);
        TimeColumn column = this.emptyCopy(ints.size());
        column.data = IntArrayList.wrap((int[])ints.toIntArray());
        column.setName(this.name() + " Unique values");
        return column;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public TimeColumn appendCell(String object) {
        this.appendInternal(PackedLocalTime.pack(TimeColumnType.DEFAULT_PARSER.parse(object)));
        return this;
    }

    public TimeColumn appendCell(String object, AbstractColumnParser<?> parser) {
        return this.appendObj(parser.parse(object));
    }

    @Override
    public int getIntInternal(int index) {
        return this.data.getInt(index);
    }

    protected int getPackedTime(int index) {
        return this.getIntInternal(index);
    }

    @Override
    public LocalTime get(int index) {
        return PackedLocalTime.asLocalTime(this.getIntInternal(index));
    }

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Deprecated
    public IntArrayList data() {
        return this.data;
    }

    public double getDouble(int i) {
        return this.getIntInternal(i);
    }

    public double[] asDoubleArray() {
        double[] doubles = new double[this.data.size()];
        for (int i = 0; i < this.size(); ++i) {
            doubles[i] = this.data.getInt(i);
        }
        return doubles;
    }

    public DoubleColumn asDoubleColumn() {
        return DoubleColumn.create(this.name(), this.asDoubleArray());
    }

    @Override
    public String toString() {
        return "LocalTime column: " + this.name();
    }

    public TimeColumn append(Column<LocalTime> column) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        TimeColumn timeCol = (TimeColumn)column;
        int size = timeCol.size();
        for (int i = 0; i < size; ++i) {
            this.appendInternal(timeCol.getIntInternal(i));
        }
        return this;
    }

    public TimeColumn append(Column<LocalTime> column, int row) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.appendInternal(((TimeColumn)column).getIntInternal(row));
    }

    public TimeColumn set(int row, Column<LocalTime> column, int sourceRow) {
        Preconditions.checkArgument((column.type() == this.type() ? 1 : 0) != 0);
        return this.set(row, ((TimeColumn)column).getIntInternal(sourceRow));
    }

    public List<LocalTime> top(int n) {
        ArrayList<LocalTime> top = new ArrayList<LocalTime>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values, (IntComparator)this.descendingIntComparator);
        for (int i = 0; i < n && i < values.length; ++i) {
            top.add(PackedLocalTime.asLocalTime(values[i]));
        }
        return top;
    }

    public List<LocalTime> bottom(int n) {
        ArrayList<LocalTime> bottom = new ArrayList<LocalTime>();
        int[] values = this.data.toIntArray();
        IntArrays.parallelQuickSort((int[])values);
        int validCount = 0;
        for (int rowCount = 0; validCount < n && rowCount < this.size(); ++rowCount) {
            int value = values[rowCount];
            if (value == TimeColumnType.missingValueIndicator()) continue;
            bottom.add(PackedLocalTime.asLocalTime(value));
            ++validCount;
        }
        return bottom;
    }

    public TimeColumn set(int index, int value) {
        this.data.set(index, value);
        return this;
    }

    public TimeColumn set(int index, LocalTime value) {
        this.set(index, PackedLocalTime.pack(value));
        return this;
    }

    public TimeColumn set(Selection rowSelection, LocalTime newValue) {
        IntIterator intIterator = rowSelection.iterator();
        while (intIterator.hasNext()) {
            int row = (Integer)intIterator.next();
            this.set(row, newValue);
        }
        return this;
    }

    public IntIterator intIterator() {
        return this.data.iterator();
    }

    @Override
    public boolean contains(LocalTime time) {
        int t = PackedLocalTime.pack(time);
        return this.data.contains(t);
    }

    public TimeColumn setMissing(int i) {
        this.data.set(i, TimeColumnType.missingValueIndicator());
        return this;
    }

    @Override
    public Selection isMissing() {
        return this.eval(DateAndTimePredicates.isMissing);
    }

    @Override
    public Selection isNotMissing() {
        return this.eval(DateAndTimePredicates.isNotMissing);
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public byte[] asBytes(int rowNumber) {
        return ByteBuffer.allocate(this.byteSize()).putInt(this.getIntInternal(rowNumber)).array();
    }

    @Override
    public Iterator<LocalTime> iterator() {
        return new Iterator<LocalTime>(){
            final IntIterator intIterator;
            {
                this.intIterator = TimeColumn.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.intIterator.hasNext();
            }

            @Override
            public LocalTime next() {
                return PackedLocalTime.asLocalTime(this.intIterator.nextInt());
            }
        };
    }

    @Override
    public TimeColumn where(Selection selection) {
        return this.subset(selection.toArray());
    }

    private TimeColumn fillWith(int count, Iterator<LocalTime> iterator, Consumer<LocalTime> acceptor) {
        for (int r = 0; r < count && iterator.hasNext(); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    public LocalTime[] asObjectArray() {
        LocalTime[] output = new LocalTime[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            output[i] = this.get(i);
        }
        return output;
    }

    @Override
    public TimeColumn fillWith(Iterator<LocalTime> iterator) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterator, (LocalTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalTime)date);
        });
        return this;
    }

    private TimeColumn fillWith(int count, Iterable<LocalTime> iterable, Consumer<LocalTime> acceptor) {
        Iterator<LocalTime> iterator = iterable.iterator();
        for (int r = 0; r < count && (iterator.hasNext() || (iterator = iterable.iterator()).hasNext()); ++r) {
            acceptor.accept(iterator.next());
        }
        return this;
    }

    @Override
    public TimeColumn fillWith(Iterable<LocalTime> iterable) {
        int[] r = new int[1];
        this.fillWith(this.size(), iterable, (LocalTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalTime)date);
        });
        return this;
    }

    private TimeColumn fillWith(int count, Supplier<LocalTime> supplier, Consumer<LocalTime> acceptor) {
        for (int r = 0; r < count; ++r) {
            try {
                acceptor.accept(supplier.get());
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        return this;
    }

    @Override
    public TimeColumn fillWith(Supplier<LocalTime> supplier) {
        int[] r = new int[1];
        this.fillWith(this.size(), supplier, (LocalTime date) -> {
            int n = r[0];
            r[0] = n + 1;
            this.set(n, (LocalTime)date);
        });
        return this;
    }

    @Override
    public int compare(LocalTime o1, LocalTime o2) {
        return o1.compareTo(o2);
    }

    public TimeColumn filter(Predicate<? super LocalTime> test) {
        return (TimeColumn)super.filter(test);
    }

    public TimeColumn sorted(Comparator<? super LocalTime> comp) {
        return (TimeColumn)super.sorted(comp);
    }

    public TimeColumn map(Function<? super LocalTime, ? extends LocalTime> fun) {
        return (TimeColumn)super.map(fun);
    }

    public TimeColumn min(Column<LocalTime> other) {
        return (TimeColumn)super.min(other);
    }

    public TimeColumn max(Column<LocalTime> other) {
        return (TimeColumn)super.max(other);
    }

    public TimeColumn set(Selection condition, Column<LocalTime> other) {
        return (TimeColumn)super.set(condition, other);
    }

    public TimeColumn first(int numRows) {
        return (TimeColumn)super.first(numRows);
    }

    public TimeColumn last(int numRows) {
        return (TimeColumn)super.last(numRows);
    }

    public TimeColumn inRange(int start, int end) {
        return (TimeColumn)super.inRange(start, end);
    }

    public TimeColumn sampleN(int n) {
        return (TimeColumn)super.sampleN(n);
    }

    public TimeColumn sampleX(double proportion) {
        return (TimeColumn)super.sampleX(proportion);
    }
}

