/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.joining;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.FloatColumn;
import tech.tablesaw.api.InstantColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.Row;
import tech.tablesaw.api.ShortColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.booleans.BooleanColumnType;
import tech.tablesaw.columns.dates.DateColumnType;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.instant.InstantColumnType;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.FloatColumnType;
import tech.tablesaw.columns.numbers.IntColumnType;
import tech.tablesaw.columns.numbers.LongColumnType;
import tech.tablesaw.columns.numbers.ShortColumnType;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.strings.TextColumnType;
import tech.tablesaw.columns.times.TimeColumnType;
import tech.tablesaw.index.ByteIndex;
import tech.tablesaw.index.DoubleIndex;
import tech.tablesaw.index.FloatIndex;
import tech.tablesaw.index.Index;
import tech.tablesaw.index.IntIndex;
import tech.tablesaw.index.LongIndex;
import tech.tablesaw.index.ShortIndex;
import tech.tablesaw.index.StringIndex;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public class DataFrameJoiner {
    private static final String TABLE_ALIAS = "T";
    private final Table table;
    private Column<?>[] joinColumns;
    private final String[] columnNames;
    private AtomicInteger joinTableId = new AtomicInteger(2);

    public DataFrameJoiner(Table table, String ... columnNames) {
        this.table = table;
        this.joinColumns = new Column[columnNames.length];
        this.columnNames = columnNames;
        for (int i = 0; i < this.columnNames.length; ++i) {
            String colName = this.columnNames[i];
            this.joinColumns[i] = table.column(colName);
        }
    }

    public Table inner(Table ... tables) {
        return this.inner(false, tables);
    }

    public Table inner(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table currT : tables) {
            joined = this.joinInternal(joined, currT, false, allowDuplicateColumnNames, this.columnNames);
        }
        return joined;
    }

    public Table inner(Table table2, String col2Name) {
        return this.inner(table2, false, col2Name);
    }

    public Table inner(Table table2, String[] col2Names) {
        return this.inner(table2, false, col2Names);
    }

    public Table inner(Table table2, String col2Name, boolean allowDuplicateColumnNames) {
        return this.inner(table2, allowDuplicateColumnNames, col2Name);
    }

    public Table inner(Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        return this.inner(table2, false, allowDuplicateColumnNames, col2Names);
    }

    public Table inner(Table table2, boolean outer, boolean allowDuplicateColumnNames, String ... col2Names) {
        Table joinedTable = this.joinInternal(this.table, table2, outer, allowDuplicateColumnNames, col2Names);
        return joinedTable;
    }

    private Table joinInternal(Table table1, Table table2, boolean outer, boolean allowDuplicates, String ... col2Names) {
        if (allowDuplicates) {
            this.renameColumnsWithDuplicateNames(table1, table2, col2Names);
        }
        Table result = this.emptyTableFromColumns(table1, table2, col2Names);
        HashMap columnIndexMap = new HashMap();
        for (int i = 0; i < this.joinColumns.length; ++i) {
            Column<?> col = this.joinColumns[i];
            String col2Name = col2Names[i];
            columnIndexMap.put(col, this.indexFor(table2, col2Name, col));
        }
        for (Row row : table1) {
            int ri = row.getRowNumber();
            Table table1Rows = table1.where(Selection.with(ri));
            Selection rowBitMapMultiCol = null;
            for (int i = 0; i < this.joinColumns.length; ++i) {
                AbstractColumn col1;
                Index index;
                Column<?> column = this.joinColumns[i];
                Column<?> table1Column = table1.column(column.name());
                ColumnType type = table1Column.type();
                Selection rowBitMapOneCol = null;
                if (type instanceof DateColumnType) {
                    index = (IntIndex)columnIndexMap.get(column);
                    col1 = (DateColumn)table1Column;
                    int value = ((DateColumn)col1).getIntInternal(ri);
                    rowBitMapOneCol = ((IntIndex)index).get(value);
                } else if (type instanceof TimeColumnType) {
                    index = (IntIndex)columnIndexMap.get(column);
                    col1 = (TimeColumn)table1Column;
                    int value = ((TimeColumn)col1).getIntInternal(ri);
                    rowBitMapOneCol = ((IntIndex)index).get(value);
                } else if (type instanceof DateTimeColumnType) {
                    index = (LongIndex)columnIndexMap.get(column);
                    col1 = (DateTimeColumn)table1Column;
                    long value = ((DateTimeColumn)col1).getLongInternal(ri);
                    rowBitMapOneCol = ((LongIndex)index).get(value);
                } else if (type instanceof InstantColumnType) {
                    index = (LongIndex)columnIndexMap.get(column);
                    col1 = (InstantColumn)table1Column;
                    long value = ((InstantColumn)col1).getLongInternal(ri);
                    rowBitMapOneCol = ((LongIndex)index).get(value);
                } else if (type instanceof StringColumnType || type instanceof TextColumnType) {
                    index = (StringIndex)columnIndexMap.get(column);
                    col1 = (StringColumn)table1Column;
                    String value = ((StringColumn)col1).get(ri);
                    rowBitMapOneCol = ((StringIndex)index).get(value);
                } else if (type instanceof IntColumnType) {
                    index = (IntIndex)columnIndexMap.get(column);
                    col1 = (IntColumn)table1Column;
                    int value = ((IntColumn)col1).getInt(ri);
                    rowBitMapOneCol = ((IntIndex)index).get(value);
                } else if (type instanceof LongColumnType) {
                    index = (LongIndex)columnIndexMap.get(column);
                    col1 = (LongColumn)table1Column;
                    long value = ((LongColumn)col1).getLong(ri);
                    rowBitMapOneCol = ((LongIndex)index).get(value);
                } else if (type instanceof ShortColumnType) {
                    index = (ShortIndex)columnIndexMap.get(column);
                    col1 = (ShortColumn)table1Column;
                    short value = ((ShortColumn)col1).getShort(ri);
                    rowBitMapOneCol = ((ShortIndex)index).get(value);
                } else if (type instanceof BooleanColumnType) {
                    index = (ByteIndex)columnIndexMap.get(column);
                    col1 = (BooleanColumn)table1Column;
                    byte value = ((BooleanColumn)col1).getByte(ri);
                    rowBitMapOneCol = ((ByteIndex)index).get(value);
                } else if (type instanceof DoubleColumnType) {
                    index = (DoubleIndex)columnIndexMap.get(column);
                    col1 = (DoubleColumn)table1Column;
                    double value = ((DoubleColumn)col1).getDouble(ri);
                    rowBitMapOneCol = ((DoubleIndex)index).get(value);
                } else if (type instanceof FloatColumnType) {
                    index = (FloatIndex)columnIndexMap.get(column);
                    col1 = (FloatColumn)table1Column;
                    float value = ((FloatColumn)col1).getFloat(ri);
                    rowBitMapOneCol = ((FloatIndex)index).get(value);
                } else {
                    throw new IllegalArgumentException("Joining is supported on numeric, string, and date-like columns. Column " + table1Column.name() + " is of type " + table1Column.type());
                }
                if (rowBitMapOneCol == null) continue;
                rowBitMapMultiCol = rowBitMapMultiCol != null ? rowBitMapMultiCol.and(rowBitMapOneCol) : rowBitMapOneCol;
            }
            Table table2Rows = table2.where(rowBitMapMultiCol);
            if (outer && table2Rows.isEmpty()) {
                this.withMissingLeftJoin(result, table1Rows);
                continue;
            }
            this.crossProduct(result, table1Rows, table2Rows, col2Names);
        }
        return result;
    }

    private Index indexFor(Table table2, String col2Name, Column<?> col) {
        ColumnType type = col.type();
        if (type instanceof DateColumnType) {
            return new IntIndex(table2.dateColumn(col2Name));
        }
        if (type instanceof DateTimeColumnType) {
            return new LongIndex(table2.dateTimeColumn(col2Name));
        }
        if (type instanceof InstantColumnType) {
            return new LongIndex(table2.instantColumn(col2Name));
        }
        if (type instanceof TimeColumnType) {
            return new IntIndex(table2.timeColumn(col2Name));
        }
        if (type instanceof StringColumnType || type instanceof TextColumnType) {
            return new StringIndex(table2.stringColumn(col2Name));
        }
        if (type instanceof IntColumnType) {
            return new IntIndex(table2.intColumn(col2Name));
        }
        if (type instanceof LongColumnType) {
            return new LongIndex(table2.longColumn(col2Name));
        }
        if (type instanceof ShortColumnType) {
            return new ShortIndex(table2.shortColumn(col2Name));
        }
        if (type instanceof BooleanColumnType) {
            return new ByteIndex(table2.booleanColumn(col2Name));
        }
        if (type instanceof DoubleColumnType) {
            return new DoubleIndex(table2.doubleColumn(col2Name));
        }
        if (type instanceof FloatColumnType) {
            return new FloatIndex(table2.floatColumn(col2Name));
        }
        throw new IllegalArgumentException("Joining attempted on unsupported column type " + col.type());
    }

    private void renameColumnsWithDuplicateNames(Table table1, Table table2, String ... col2Names) {
        String table2Alias = TABLE_ALIAS + this.joinTableId.getAndIncrement();
        List<String> list = Arrays.asList(col2Names);
        for (Column<?> table2Column : table2.columns()) {
            String columnName = table2Column.name();
            if (!table1.columnNames().stream().anyMatch(columnName::equalsIgnoreCase)) continue;
            if (list.stream().anyMatch(columnName::equalsIgnoreCase)) continue;
            table2Column.setName(this.newName(table2Alias, columnName));
        }
    }

    private String newName(String table2Alias, String columnName) {
        return table2Alias + "." + columnName;
    }

    public Table fullOuter(Table ... tables) {
        return this.fullOuter(false, tables);
    }

    public Table fullOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table currT : tables) {
            joined = this.fullOuter(joined, currT, allowDuplicateColumnNames, this.columnNames);
        }
        return joined;
    }

    public Table fullOuter(Table table2, String col2Name) {
        return this.fullOuter(this.table, table2, false, col2Name);
    }

    public Table fullOuter(Table table1, Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        Table result = this.joinInternal(table1, table2, true, allowDuplicateColumnNames, col2Names);
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (Row row : table2) {
            int ri = row.getRowNumber();
            Selection rowBitMapMultiCol = null;
            for (int i = 0; i < this.joinColumns.length; ++i) {
                AbstractColumn col2;
                Index index;
                Column<?> column = this.joinColumns[i];
                Column<?> table1Column = table1.column(column.name());
                ColumnType type = table1Column.type();
                String col2Name = col2Names[i];
                Selection rowBitMapOneCol = null;
                if (type instanceof DateColumnType) {
                    index = new IntIndex(result.dateColumn(col2Name));
                    col2 = (DateColumn)table2.column(col2Name);
                    int value = ((DateColumn)col2).getIntInternal(ri);
                    rowBitMapOneCol = ((IntIndex)index).get(value);
                } else if (type instanceof DateTimeColumnType) {
                    index = new LongIndex(result.dateTimeColumn(col2Name));
                    col2 = (DateTimeColumn)table2.column(col2Name);
                    long value = ((DateTimeColumn)col2).getLongInternal(ri);
                    rowBitMapOneCol = ((LongIndex)index).get(value);
                } else if (type instanceof InstantColumnType) {
                    index = new LongIndex(result.instantColumn(col2Name));
                    col2 = (InstantColumn)table2.column(col2Name);
                    long value = ((InstantColumn)col2).getLongInternal(ri);
                    rowBitMapOneCol = ((LongIndex)index).get(value);
                } else if (type instanceof TimeColumnType) {
                    index = new IntIndex(result.timeColumn(col2Name));
                    col2 = (TimeColumn)table2.column(col2Name);
                    int value = ((TimeColumn)col2).getIntInternal(ri);
                    rowBitMapOneCol = ((IntIndex)index).get(value);
                } else if (type instanceof StringColumnType || type instanceof TextColumnType) {
                    index = new StringIndex(result.stringColumn(col2Name));
                    col2 = (StringColumn)table2.column(col2Name);
                    String value = ((StringColumn)col2).get(ri);
                    rowBitMapOneCol = ((StringIndex)index).get(value);
                } else if (type instanceof IntColumnType) {
                    index = new IntIndex(result.intColumn(col2Name));
                    col2 = (IntColumn)table2.column(col2Name);
                    int value = ((IntColumn)col2).getInt(ri);
                    rowBitMapOneCol = ((IntIndex)index).get(value);
                } else if (type instanceof LongColumnType) {
                    index = new LongIndex(result.longColumn(col2Name));
                    col2 = (LongColumn)table2.column(col2Name);
                    long value = ((LongColumn)col2).getLong(ri);
                    rowBitMapOneCol = ((LongIndex)index).get(value);
                } else if (type instanceof ShortColumnType) {
                    index = new ShortIndex(result.shortColumn(col2Name));
                    col2 = (ShortColumn)table2.column(col2Name);
                    short value = ((ShortColumn)col2).getShort(ri);
                    rowBitMapOneCol = ((ShortIndex)index).get(value);
                } else if (type instanceof BooleanColumnType) {
                    index = new ByteIndex(result.booleanColumn(col2Name));
                    col2 = (BooleanColumn)table2.column(col2Name);
                    byte value = ((BooleanColumn)col2).getByte(ri);
                    rowBitMapOneCol = ((ByteIndex)index).get(value);
                } else if (type instanceof DoubleColumnType) {
                    index = new DoubleIndex(result.doubleColumn(col2Name));
                    col2 = (DoubleColumn)table2.column(col2Name);
                    double value = ((DoubleColumn)col2).getDouble(ri);
                    rowBitMapOneCol = ((DoubleIndex)index).get(value);
                } else if (type instanceof FloatColumnType) {
                    index = new FloatIndex(result.floatColumn(col2Name));
                    col2 = (FloatColumn)table2.column(col2Name);
                    float value = ((FloatColumn)col2).getFloat(ri);
                    rowBitMapOneCol = ((FloatIndex)index).get(value);
                } else {
                    throw new IllegalArgumentException("Joining is supported on numeric, string, and date-like columns. Column " + table1Column.name() + " is of type " + table1Column.type());
                }
                if (rowBitMapOneCol == null) continue;
                rowBitMapMultiCol = rowBitMapMultiCol != null ? rowBitMapMultiCol.and(rowBitMapOneCol) : rowBitMapOneCol;
            }
            if (!rowBitMapMultiCol.isEmpty()) continue;
            selection.add(ri);
        }
        Table table2OnlyRows = table2.where(selection);
        List<Column<?>> joinColumns = table2OnlyRows.columns(col2Names);
        table2OnlyRows.removeColumns(col2Names);
        this.withMissingRightJoin(result, joinColumns, table2OnlyRows);
        return result;
    }

    public Table leftOuter(Table ... tables) {
        return this.leftOuter(false, tables);
    }

    public Table leftOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.leftOuter(table2, allowDuplicateColumnNames, this.columnNames);
        }
        return joined;
    }

    public Table leftOuter(Table table2, String[] col2Names) {
        return this.leftOuter(table2, false, col2Names);
    }

    public Table leftOuter(Table table2, String col2Name) {
        return this.leftOuter(table2, false, col2Name);
    }

    public Table leftOuter(Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        return this.joinInternal(this.table, table2, true, allowDuplicateColumnNames, col2Names);
    }

    public Table rightOuter(Table ... tables) {
        return this.rightOuter(false, tables);
    }

    public Table rightOuter(boolean allowDuplicateColumnNames, Table ... tables) {
        Table joined = this.table;
        for (Table table2 : tables) {
            joined = this.rightOuter(table2, allowDuplicateColumnNames, this.columnNames);
        }
        return joined;
    }

    public Table rightOuter(Table table2, String col2Name) {
        return this.rightOuter(table2, false, col2Name);
    }

    public Table rightOuter(Table table2, String[] col2Names) {
        return this.rightOuter(table2, false, col2Names);
    }

    public Table rightOuter(Table table2, boolean allowDuplicateColumnNames, String ... col2Names) {
        Table leftOuter = table2.joinOn(col2Names).leftOuter(this.table, allowDuplicateColumnNames, this.columnNames);
        Table result = Table.create(leftOuter.name());
        for (String name : this.table.columnNames()) {
            try {
                result.addColumns(new Column[]{leftOuter.column(name)});
            }
            catch (IllegalStateException illegalStateException) {}
        }
        for (String name : table2.columnNames()) {
            if (result.columnNames().stream().anyMatch(name::equalsIgnoreCase)) continue;
            result.addColumns(new Column[]{leftOuter.column(name)});
        }
        return result;
    }

    private Table emptyTableFromColumns(Table table1, Table table2, String ... col2Names) {
        Column[] cols = (Column[])Streams.concat((Stream[])new Stream[]{table1.columns().stream(), table2.columns().stream().filter(c -> !Arrays.asList(col2Names).stream().anyMatch(c.name()::equalsIgnoreCase))}).map(Column::emptyCopy).toArray(Column[]::new);
        return Table.create(table1.name(), cols);
    }

    private void crossProduct(Table destination, Table table1, Table table2, String[] col2Names) {
        int table2RowCount = table2.rowCount();
        table2.removeColumns(col2Names);
        for (int c = 0; c < table1.columnCount() + table2.columnCount(); ++c) {
            for (int r1 = 0; r1 < table1.rowCount(); ++r1) {
                for (int r2 = 0; r2 < table2RowCount; ++r2) {
                    if (c < table1.columnCount()) {
                        Column<?> t1Col = table1.column(c);
                        destination.column(c).append(t1Col, r1);
                        continue;
                    }
                    Column<?> t2Col = table2.column(c - table1.columnCount());
                    destination.column(c).append(t2Col, r2);
                }
            }
        }
    }

    private void withMissingLeftJoin(Table destination, Table table1) {
        for (int c = 0; c < destination.columnCount(); ++c) {
            if (c < table1.columnCount()) {
                Column<?> t1Col = table1.column(c);
                destination.column(c).append(t1Col);
                continue;
            }
            for (int r1 = 0; r1 < table1.rowCount(); ++r1) {
                destination.column(c).appendMissing();
            }
        }
    }

    private void withMissingRightJoin(Table destination, List<Column<?>> joinColumns, Table table2) {
        int t2StartCol = destination.columnCount() - table2.columnCount();
        for (int c = 0; c < destination.columnCount(); ++c) {
            boolean addedJoinColumns = false;
            for (Column<?> joinColumn : joinColumns) {
                if (!destination.column(c).name().equalsIgnoreCase(joinColumn.name())) continue;
                destination.column(c).append(joinColumn);
                addedJoinColumns = true;
            }
            if (addedJoinColumns) continue;
            if (c < t2StartCol) {
                for (int r2 = 0; r2 < table2.rowCount(); ++r2) {
                    destination.column(c).appendMissing();
                }
                continue;
            }
            Column<?> t2Col = table2.column(c - t2StartCol);
            destination.column(c).append(t2Col);
        }
    }
}

