/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.temporal.ChronoUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import tech.tablesaw.api.DateColumn;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.LongColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.TimeColumn;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.instant.PackedInstant;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;
import tech.tablesaw.columns.strings.StringColumnType;
import tech.tablesaw.columns.temporal.TemporalMapFunctions;
import tech.tablesaw.columns.times.TimeColumnType;

public interface DateTimeMapFunctions
extends TemporalMapFunctions<LocalDateTime> {
    default public IntColumn hour() {
        IntColumn newColumn = IntColumn.create(this.name() + "[hour]");
        for (int r = 0; r < this.size(); ++r) {
            if (!this.isMissing(r)) {
                long c1 = this.getLongInternal(r);
                newColumn.append(PackedLocalDateTime.getHour(c1));
                continue;
            }
            newColumn.appendMissing();
        }
        return newColumn;
    }

    default public IntColumn minuteOfDay() {
        IntColumn newColumn = IntColumn.create(this.name() + "[minute-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            if (!this.isMissing(r)) {
                long c1 = this.getLongInternal(r);
                newColumn.append((short)PackedLocalDateTime.getMinuteOfDay(c1));
                continue;
            }
            newColumn.appendMissing();
        }
        return newColumn;
    }

    default public IntColumn secondOfDay() {
        IntColumn newColumn = IntColumn.create(this.name() + "[second-of-day]");
        for (int r = 0; r < this.size(); ++r) {
            if (!this.isMissing(r)) {
                long c1 = this.getLongInternal(r);
                newColumn.append(PackedLocalDateTime.getSecondOfDay(c1));
                continue;
            }
            newColumn.appendMissing();
        }
        return newColumn;
    }

    default public DateTimeColumn lead(int n) {
        DateTimeColumn column = this.lag(-n);
        column.setName(this.name() + " lead(" + n + ")");
        return column;
    }

    public DateTimeColumn lag(int var1);

    default public TimeColumn time() {
        TimeColumn newColumn = TimeColumn.create(this.name() + " time");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.appendInternal(TimeColumnType.missingValueIndicator());
                continue;
            }
            newColumn.appendInternal(PackedLocalDateTime.time(c1));
        }
        return newColumn;
    }

    default public IntColumn monthValue() {
        IntColumn newColumn = IntColumn.create(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) {
                newColumn.appendMissing();
                continue;
            }
            long c1 = this.getLongInternal(r);
            newColumn.append(PackedLocalDateTime.getMonthValue(c1));
        }
        return newColumn;
    }

    default public StringColumn month() {
        StringColumn newColumn = StringColumn.create(this.name() + " month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            newColumn.append(Month.of(PackedLocalDateTime.getMonthValue(c1)).name());
        }
        return newColumn;
    }

    default public StringColumn yearQuarter() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & quarter");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            String yq = String.valueOf(PackedLocalDateTime.getYear(c1)) + "-" + PackedLocalDateTime.getQuarter(c1);
            newColumn.append(yq);
        }
        return newColumn;
    }

    default public StringColumn yearMonth() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            String ym = String.valueOf(PackedLocalDateTime.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getMonthValue(c1)), (int)2, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public StringColumn yearDay() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            String ym = String.valueOf(PackedLocalDateTime.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getDayOfYear(c1)), (int)3, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public StringColumn hourMinute() {
        StringColumn newColumn = StringColumn.create(this.name() + " hour & minute");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            String hm = Strings.padStart((String)String.valueOf(PackedLocalDateTime.getHour(c1)), (int)2, (char)'0');
            hm = hm + ":" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getMinute(c1)), (int)2, (char)'0');
            newColumn.append(hm);
        }
        return newColumn;
    }

    default public StringColumn yearWeek() {
        StringColumn newColumn = StringColumn.create(this.name() + " year & month");
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) {
                newColumn.append(StringColumnType.missingValueIndicator());
                continue;
            }
            String ym = String.valueOf(PackedLocalDateTime.getYear(c1));
            ym = ym + "-" + Strings.padStart((String)String.valueOf(PackedLocalDateTime.getWeekOfYear(c1)), (int)2, (char)'0');
            newColumn.append(ym);
        }
        return newColumn;
    }

    default public DateColumn date() {
        DateColumn newColumn = DateColumn.create(this.name() + " date");
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) {
                newColumn.appendMissing();
                continue;
            }
            long c1 = this.getLongInternal(r);
            newColumn.appendInternal(PackedLocalDateTime.date(c1));
        }
        return newColumn;
    }

    default public IntColumn year() {
        IntColumn newColumn = IntColumn.create(this.name() + " year");
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) {
                newColumn.appendMissing();
                continue;
            }
            long c1 = this.getLongInternal(r);
            newColumn.append(PackedLocalDate.getYear(PackedLocalDateTime.date(c1)));
        }
        return newColumn;
    }

    default public StringColumn dayOfWeek() {
        StringColumn newColumn = StringColumn.create(this.name() + " day of week", this.size());
        for (int r = 0; r < this.size(); ++r) {
            long c1 = this.getLongInternal(r);
            if (DateTimeColumn.valueIsMissing(c1)) continue;
            newColumn.set(r, PackedLocalDateTime.getDayOfWeek(c1).toString());
        }
        return newColumn;
    }

    default public IntColumn dayOfWeekValue() {
        IntColumn newColumn = IntColumn.create(this.name() + " day of week value", this.size());
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) continue;
            long c1 = this.getLongInternal(r);
            newColumn.set(r, (short)PackedLocalDateTime.getDayOfWeek(c1).getValue());
        }
        return newColumn;
    }

    default public IntColumn dayOfYear() {
        IntColumn newColumn = IntColumn.create(this.name() + " day of year", this.size());
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) continue;
            long c1 = this.getLongInternal(r);
            newColumn.set(r, (short)PackedLocalDateTime.getDayOfYear(c1));
        }
        return newColumn;
    }

    default public IntColumn dayOfMonth() {
        IntColumn newColumn = IntColumn.create(this.name() + " day of month", this.size());
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) continue;
            long c1 = this.getLongInternal(r);
            newColumn.set(r, PackedLocalDateTime.getDayOfMonth(c1));
        }
        return newColumn;
    }

    default public LongColumn timeWindow(ChronoUnit unit, int n, LocalDateTime start) {
        String newColumnName = "" + n + " " + unit.toString() + " window [" + this.name() + "]";
        long packedStartDate = PackedLocalDateTime.pack(start);
        LongColumn numberColumn = LongColumn.create(newColumnName, this.size());
        block8: for (int i = 0; i < this.size(); ++i) {
            long packedDate = this.getLongInternal(i);
            switch (unit) {
                case MINUTES: {
                    long result = PackedInstant.minutesUntil(packedDate, packedStartDate) / (long)n;
                    numberColumn.set(i, result);
                    continue block8;
                }
                case HOURS: {
                    long result = PackedInstant.hoursUntil(packedDate, packedStartDate) / (long)n;
                    numberColumn.set(i, result);
                    continue block8;
                }
                case DAYS: {
                    long result = PackedInstant.daysUntil(packedDate, packedStartDate) / n;
                    numberColumn.set(i, result);
                    continue block8;
                }
                case WEEKS: {
                    long result = PackedInstant.weeksUntil(packedDate, packedStartDate) / n;
                    numberColumn.set(i, result);
                    continue block8;
                }
                case MONTHS: {
                    long result = PackedLocalDateTime.monthsUntil(packedDate, packedStartDate) / n;
                    numberColumn.set(i, result);
                    continue block8;
                }
                case YEARS: {
                    long result = PackedLocalDateTime.yearsUntil(packedDate, packedStartDate) / n;
                    numberColumn.set(i, result);
                    continue block8;
                }
                default: {
                    throw new UnsupportedTemporalTypeException("The ChronoUnit " + unit + " is not supported for timeWindows on dates");
                }
            }
        }
        numberColumn.setPrintFormatter(NumberColumnFormatter.ints());
        return numberColumn;
    }

    default public IntColumn minute() {
        IntColumn newColumn = IntColumn.create(this.name() + "[minute]", this.size());
        for (int r = 0; r < this.size(); ++r) {
            if (this.isMissing(r)) continue;
            long c1 = this.getLongInternal(r);
            newColumn.set(r, PackedLocalDateTime.getMinute(c1));
        }
        return newColumn;
    }

    default public LongColumn timeWindow(ChronoUnit unit, int n) {
        return this.timeWindow(unit, n, (LocalDateTime)this.min());
    }
}

