/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.time.LocalDate;
import java.time.LocalDateTime;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.columns.datetimes.DateTimePredicates;
import tech.tablesaw.columns.datetimes.PackedLocalDateTime;
import tech.tablesaw.columns.temporal.TemporalFilters;
import tech.tablesaw.columns.temporal.TemporalPredicates;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface DateTimeFilters
extends TemporalFilters<LocalDateTime> {
    default public Selection isAfter(LocalDateTime value) {
        return this.eval(TemporalPredicates.isGreaterThan, PackedLocalDateTime.pack(value));
    }

    default public Selection isAfter(LocalDate value) {
        return this.isAfter(value.atStartOfDay());
    }

    default public Selection isOnOrAfter(LocalDate value) {
        return this.isOnOrAfter(value.atStartOfDay());
    }

    default public Selection isOnOrAfter(LocalDateTime value) {
        return this.eval(TemporalPredicates.isGreaterThanOrEqualTo, PackedLocalDateTime.pack(value));
    }

    default public Selection isBefore(LocalDateTime value) {
        return this.eval(TemporalPredicates.isLessThan, PackedLocalDateTime.pack(value));
    }

    default public Selection isBefore(LocalDate value) {
        return this.isBefore(value.atStartOfDay());
    }

    default public Selection isOnOrBefore(LocalDate value) {
        return this.isOnOrBefore(value.atStartOfDay());
    }

    default public Selection isOnOrBefore(LocalDateTime value) {
        return this.eval(TemporalPredicates.isLessThanOrEqualTo, PackedLocalDateTime.pack(value));
    }

    default public Selection isAfter(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator intIterator = column.longIterator();
        LongListIterator longListIterator = this.data().iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next > intIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isBefore(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator intIterator = column.longIterator();
        LongListIterator longListIterator = this.data().iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next < intIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isEqualTo(LocalDateTime value) {
        long packed = PackedLocalDateTime.pack(value);
        return this.eval(TemporalPredicates.isEqualTo, packed);
    }

    default public Selection isNotEqualTo(LocalDateTime value) {
        long packed = PackedLocalDateTime.pack(value);
        return this.eval(TemporalPredicates.isNotEqualTo, packed);
    }

    default public Selection isEqualTo(DateTimeColumn column) {
        BitmapBackedSelection results = new BitmapBackedSelection();
        int i = 0;
        LongIterator intIterator = column.longIterator();
        LongListIterator longListIterator = this.data().iterator();
        while (longListIterator.hasNext()) {
            long next = (Long)longListIterator.next();
            if (next == intIterator.nextLong()) {
                results.add(i);
            }
            ++i;
        }
        return results;
    }

    default public Selection isNotEqualTo(DateTimeColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isEqualTo(column));
    }

    default public Selection isOnOrAfter(DateTimeColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isBefore(column));
    }

    default public Selection isOnOrBefore(DateTimeColumn column) {
        Selection results = Selection.withRange(0, this.size());
        return results.andNot(this.isAfter(column));
    }

    default public Selection isMonday() {
        return this.eval(PackedLocalDateTime::isMonday);
    }

    default public Selection isTuesday() {
        return this.eval(PackedLocalDateTime::isTuesday);
    }

    default public Selection isWednesday() {
        return this.eval(PackedLocalDateTime::isWednesday);
    }

    default public Selection isThursday() {
        return this.eval(PackedLocalDateTime::isThursday);
    }

    default public Selection isFriday() {
        return this.eval(PackedLocalDateTime::isFriday);
    }

    default public Selection isSaturday() {
        return this.eval(PackedLocalDateTime::isSaturday);
    }

    default public Selection isSunday() {
        return this.eval(PackedLocalDateTime::isSunday);
    }

    default public Selection isInJanuary() {
        return this.eval(PackedLocalDateTime::isInJanuary);
    }

    default public Selection isInFebruary() {
        return this.eval(PackedLocalDateTime::isInFebruary);
    }

    default public Selection isInMarch() {
        return this.eval(PackedLocalDateTime::isInMarch);
    }

    default public Selection isInApril() {
        return this.eval(PackedLocalDateTime::isInApril);
    }

    default public Selection isInMay() {
        return this.eval(PackedLocalDateTime::isInMay);
    }

    default public Selection isInJune() {
        return this.eval(PackedLocalDateTime::isInJune);
    }

    default public Selection isInJuly() {
        return this.eval(PackedLocalDateTime::isInJuly);
    }

    default public Selection isInAugust() {
        return this.eval(PackedLocalDateTime::isInAugust);
    }

    default public Selection isInSeptember() {
        return this.eval(PackedLocalDateTime::isInSeptember);
    }

    default public Selection isInOctober() {
        return this.eval(PackedLocalDateTime::isInOctober);
    }

    default public Selection isInNovember() {
        return this.eval(PackedLocalDateTime::isInNovember);
    }

    default public Selection isInDecember() {
        return this.eval(PackedLocalDateTime::isInDecember);
    }

    default public Selection isFirstDayOfMonth() {
        return this.eval(PackedLocalDateTime::isFirstDayOfMonth);
    }

    default public Selection isLastDayOfMonth() {
        return this.eval(PackedLocalDateTime::isLastDayOfMonth);
    }

    default public Selection isInQ1() {
        return this.eval(PackedLocalDateTime::isInQ1);
    }

    default public Selection isInQ2() {
        return this.eval(PackedLocalDateTime::isInQ2);
    }

    default public Selection isInQ3() {
        return this.eval(PackedLocalDateTime::isInQ3);
    }

    default public Selection isInQ4() {
        return this.eval(PackedLocalDateTime::isInQ4);
    }

    default public Selection isNoon() {
        return this.eval(PackedLocalDateTime::isNoon);
    }

    default public Selection isMidnight() {
        return this.eval(PackedLocalDateTime::isMidnight);
    }

    default public Selection isBeforeNoon() {
        return this.eval(PackedLocalDateTime::AM);
    }

    default public Selection isAfterNoon() {
        return this.eval(PackedLocalDateTime::PM);
    }

    default public Selection isBetweenExcluding(LocalDateTime lowValue, LocalDateTime highValue) {
        return this.isBetweenExcluding(PackedLocalDateTime.pack(lowValue), PackedLocalDateTime.pack(highValue));
    }

    default public Selection isBetweenIncluding(LocalDateTime lowValue, LocalDateTime highValue) {
        return this.isBetweenIncluding(PackedLocalDateTime.pack(lowValue), PackedLocalDateTime.pack(highValue));
    }

    default public Selection isInYear(int year) {
        return this.eval(DateTimePredicates.isInYear, year);
    }
}

