/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.selection;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.Random;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmap;
import tech.tablesaw.selection.Selection;

public class BitmapBackedSelection
implements Selection {
    private final RoaringBitmap bitmap;

    public BitmapBackedSelection(int size) {
        this.bitmap = new RoaringBitmap();
        this.addRange(0, size);
    }

    public BitmapBackedSelection(int[] arr) {
        this.bitmap = new RoaringBitmap();
        this.add(arr);
    }

    public BitmapBackedSelection(RoaringBitmap bitmap) {
        this.bitmap = bitmap;
    }

    public BitmapBackedSelection() {
        this.bitmap = new RoaringBitmap();
    }

    @Override
    public Selection removeRange(long start, long end) {
        this.bitmap.remove(start, end);
        return this;
    }

    @Override
    public Selection flip(int rangeStart, int rangeEnd) {
        this.bitmap.flip((long)rangeStart, (long)rangeEnd);
        return this;
    }

    @Override
    public Selection add(int ... ints) {
        this.bitmap.add(ints);
        return this;
    }

    public String toString() {
        return "Selection of size: " + this.bitmap.getCardinality();
    }

    @Override
    public int size() {
        return this.bitmap.getCardinality();
    }

    @Override
    public int[] toArray() {
        return this.bitmap.toArray();
    }

    private RoaringBitmap toBitmap(Selection otherSelection) {
        if (otherSelection instanceof BitmapBackedSelection) {
            return ((BitmapBackedSelection)otherSelection).bitmap.clone();
        }
        RoaringBitmap bits = new RoaringBitmap();
        it.unimi.dsi.fastutil.ints.IntIterator intIterator = otherSelection.iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            bits.add(i);
        }
        return bits;
    }

    @Override
    public Selection and(Selection otherSelection) {
        this.bitmap.and(this.toBitmap(otherSelection));
        return this;
    }

    @Override
    public Selection or(Selection otherSelection) {
        this.bitmap.or(this.toBitmap(otherSelection));
        return this;
    }

    @Override
    public Selection andNot(Selection otherSelection) {
        this.bitmap.andNot(this.toBitmap(otherSelection));
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Selection clear() {
        this.bitmap.clear();
        return this;
    }

    @Override
    public boolean contains(int i) {
        return this.bitmap.contains(i);
    }

    @Override
    public Selection addRange(int start, int end) {
        this.bitmap.add((long)start, (long)end);
        return this;
    }

    @Override
    public int get(int i) {
        return this.bitmap.select(i);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitmapBackedSelection integers = (BitmapBackedSelection)o;
        return this.bitmap.equals((Object)integers.bitmap);
    }

    public int hashCode() {
        return this.bitmap.hashCode();
    }

    public it.unimi.dsi.fastutil.ints.IntIterator iterator() {
        return new it.unimi.dsi.fastutil.ints.IntIterator(){
            private final IntIterator iterator;
            {
                this.iterator = BitmapBackedSelection.this.bitmap.getIntIterator();
            }

            public int nextInt() {
                return this.iterator.next();
            }

            public int skip(int k) {
                throw new UnsupportedOperationException("Views do not support skipping in the iterator");
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    protected static Selection with(int ... rows) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int i : rows) {
            selection.add(i);
        }
        return selection;
    }

    protected static Selection withRange(int start, int end) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        selection.addRange(start, end);
        return selection;
    }

    protected static Selection withoutRange(int totalRangeStart, int totalRangeEnd, int excludedRangeStart, int excludedRangeEnd) {
        Preconditions.checkArgument((excludedRangeStart >= totalRangeStart ? 1 : 0) != 0);
        Preconditions.checkArgument((excludedRangeEnd <= totalRangeEnd ? 1 : 0) != 0);
        Preconditions.checkArgument((totalRangeEnd >= totalRangeStart ? 1 : 0) != 0);
        Preconditions.checkArgument((excludedRangeEnd >= excludedRangeStart ? 1 : 0) != 0);
        Selection selection = Selection.withRange(totalRangeStart, totalRangeEnd);
        Selection exclusion = Selection.withRange(excludedRangeStart, excludedRangeEnd);
        selection.andNot(exclusion);
        return selection;
    }

    protected static Selection selectNRowsAtRandom(int n, int max) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        if (n > max) {
            throw new IllegalArgumentException("Illegal arguments: N (" + n + ") greater than Max (" + max + ")");
        }
        int[] rows = new int[n];
        if (n == max) {
            int k = 0;
            while (k < n) {
                selection.add(k++);
            }
            return selection;
        }
        BitSet bs = new BitSet(max);
        int cardinality = 0;
        Random random = new Random();
        while (cardinality < n) {
            int v = random.nextInt(max);
            if (bs.get(v)) continue;
            bs.set(v);
            ++cardinality;
        }
        int pos = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            rows[pos++] = i;
            i = bs.nextSetBit(i + 1);
        }
        for (int row : rows) {
            selection.add(row);
        }
        return selection;
    }
}

