/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class Source {
    protected final File file;
    protected final Reader reader;
    protected final InputStream inputStream;
    protected final Charset charset;

    public Source(File file) {
        this.file = file;
        this.reader = null;
        this.inputStream = null;
        this.charset = Charset.defaultCharset();
    }

    public Source(File file, Charset charset) {
        this.file = file;
        this.reader = null;
        this.inputStream = null;
        this.charset = charset;
    }

    public Source(Reader reader) {
        this.file = null;
        this.reader = reader;
        this.inputStream = null;
        this.charset = null;
    }

    public Source(InputStream inputStream) {
        this.file = null;
        this.reader = null;
        this.inputStream = inputStream;
        this.charset = Charset.defaultCharset();
    }

    public Source(InputStream inputStream, Charset charset) {
        this.file = null;
        this.reader = null;
        this.inputStream = inputStream;
        this.charset = charset;
    }

    public static Source fromString(String s) {
        return new Source(new StringReader(s));
    }

    public static Source fromUrl(String url) throws IOException {
        return new Source(new StringReader(Source.loadUrl(url)));
    }

    public File file() {
        return this.file;
    }

    public Reader reader() {
        return this.reader;
    }

    public InputStream inputStream() {
        return this.inputStream;
    }

    public Reader createReader(byte[] cachedBytes) throws IOException {
        if (cachedBytes != null) {
            return new InputStreamReader(new ByteArrayInputStream(cachedBytes));
        }
        if (this.inputStream != null) {
            return new InputStreamReader(this.inputStream, this.charset);
        }
        if (this.reader != null) {
            return this.reader;
        }
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset);
    }

    private static String loadUrl(String url) throws IOException {
        try (Scanner scanner = new Scanner(new URL(url).openStream(), StandardCharsets.UTF_8.toString());){
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }
}

