/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.temporal;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.time.temporal.Temporal;
import java.util.function.BiPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import tech.tablesaw.api.DateTimeColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.columns.instant.PackedInstant;
import tech.tablesaw.columns.temporal.TemporalPredicates;
import tech.tablesaw.filtering.predicates.LongBiPredicate;
import tech.tablesaw.selection.BitmapBackedSelection;
import tech.tablesaw.selection.Selection;

public interface TemporalFilters<T extends Temporal>
extends Column<T> {
    default public Selection eval(LongPredicate predicate) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            long next = this.data().getLong(idx);
            if (!predicate.test(next)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    default public Selection eval(LongBiPredicate predicate, long value) {
        BitmapBackedSelection bitmap = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            long next = this.data().getLong(idx);
            if (!predicate.test(next, value)) continue;
            bitmap.add(idx);
        }
        return bitmap;
    }

    default public Selection eval(LongBiPredicate predicate, DateTimeColumn otherColumn) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.getLongInternal(idx), otherColumn.getLongInternal(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(BiPredicate<T, T> predicate, T valueToCompare) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx), valueToCompare)) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection eval(Predicate<T> predicate) {
        BitmapBackedSelection selection = new BitmapBackedSelection();
        for (int idx = 0; idx < this.size(); ++idx) {
            if (!predicate.test(this.get(idx))) continue;
            selection.add(idx);
        }
        return selection;
    }

    default public Selection isBetweenExcluding(long lowPackedDateTime, long highPackedDateTime) {
        return this.eval(PackedInstant::isAfter, lowPackedDateTime).and(this.eval(PackedInstant::isBefore, highPackedDateTime));
    }

    default public Selection isBetweenIncluding(long lowPackedDateTime, long highPackedDateTime) {
        return this.eval(PackedInstant::isOnOrAfter, lowPackedDateTime).and(this.eval(PackedInstant::isOnOrBefore, highPackedDateTime));
    }

    @Override
    default public Selection isMissing() {
        return this.eval(TemporalPredicates.isMissing);
    }

    @Override
    default public Selection isNotMissing() {
        return this.eval(TemporalPredicates.isNotMissing);
    }

    @Override
    public int size();

    public LongArrayList data();

    public long getLongInternal(int var1);

    @Override
    public T get(int var1);
}

