/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.numbers.fillers;

import it.unimi.dsi.fastutil.doubles.DoubleIterator;
import it.unimi.dsi.fastutil.ints.IntIterator;

public class DoubleRangeIterable
implements Iterable<Double> {
    private final double from;
    private final double to;
    private final double by;
    private final boolean including;
    private final int count;

    private DoubleRangeIterable(double from, double to, boolean including, double by, int count) {
        this.from = from;
        this.to = to;
        this.including = including;
        this.by = by;
        this.count = count;
    }

    private static DoubleRangeIterable range(double from, double to, double by, int count) {
        return new DoubleRangeIterable(from, to, false, by, count);
    }

    public static DoubleRangeIterable range(double from, double to, double by) {
        return DoubleRangeIterable.range(from, to, by, -1);
    }

    public static DoubleRangeIterable range(double from, double to) {
        return DoubleRangeIterable.range(from, to, 1.0);
    }

    public static DoubleRangeIterable range(double from, double by, int count) {
        return DoubleRangeIterable.range(from, Double.NaN, by, count);
    }

    public static DoubleRangeIterable range(double from, int count) {
        return DoubleRangeIterable.range(from, 1.0, count);
    }

    public DoubleIterator iterator() {
        return new DoubleIterator(){
            double next;
            int num;
            {
                this.next = DoubleRangeIterable.this.from;
                this.num = 0;
            }

            public boolean hasNext() {
                return (DoubleRangeIterable.this.count < 0 || this.num < DoubleRangeIterable.this.count) && (Double.isNaN(DoubleRangeIterable.this.to) || Math.abs(this.next - DoubleRangeIterable.this.from) < Math.abs(DoubleRangeIterable.this.to - DoubleRangeIterable.this.from) || DoubleRangeIterable.this.including && this.next == DoubleRangeIterable.this.to);
            }

            public double nextDouble() {
                double current = this.next;
                this.next += DoubleRangeIterable.this.by;
                ++this.num;
                return current;
            }
        };
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            int next;
            int num;
            {
                this.next = (int)DoubleRangeIterable.this.from;
                this.num = 0;
            }

            public boolean hasNext() {
                return (DoubleRangeIterable.this.count < 0 || this.num < DoubleRangeIterable.this.count) && (Double.isNaN(DoubleRangeIterable.this.to) || Math.abs((double)this.next - DoubleRangeIterable.this.from) < Math.abs(DoubleRangeIterable.this.to - DoubleRangeIterable.this.from) || DoubleRangeIterable.this.including && (double)this.next == DoubleRangeIterable.this.to);
            }

            public int nextInt() {
                int current = this.next;
                this.next = (int)((double)this.next + DoubleRangeIterable.this.by);
                ++this.num;
                return current;
            }
        };
    }
}

