/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.instant;

import com.google.common.base.Strings;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.datetimes.DateTimePredicates;
import tech.tablesaw.columns.times.PackedLocalTime;

public class PackedInstant {
    protected PackedInstant() {
    }

    public static Instant asInstant(long dateTime) {
        if (dateTime == DateTimeColumnType.missingValueIndicator()) {
            return null;
        }
        int date = PackedInstant.date(dateTime);
        int time = PackedInstant.time(dateTime);
        LocalDate d = PackedLocalDate.asLocalDate(date);
        LocalTime t = PackedLocalTime.asLocalTime(time);
        if (d == null || t == null) {
            return null;
        }
        return LocalDateTime.of(d, t).toInstant(ZoneOffset.UTC);
    }

    protected static long pack(LocalDate date, LocalTime time) {
        if (date == null || time == null) {
            return DateTimeColumnType.missingValueIndicator();
        }
        int d = PackedLocalDate.pack(date);
        int t = PackedLocalTime.pack(time);
        return (long)d << 32 | (long)t & 0xFFFFFFFFL;
    }

    public static long pack(Instant instant) {
        if (instant == null) {
            return DateTimeColumnType.missingValueIndicator();
        }
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        LocalDate date = dateTime.toLocalDate();
        LocalTime time = dateTime.toLocalTime();
        return PackedInstant.pack(date, time);
    }

    public static int date(long packedDateTIme) {
        return (int)(packedDateTIme >> 32);
    }

    public static int time(long packedDateTIme) {
        return (int)packedDateTIme;
    }

    public static String toString(long dateTime) {
        if (dateTime == Long.MIN_VALUE) {
            return "";
        }
        int date = PackedInstant.date(dateTime);
        int time = PackedInstant.time(dateTime);
        return "" + PackedLocalDate.getYear(date) + "-" + Strings.padStart((String)Byte.toString(PackedLocalDate.getMonthValue(date)), (int)2, (char)'0') + "-" + Strings.padStart((String)Byte.toString(PackedLocalDate.getDayOfMonth(date)), (int)2, (char)'0') + "T" + Strings.padStart((String)Byte.toString(PackedLocalTime.getHour(time)), (int)2, (char)'0') + ":" + Strings.padStart((String)Byte.toString(PackedLocalTime.getMinute(time)), (int)2, (char)'0') + ":" + Strings.padStart((String)Byte.toString(PackedLocalTime.getSecond(time)), (int)2, (char)'0') + "." + Strings.padStart((String)String.valueOf(PackedLocalTime.getMilliseconds(time)), (int)3, (char)'0');
    }

    public static long plus(long packedDateTime, long amountToAdd, TemporalUnit unit) {
        Instant dateTime = PackedInstant.asInstant(packedDateTime);
        return PackedInstant.pack(dateTime.plus(amountToAdd, unit));
    }

    public static boolean isAfter(long packedDateTime, long value) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && packedDateTime > value;
    }

    public static boolean isBefore(long packedDateTime, long value) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && packedDateTime < value;
    }

    public static long create(int date, int time) {
        return (long)date << 32 | (long)time & 0xFFFFFFFFL;
    }

    public static long minutesUntil(long packedDateTimeEnd, long packedDateTimeStart) {
        return ChronoUnit.MINUTES.between(PackedInstant.asInstant(packedDateTimeStart), PackedInstant.asInstant(packedDateTimeEnd));
    }

    public static long hoursUntil(long packedDateTimeEnd, long packedDateTimeStart) {
        return ChronoUnit.HOURS.between(PackedInstant.asInstant(packedDateTimeStart), PackedInstant.asInstant(packedDateTimeEnd));
    }

    public static int daysUntil(long packedDateTimeEnd, long packedDateTimeStart) {
        return (int)(PackedLocalDate.toEpochDay(PackedInstant.date(packedDateTimeEnd)) - PackedLocalDate.toEpochDay(PackedInstant.date(packedDateTimeStart)));
    }

    public static int weeksUntil(long packedDateTimeEnd, long packedDateStart) {
        return PackedInstant.daysUntil(packedDateTimeEnd, packedDateStart) / 7;
    }

    public static boolean isEqualTo(long packedDateTime, long value) {
        return DateTimePredicates.isEqualTo.test(packedDateTime, value);
    }

    public static boolean isOnOrAfter(long valueToTest, long valueToTestAgainst) {
        return valueToTest >= valueToTestAgainst;
    }

    public static boolean isOnOrBefore(long valueToTest, long valueToTestAgainst) {
        return PackedInstant.isBefore(valueToTest, valueToTestAgainst) || PackedInstant.isEqualTo(valueToTest, valueToTestAgainst);
    }
}

