/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.aggregate;

import com.google.common.collect.TreeBasedTable;
import tech.tablesaw.api.CategoricalColumn;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.DoubleColumn;
import tech.tablesaw.api.IntColumn;
import tech.tablesaw.api.StringColumn;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.Column;

public final class CrossTab {
    private static final String LABEL_COLUMN_NAME = "[labels]";

    public static Table counts(Table table, CategoricalColumn<?> column1, CategoricalColumn<?> column2) {
        Table t = Table.create("Crosstab Counts: " + column1.name() + " x " + column2.name());
        t.addColumns(new Column[]{column1.type().create(LABEL_COLUMN_NAME)});
        Table temp = table.sortOn(column1.name(), column2.name());
        int colIndex1 = table.columnIndex(column1.name());
        int colIndex2 = table.columnIndex(column2.name());
        TreeBasedTable gTable = TreeBasedTable.create();
        for (int row = 0; row < table.rowCount(); ++row) {
            String b;
            String a = temp.column(colIndex1).getString(row);
            Integer cellValue = (Integer)gTable.get((Object)a, (Object)(b = temp.column(colIndex2).getString(row)));
            Integer value = cellValue != null ? Integer.valueOf(cellValue + 1) : Integer.valueOf(1);
            gTable.put((Object)a, (Object)b, (Object)value);
        }
        for (Object colName : gTable.columnKeySet()) {
            t.addColumns(new Column[]{IntColumn.create((String)colName)});
        }
        t.addColumns(new Column[]{IntColumn.create("total")});
        int[] columnTotals = new int[t.columnCount()];
        for (String rowKey : gTable.rowKeySet()) {
            t.column(0).appendCell(rowKey);
            int rowSum = 0;
            for (String colKey : gTable.columnKeySet()) {
                Integer cellValue = (Integer)gTable.get((Object)rowKey, (Object)colKey);
                if (cellValue != null) {
                    int colIdx = t.columnIndex(colKey);
                    t.intColumn(colIdx).append(cellValue);
                    rowSum += cellValue.intValue();
                    columnTotals[colIdx] = columnTotals[colIdx] + cellValue;
                    continue;
                }
                t.intColumn(colKey).append(0);
            }
            t.intColumn(t.columnCount() - 1).append(rowSum);
        }
        if (t.column(0).type().equals(ColumnType.STRING)) {
            t.column(0).appendCell("Total");
        } else {
            t.column(0).appendCell("");
        }
        int grandTotal = 0;
        for (int i = 1; i < t.columnCount() - 1; ++i) {
            t.intColumn(i).append(columnTotals[i]);
            grandTotal += columnTotals[i];
        }
        t.intColumn(t.columnCount() - 1).append(grandTotal);
        return t;
    }

    public static Table counts(Table table, String columnName) {
        return table.countBy(table.categoricalColumn(columnName));
    }

    public static Table percents(Table table, String column1) {
        Table countTable = CrossTab.counts(table, column1);
        Table percentTable = Table.create(countTable.name());
        percentTable.addColumns(new Column[]{countTable.column(0).copy()});
        IntColumn countsColumn = countTable.intColumn("Count");
        DoubleColumn pctsColumn = DoubleColumn.create("Percents");
        double sum = countsColumn.sum();
        for (int i = 0; i < countsColumn.size(); ++i) {
            pctsColumn.append(countsColumn.getDouble(i) / sum);
        }
        percentTable.addColumns(new Column[]{pctsColumn});
        return percentTable;
    }

    private static Table rowPercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Row Proportions: ");
        StringColumn labels = StringColumn.create(LABEL_COLUMN_NAME);
        pctTable.addColumns(new Column[]{labels});
        for (int i2 = 0; i2 < xTabCounts.rowCount(); ++i2) {
            labels.append(xTabCounts.column(0).getString(i2));
        }
        Column[] newColumns = new DoubleColumn[xTabCounts.columnCount() - 1];
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            Column<?> column = xTabCounts.column(i);
            newColumns[i - 1] = DoubleColumn.create(column.name());
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            double rowTotal = xTabCounts.numberColumn(xTabCounts.columnCount() - 1).getDouble(i);
            for (int c = 0; c < newColumns.length; ++c) {
                if (rowTotal == 0.0) {
                    ((DoubleColumn)newColumns[c]).append(Double.NaN);
                    continue;
                }
                ((DoubleColumn)newColumns[c]).append(xTabCounts.numberColumn(c + 1).getDouble(i) / rowTotal);
            }
        }
        pctTable.addColumns(newColumns);
        return pctTable;
    }

    private static Table tablePercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Table Proportions: ");
        StringColumn labels = StringColumn.create(LABEL_COLUMN_NAME);
        pctTable.addColumns(new Column[]{labels});
        double grandTotal = xTabCounts.numberColumn(xTabCounts.columnCount() - 1).getDouble(xTabCounts.rowCount() - 1);
        for (int i2 = 0; i2 < xTabCounts.rowCount(); ++i2) {
            labels.append(xTabCounts.column(0).getString(i2));
        }
        Column[] newColumns = new DoubleColumn[xTabCounts.columnCount() - 1];
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            Column<?> column = xTabCounts.column(i);
            newColumns[i - 1] = DoubleColumn.create(column.name());
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            for (int c = 0; c < newColumns.length; ++c) {
                if (grandTotal == 0.0) {
                    ((DoubleColumn)newColumns[c]).append(Double.NaN);
                    continue;
                }
                ((DoubleColumn)newColumns[c]).append(xTabCounts.numberColumn(c + 1).getDouble(i) / grandTotal);
            }
        }
        pctTable.addColumns(newColumns);
        return pctTable;
    }

    private static Table columnPercents(Table xTabCounts) {
        int i;
        Table pctTable = Table.create("Crosstab Column Proportions: ");
        StringColumn labels = StringColumn.create(LABEL_COLUMN_NAME);
        pctTable.addColumns(new Column[]{labels});
        for (int i2 = 0; i2 < xTabCounts.rowCount(); ++i2) {
            labels.append(xTabCounts.column(0).getString(i2));
        }
        Column[] newColumns = new DoubleColumn[xTabCounts.columnCount() - 1];
        for (int i3 = 1; i3 < xTabCounts.columnCount(); ++i3) {
            Column<?> column = xTabCounts.column(i3);
            newColumns[i3 - 1] = DoubleColumn.create(column.name());
        }
        double[] columnTotals = new double[newColumns.length];
        int totalRow = xTabCounts.rowCount() - 1;
        for (i = 1; i < xTabCounts.columnCount(); ++i) {
            columnTotals[i - 1] = xTabCounts.numberColumn(i).getDouble(totalRow);
        }
        for (i = 0; i < xTabCounts.rowCount(); ++i) {
            for (int c = 0; c < newColumns.length; ++c) {
                if (columnTotals[c] == 0.0) {
                    ((DoubleColumn)newColumns[c]).append(Double.NaN);
                    continue;
                }
                ((DoubleColumn)newColumns[c]).append(xTabCounts.numberColumn(c + 1).getDouble(i) / columnTotals[c]);
            }
        }
        pctTable.addColumns(newColumns);
        return pctTable;
    }

    public static Table columnPercents(Table table, CategoricalColumn<?> column1, CategoricalColumn<?> column2) {
        Table xTabs = CrossTab.counts(table, column1, column2);
        return CrossTab.columnPercents(xTabs);
    }

    public static Table columnPercents(Table table, String column1, String column2) {
        return CrossTab.columnPercents(table, table.categoricalColumn(column1), table.categoricalColumn(column2));
    }

    public static Table rowPercents(Table table, CategoricalColumn<?> column1, CategoricalColumn<?> column2) {
        Table xTabs = CrossTab.counts(table, column1, column2);
        return CrossTab.rowPercents(xTabs);
    }

    public static Table rowPercents(Table table, String column1, String column2) {
        return CrossTab.rowPercents(table, table.categoricalColumn(column1), table.categoricalColumn(column2));
    }

    public static Table tablePercents(Table table, CategoricalColumn<?> column1, CategoricalColumn<?> column2) {
        Table xTabs = CrossTab.counts(table, column1, column2);
        return CrossTab.tablePercents(xTabs);
    }

    public static Table tablePercents(Table table, String column1, String column2) {
        return CrossTab.tablePercents(table, table.categoricalColumn(column1), table.categoricalColumn(column2));
    }
}

