/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.booleans;

import tech.tablesaw.api.BooleanColumn;
import tech.tablesaw.columns.Column;
import tech.tablesaw.selection.Selection;

public interface BooleanMapUtils
extends Column<Boolean> {
    default public BooleanColumn and(BooleanColumn ... columns) {
        String name = this.name() + " and: ";
        Selection selection = this.asSelection();
        for (BooleanColumn column : columns) {
            if (!column.name().equals(columns[0].name())) {
                name = name + ", ";
            }
            name = name + column.name();
            selection.and(column.asSelection());
        }
        return BooleanColumn.create(name, selection, this.size());
    }

    default public BooleanColumn or(BooleanColumn ... columns) {
        String name = this.name() + " or: ";
        Selection selection = this.asSelection();
        for (BooleanColumn column : columns) {
            if (!column.name().equals(columns[0].name())) {
                name = name + ", ";
            }
            name = name + column.name();
            selection.or(column.asSelection());
        }
        return BooleanColumn.create(name, selection, this.size());
    }

    default public BooleanColumn andNot(BooleanColumn ... columns) {
        String name = this.name() + " and not: ";
        Selection selection = this.asSelection();
        for (BooleanColumn column : columns) {
            if (!column.name().equals(columns[0].name())) {
                name = name + ", ";
            }
            name = name + column.name();
            selection.andNot(column.asSelection());
        }
        return BooleanColumn.create(name, selection, this.size());
    }

    public Selection asSelection();
}

