/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io.string;

import java.io.IOException;
import java.io.OutputStream;
import java.util.stream.IntStream;
import tech.tablesaw.table.Relation;
import tech.tablesaw.util.StringUtils;

public class DataFramePrinter {
    private final int maxRows;
    private final OutputStream stream;

    public DataFramePrinter(int maxRows, OutputStream stream) {
        this.maxRows = maxRows;
        this.stream = stream;
    }

    private static int[] getWidths(String[] headers, String[][] data) {
        int[] widths = new int[headers.length];
        for (int j = 0; j < headers.length; ++j) {
            String header = headers[j];
            widths[j] = Math.max(widths[j], header != null ? header.length() : 0);
        }
        for (String[] rowValues : data) {
            for (int j = 0; j < rowValues.length; ++j) {
                String value = rowValues[j];
                widths[j] = Math.max(widths[j], value != null ? value.length() : 0);
            }
        }
        return widths;
    }

    private static String getHeaderTemplate(int[] widths, String[] headers) {
        return IntStream.range(0, widths.length).mapToObj(i -> {
            int width = widths[i];
            int length = headers[i].length();
            int leading = (width - length) / 2;
            int trailing = width - (length + leading);
            StringBuilder text = new StringBuilder();
            DataFramePrinter.whitespace(text, leading + 1);
            text.append("%").append(i + 1).append("$s");
            DataFramePrinter.whitespace(text, trailing);
            text.append("  |");
            return text.toString();
        }).reduce((left, right) -> left + " " + right).orElse("");
    }

    private static String getDataTemplate(int[] widths) {
        return IntStream.range(0, widths.length).mapToObj(i -> " %" + (i + 1) + "$" + widths[i] + "s  |").reduce((left, right) -> left + " " + right).orElse("");
    }

    private static void whitespace(StringBuilder text, int length) {
        IntStream.range(0, length).forEach(i -> text.append(" "));
    }

    public void print(Relation frame) {
        try {
            String[] headers = this.getHeaderTokens(frame);
            String[][] data = this.getDataTokens(frame);
            int[] widths = DataFramePrinter.getWidths(headers, data);
            String dataTemplate = DataFramePrinter.getDataTemplate(widths);
            String headerTemplate = DataFramePrinter.getHeaderTemplate(widths, headers);
            int totalWidth = IntStream.of(widths).map(w -> w + 5).sum() - 1;
            int totalHeight = data.length + 1;
            int capacity = totalWidth * totalHeight;
            if (capacity < 0) {
                capacity = 0;
            }
            StringBuilder text = new StringBuilder(capacity);
            if (frame.name() != null) {
                text.append(this.tableName(frame, totalWidth)).append(System.lineSeparator());
            }
            String headerLine = String.format(headerTemplate, headers);
            text.append(headerLine).append(System.lineSeparator());
            for (int j = 0; j < totalWidth; ++j) {
                text.append("-");
            }
            for (String[] row : data) {
                String dataLine = String.format(dataTemplate, row);
                text.append(System.lineSeparator());
                text.append(dataLine);
            }
            byte[] bytes = text.toString().getBytes();
            this.stream.write(bytes);
            this.stream.flush();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to print DataFrame", ex);
        }
    }

    private String tableName(Relation frame, int width) {
        if (frame.name().length() > width) {
            return frame.name();
        }
        int diff = width - frame.name().length();
        String result = StringUtils.repeat(" ", diff / 2) + frame.name();
        return result + StringUtils.repeat(" ", width - result.length());
    }

    private String[] getHeaderTokens(Relation frame) {
        int colCount = frame.columnCount();
        String[] header = new String[colCount];
        IntStream.range(0, colCount).forEach(colIndex -> {
            header[colIndex] = frame.column(colIndex).name();
        });
        return header;
    }

    private String[][] getDataTokens(Relation frame) {
        if (frame.rowCount() == 0) {
            return new String[0][0];
        }
        int rowCount = Math.min(this.maxRows, frame.rowCount());
        boolean truncated = frame.rowCount() > this.maxRows;
        int colCount = frame.columnCount();
        String[][] data = new String[rowCount][colCount];
        if (truncated) {
            int j;
            int i;
            for (i = 0; i < rowCount / 2; ++i) {
                for (j = 0; j < colCount; ++j) {
                    data[i][j] = frame.getString(i, j);
                }
            }
            for (j = 0; j < colCount; ++j) {
                data[i][j] = "...";
            }
            ++i;
            while (i < rowCount) {
                for (j = 0; j < colCount; ++j) {
                    data[i][j] = frame.getString(frame.rowCount() - this.maxRows + i, j);
                }
                ++i;
            }
        } else {
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < colCount; ++j) {
                    String value = frame.getString(i, j);
                    data[i][j] = value == null ? "" : value;
                }
            }
        }
        return data;
    }
}

