/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.SQLException;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;
import tech.tablesaw.io.fixed.FixedWidthReadOptions;
import tech.tablesaw.io.fixed.FixedWidthReader;
import tech.tablesaw.io.jdbc.SqlResultSetReader;

public class DataFrameReader {
    private final ReaderRegistry registry;

    public DataFrameReader(ReaderRegistry registry) {
        this.registry = registry;
    }

    public Table url(String url) throws IOException {
        return this.url(new URL(url));
    }

    public Table url(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        String mimeType = connection.getContentType();
        DataReader<?> reader = this.registry.getReaderForMimeType(mimeType);
        return reader.read(new Source(connection.getInputStream()));
    }

    public Table string(String s, String fileExtension) {
        DataReader<?> reader = this.registry.getReaderForExtension(fileExtension);
        try {
            return reader.read(Source.fromString(s));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Table file(String file) throws IOException {
        return this.file(new File(file));
    }

    public Table file(File file) throws IOException {
        String extension = Files.getFileExtension((String)file.getCanonicalPath());
        DataReader<?> reader = this.registry.getReaderForExtension(extension);
        return reader.read(new Source(file));
    }

    public <T extends ReadOptions> Table usingOptions(T options) throws IOException {
        DataReader<T> reader = this.registry.getReaderForOptions(options);
        return reader.read(options);
    }

    public Table usingOptions(ReadOptions.Builder builder) throws IOException {
        return this.usingOptions(builder.build());
    }

    public Table db(ResultSet resultSet) throws SQLException {
        return SqlResultSetReader.read(resultSet);
    }

    public Table db(ResultSet resultSet, String tableName) throws SQLException {
        Table table = SqlResultSetReader.read(resultSet);
        table.setName(tableName);
        return table;
    }

    public Table csv(String file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(String contents, String tableName) {
        try {
            return this.csv(CsvReadOptions.builder(new StringReader(contents)).tableName(tableName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table csv(File file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(InputStream stream) throws IOException {
        return this.csv(CsvReadOptions.builder(stream));
    }

    public Table csv(Reader reader) throws IOException {
        return this.csv(CsvReadOptions.builder(reader));
    }

    public Table csv(CsvReadOptions.Builder options) throws IOException {
        return this.csv(options.build());
    }

    public Table csv(CsvReadOptions options) throws IOException {
        return new CsvReader().read(options);
    }

    public Table fixedWidth(String file) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(file));
    }

    public Table fixedWidth(File file) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(file));
    }

    public Table fixedWidth(InputStream stream) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(stream));
    }

    public Table fixedWidth(Reader reader) throws IOException {
        return this.fixedWidth(FixedWidthReadOptions.builder(reader));
    }

    public Table fixedWidth(FixedWidthReadOptions.Builder options) throws IOException {
        return this.fixedWidth(options.build());
    }

    public Table fixedWidth(FixedWidthReadOptions options) throws IOException {
        return new FixedWidthReader().read(options);
    }
}

