/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.univocity.parsers.common.AbstractParser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.Table;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.Column;
import tech.tablesaw.io.AddCellToColumnException;
import tech.tablesaw.io.ColumnTypeDetector;
import tech.tablesaw.io.ReadOptions;

public abstract class FileReader {
    private List<ColumnType> typeArrayOverrides = new ArrayList<ColumnType>();

    public FileReader() {
    }

    public FileReader(List<ColumnType> typeDetectionList) {
        this.typeArrayOverrides = typeDetectionList;
    }

    protected ColumnType[] getTypes(Reader reader, ReadOptions options, int linesToSkip, final AbstractParser<?> parser) {
        parser.beginParsing(reader);
        for (int i = 0; i < linesToSkip; ++i) {
            parser.parseNext();
        }
        if (options.minimizeColumnSizes()) {
            this.typeArrayOverrides = ReadOptions.EXTENDED_TYPE_ARRAY;
        }
        ColumnTypeDetector detector = this.typeArrayOverrides.isEmpty() ? new ColumnTypeDetector() : new ColumnTypeDetector(this.typeArrayOverrides);
        return detector.detectColumnTypes(new Iterator<String[]>(){
            String[] nextRow;
            {
                this.nextRow = parser.parseNext();
            }

            @Override
            public boolean hasNext() {
                return this.nextRow != null;
            }

            @Override
            public String[] next() {
                String[] tmp = this.nextRow;
                this.nextRow = parser.parseNext();
                return tmp;
            }
        }, options);
    }

    private String cleanName(String name) {
        return name.trim();
    }

    private String[] getHeaderNames(ReadOptions options, ColumnType[] types, AbstractParser<?> parser) {
        if (options.header()) {
            String[] headerNames = parser.parseNext();
            for (int i = 0; i < headerNames.length; ++i) {
                if (headerNames[i] != null) continue;
                headerNames[i] = "C" + i;
            }
            return headerNames;
        }
        String[] headerNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            headerNames[i] = "C" + i;
        }
        return headerNames;
    }

    protected Table parseRows(ReadOptions options, boolean headerOnly, Reader reader, ColumnType[] types, AbstractParser<?> parser) {
        parser.beginParsing(reader);
        Table table = Table.create(options.tableName());
        ArrayList headerRow = Lists.newArrayList((Object[])this.getHeaderNames(options, types, parser));
        for (int x = 0; x < types.length; ++x) {
            if (types[x] == ColumnType.SKIP) continue;
            String columnName = this.cleanName((String)headerRow.get(x));
            if (Strings.isNullOrEmpty((String)columnName)) {
                columnName = "Column " + table.columnCount();
            }
            Column<?> newColumn = types[x].create(columnName);
            table.addColumns(new Column[]{newColumn});
        }
        if (!headerOnly) {
            String[] columnNames = this.selectColumnNames(headerRow, types);
            int[] columnIndexes = new int[columnNames.length];
            for (int i = 0; i < columnIndexes.length; ++i) {
                columnIndexes[i] = headerRow.indexOf(columnNames[i]);
            }
            this.addRows(options, types, parser, table, columnIndexes);
        }
        return table;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addRows(ReadOptions options, ColumnType[] types, AbstractParser<?> reader, Table table, int[] columnIndexes) {
        long rowNumber;
        Map<String, AbstractColumnParser<?>> parserMap = this.getParserMap(options, table);
        long l = rowNumber = options.header() ? 1L : 0L;
        while (true) {
            block9: {
                String[] nextLine;
                if ((nextLine = reader.parseNext()) == null) {
                    return;
                }
                if (nextLine.length < types.length) {
                    if (nextLine.length == 1 && Strings.isNullOrEmpty((String)nextLine[0])) {
                        System.err.println("Warning: Invalid file. Row " + rowNumber + " is empty. Continuing.");
                        break block9;
                    } else {
                        IndexOutOfBoundsException e = new IndexOutOfBoundsException("Row number " + rowNumber + " contains " + nextLine.length + " columns. " + types.length + " expected.");
                        throw new AddCellToColumnException(e, 0, rowNumber, table.columnNames(), nextLine);
                    }
                }
                if (nextLine.length > types.length) {
                    throw new IllegalArgumentException("Row number " + rowNumber + " contains " + nextLine.length + " columns. " + types.length + " expected.");
                }
                int cellIndex = 0;
                int[] nArray = columnIndexes;
                int n = nArray.length;
                for (int i = 0; i < n; ++cellIndex, ++i) {
                    int columnIndex = nArray[i];
                    Column<?> column = table.column(cellIndex);
                    AbstractColumnParser<?> parser = parserMap.get(column.name());
                    try {
                        String value = nextLine[columnIndex];
                        column.appendCell(value, parser);
                        continue;
                    }
                    catch (Exception e) {
                        throw new AddCellToColumnException(e, columnIndex, rowNumber, table.columnNames(), nextLine);
                    }
                }
            }
            ++rowNumber;
        }
    }

    private Map<String, AbstractColumnParser<?>> getParserMap(ReadOptions options, Table table) {
        HashMap parserMap = new HashMap();
        for (Column<?> column : table.columns()) {
            AbstractColumnParser<?> parser = column.type().customParser(options);
            parserMap.put(column.name(), parser);
        }
        return parserMap;
    }

    private String[] selectColumnNames(List<String> names, ColumnType[] types) {
        ArrayList<String> header = new ArrayList<String>();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == ColumnType.SKIP) continue;
            String name = names.get(i);
            name = name.trim();
            header.add(name);
        }
        String[] result = new String[header.size()];
        return header.toArray(result);
    }

    protected String getTypeString(Table structure) {
        StringBuilder buf = new StringBuilder();
        buf.append("ColumnType[] columnTypes = {");
        buf.append(System.lineSeparator());
        Column<?> typeCol = structure.column("Column Type");
        Column<?> indxCol = structure.column("Index");
        Column<?> nameCol = structure.column("Column Name");
        int typeColIndex = structure.columnIndex(typeCol);
        int indxColIndex = structure.columnIndex(indxCol);
        int nameColIndex = structure.columnIndex(nameCol);
        int typeColWidth = typeCol.columnWidth();
        int indxColWidth = indxCol.columnWidth();
        int nameColWidth = nameCol.columnWidth();
        int padChar = 32;
        for (int r = 0; r < structure.rowCount(); ++r) {
            String cell = Strings.padEnd((String)(structure.get(r, typeColIndex) + ","), (int)typeColWidth, (char)' ');
            buf.append(cell);
            buf.append(" // ");
            cell = Strings.padEnd((String)structure.getUnformatted(r, indxColIndex), (int)indxColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            cell = Strings.padEnd((String)structure.getUnformatted(r, nameColIndex), (int)nameColWidth, (char)' ');
            buf.append(cell);
            buf.append(' ');
            buf.append(System.lineSeparator());
        }
        buf.append("}");
        buf.append(System.lineSeparator());
        return buf.toString();
    }
}

