/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataWriter;
import tech.tablesaw.io.Destination;
import tech.tablesaw.io.WriteOptions;
import tech.tablesaw.io.WriterRegistry;
import tech.tablesaw.io.csv.CsvWriteOptions;
import tech.tablesaw.io.csv.CsvWriter;
import tech.tablesaw.io.fixed.FixedWidthWriteOptions;
import tech.tablesaw.io.fixed.FixedWidthWriter;
import tech.tablesaw.io.html.HtmlTableWriter;
import tech.tablesaw.io.json.JsonWriteOptions;
import tech.tablesaw.io.json.JsonWriter;

public class DataFrameWriter {
    private final WriterRegistry registry;
    private final Table table;

    public DataFrameWriter(WriterRegistry registry, Table table) {
        this.registry = registry;
        this.table = table;
    }

    public void toFile(String file) throws IOException {
        this.toFile(new File(file));
    }

    public void toFile(File file) throws IOException {
        String extension = Files.getFileExtension((String)file.getCanonicalPath());
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(file));
    }

    public void toStream(OutputStream stream, String extension) {
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(stream));
    }

    public void toWriter(Writer writer, String extension) {
        DataWriter<?> dataWriter = this.registry.getWriterForExtension(extension);
        dataWriter.write(this.table, new Destination(writer));
    }

    public void usingOptions(WriteOptions options) {
        DataWriter<?> dataWriter = this.registry.getWriterForOptions(options);
        dataWriter.write(this.table, options.destination());
    }

    public void csv(String file) throws IOException {
        CsvWriteOptions options = CsvWriteOptions.builder(file).build();
        new CsvWriter().write(this.table, options);
    }

    public void csv(File file) throws IOException {
        CsvWriteOptions options = CsvWriteOptions.builder(file).build();
        new CsvWriter().write(this.table, options);
    }

    public void csv(CsvWriteOptions options) {
        new CsvWriter().write(this.table, options);
    }

    public void csv(OutputStream stream) {
        CsvWriteOptions options = CsvWriteOptions.builder(stream).build();
        new CsvWriter().write(this.table, options);
    }

    public void csv(Writer writer) {
        CsvWriteOptions options = CsvWriteOptions.builder(writer).build();
        new CsvWriter().write(this.table, options);
    }

    public void fixedWidth(String file) throws IOException {
        FixedWidthWriteOptions options = FixedWidthWriteOptions.builder(file).build();
        new FixedWidthWriter(options).write(this.table);
    }

    public void fixedWidth(File file) throws IOException {
        FixedWidthWriteOptions options = FixedWidthWriteOptions.builder(file).build();
        new FixedWidthWriter(options).write(this.table);
    }

    public void fixedWidth(FixedWidthWriteOptions options) {
        new FixedWidthWriter(options).write(this.table);
    }

    public void fixedWidth(OutputStream stream) {
        FixedWidthWriteOptions options = FixedWidthWriteOptions.builder(stream).build();
        new FixedWidthWriter(options).write(this.table);
    }

    public void fixedWidth(Writer writer) {
        FixedWidthWriteOptions options = FixedWidthWriteOptions.builder(writer).build();
        new FixedWidthWriter(options).write(this.table);
    }

    public void html(OutputStream stream) {
        new HtmlTableWriter().write(this.table, stream);
    }

    public String json() throws IOException {
        return this.json(JsonWriteOptions.builder().build());
    }

    public String json(JsonWriteOptions options) throws IOException {
        return new JsonWriter(options).write(this.table);
    }
}

